/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIMetaData;
import org.lwjgl.assimp.AINode;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiScene")
public class AIScene
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MFLAGS;
    public static final int MROOTNODE;
    public static final int MNUMMESHES;
    public static final int MMESHES;
    public static final int MNUMMATERIALS;
    public static final int MMATERIALS;
    public static final int MNUMANIMATIONS;
    public static final int MANIMATIONS;
    public static final int MNUMTEXTURES;
    public static final int MTEXTURES;
    public static final int MNUMLIGHTS;
    public static final int MLIGHTS;
    public static final int MNUMCAMERAS;
    public static final int MCAMERAS;
    public static final int MMETADATA;
    public static final int MNAME;
    public static final int MPRIVATE;

    public AIScene(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIScene.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int mFlags() {
        return AIScene.nmFlags(this.address());
    }

    @Nullable
    @NativeType(value="struct aiNode *")
    public AINode mRootNode() {
        return AIScene.nmRootNode(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumMeshes() {
        return AIScene.nmNumMeshes(this.address());
    }

    @Nullable
    @NativeType(value="struct aiMesh **")
    public PointerBuffer mMeshes() {
        return AIScene.nmMeshes(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumMaterials() {
        return AIScene.nmNumMaterials(this.address());
    }

    @Nullable
    @NativeType(value="struct aiMaterial **")
    public PointerBuffer mMaterials() {
        return AIScene.nmMaterials(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumAnimations() {
        return AIScene.nmNumAnimations(this.address());
    }

    @Nullable
    @NativeType(value="struct aiAnimation **")
    public PointerBuffer mAnimations() {
        return AIScene.nmAnimations(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumTextures() {
        return AIScene.nmNumTextures(this.address());
    }

    @Nullable
    @NativeType(value="struct aiTexture **")
    public PointerBuffer mTextures() {
        return AIScene.nmTextures(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumLights() {
        return AIScene.nmNumLights(this.address());
    }

    @Nullable
    @NativeType(value="struct aiLight **")
    public PointerBuffer mLights() {
        return AIScene.nmLights(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumCameras() {
        return AIScene.nmNumCameras(this.address());
    }

    @Nullable
    @NativeType(value="struct aiCamera **")
    public PointerBuffer mCameras() {
        return AIScene.nmCameras(this.address());
    }

    @Nullable
    @NativeType(value="struct aiMetadata *")
    public AIMetaData mMetaData() {
        return AIScene.nmMetaData(this.address());
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AIScene.nmName(this.address());
    }

    public AIScene mFlags(@NativeType(value="unsigned int") int value) {
        AIScene.nmFlags(this.address(), value);
        return this;
    }

    public AIScene mRootNode(@Nullable @NativeType(value="struct aiNode *") AINode value) {
        AIScene.nmRootNode(this.address(), value);
        return this;
    }

    public AIScene mMeshes(@Nullable @NativeType(value="struct aiMesh **") PointerBuffer value) {
        AIScene.nmMeshes(this.address(), value);
        return this;
    }

    public AIScene mMaterials(@Nullable @NativeType(value="struct aiMaterial **") PointerBuffer value) {
        AIScene.nmMaterials(this.address(), value);
        return this;
    }

    public AIScene mAnimations(@Nullable @NativeType(value="struct aiAnimation **") PointerBuffer value) {
        AIScene.nmAnimations(this.address(), value);
        return this;
    }

    public AIScene mTextures(@Nullable @NativeType(value="struct aiTexture **") PointerBuffer value) {
        AIScene.nmTextures(this.address(), value);
        return this;
    }

    public AIScene mLights(@Nullable @NativeType(value="struct aiLight **") PointerBuffer value) {
        AIScene.nmLights(this.address(), value);
        return this;
    }

    public AIScene mCameras(@Nullable @NativeType(value="struct aiCamera **") PointerBuffer value) {
        AIScene.nmCameras(this.address(), value);
        return this;
    }

    public AIScene mMetaData(@Nullable @NativeType(value="struct aiMetadata *") AIMetaData value) {
        AIScene.nmMetaData(this.address(), value);
        return this;
    }

    public AIScene mName(@NativeType(value="struct aiString") AIString value) {
        AIScene.nmName(this.address(), value);
        return this;
    }

    public AIScene mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    public AIScene set(int mFlags, @Nullable AINode mRootNode, @Nullable PointerBuffer mMeshes, @Nullable PointerBuffer mMaterials, @Nullable PointerBuffer mAnimations, @Nullable PointerBuffer mTextures, @Nullable PointerBuffer mLights, @Nullable PointerBuffer mCameras, @Nullable AIMetaData mMetaData, AIString mName) {
        this.mFlags(mFlags);
        this.mRootNode(mRootNode);
        this.mMeshes(mMeshes);
        this.mMaterials(mMaterials);
        this.mAnimations(mAnimations);
        this.mTextures(mTextures);
        this.mLights(mLights);
        this.mCameras(mCameras);
        this.mMetaData(mMetaData);
        this.mName(mName);
        return this;
    }

    public AIScene set(AIScene src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIScene malloc() {
        return AIScene.wrap(AIScene.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIScene calloc() {
        return AIScene.wrap(AIScene.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIScene create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AIScene.wrap(AIScene.class, MemoryUtil.memAddress(container), container);
    }

    public static AIScene create(long address) {
        return AIScene.wrap(AIScene.class, address);
    }

    @Nullable
    public static AIScene createSafe(long address) {
        return address == 0L ? null : AIScene.wrap(AIScene.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AIScene.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AIScene.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIScene.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIScene.__create(capacity, SIZEOF);
        return AIScene.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AIScene.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIScene.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static AIScene mallocStack() {
        return AIScene.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIScene callocStack() {
        return AIScene.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIScene mallocStack(MemoryStack stack) {
        return AIScene.malloc(stack);
    }

    @Deprecated
    public static AIScene callocStack(MemoryStack stack) {
        return AIScene.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIScene.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIScene.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIScene.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIScene.calloc(capacity, stack);
    }

    public static AIScene malloc(MemoryStack stack) {
        return AIScene.wrap(AIScene.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIScene calloc(MemoryStack stack) {
        return AIScene.wrap(AIScene.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return AIScene.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return AIScene.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)MFLAGS);
    }

    @Nullable
    public static AINode nmRootNode(long struct) {
        return AINode.createSafe(MemoryUtil.memGetAddress(struct + (long)MROOTNODE));
    }

    public static int nmNumMeshes(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMMESHES);
    }

    @Nullable
    public static PointerBuffer nmMeshes(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)MMESHES), AIScene.nmNumMeshes(struct));
    }

    public static int nmNumMaterials(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMMATERIALS);
    }

    @Nullable
    public static PointerBuffer nmMaterials(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)MMATERIALS), AIScene.nmNumMaterials(struct));
    }

    public static int nmNumAnimations(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMANIMATIONS);
    }

    @Nullable
    public static PointerBuffer nmAnimations(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)MANIMATIONS), AIScene.nmNumAnimations(struct));
    }

    public static int nmNumTextures(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMTEXTURES);
    }

    @Nullable
    public static PointerBuffer nmTextures(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)MTEXTURES), AIScene.nmNumTextures(struct));
    }

    public static int nmNumLights(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMLIGHTS);
    }

    @Nullable
    public static PointerBuffer nmLights(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)MLIGHTS), AIScene.nmNumLights(struct));
    }

    public static int nmNumCameras(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMCAMERAS);
    }

    @Nullable
    public static PointerBuffer nmCameras(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)MCAMERAS), AIScene.nmNumCameras(struct));
    }

    @Nullable
    public static AIMetaData nmMetaData(long struct) {
        return AIMetaData.createSafe(MemoryUtil.memGetAddress(struct + (long)MMETADATA));
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static ByteBuffer nmPrivate(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)MPRIVATE), capacity);
    }

    public static void nmFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MFLAGS, value);
    }

    public static void nmRootNode(long struct, @Nullable AINode value) {
        MemoryUtil.memPutAddress(struct + (long)MROOTNODE, MemoryUtil.memAddressSafe(value));
    }

    public static void nmNumMeshes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMMESHES, value);
    }

    public static void nmMeshes(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MMESHES, MemoryUtil.memAddressSafe(value));
        AIScene.nmNumMeshes(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumMaterials(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMMATERIALS, value);
    }

    public static void nmMaterials(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MMATERIALS, MemoryUtil.memAddressSafe(value));
        AIScene.nmNumMaterials(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumAnimations(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMANIMATIONS, value);
    }

    public static void nmAnimations(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MANIMATIONS, MemoryUtil.memAddressSafe(value));
        AIScene.nmNumAnimations(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumTextures(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMTEXTURES, value);
    }

    public static void nmTextures(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MTEXTURES, MemoryUtil.memAddressSafe(value));
        AIScene.nmNumTextures(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumLights(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMLIGHTS, value);
    }

    public static void nmLights(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MLIGHTS, MemoryUtil.memAddressSafe(value));
        AIScene.nmNumLights(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumCameras(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMCAMERAS, value);
    }

    public static void nmCameras(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MCAMERAS, MemoryUtil.memAddressSafe(value));
        AIScene.nmNumCameras(struct, value == null ? 0 : value.remaining());
    }

    public static void nmMetaData(long struct, @Nullable AIMetaData value) {
        MemoryUtil.memPutAddress(struct + (long)MMETADATA, MemoryUtil.memAddressSafe(value));
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MNAME, AIString.SIZEOF);
    }

    public static void nmPrivate(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MPRIVATE, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        long mMetaData;
        long mRootNode = MemoryUtil.memGetAddress(struct + (long)MROOTNODE);
        if (mRootNode != 0L) {
            AINode.validate(mRootNode);
        }
        if (AIScene.nmNumMeshes(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MMESHES));
        }
        if (AIScene.nmNumMaterials(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MMATERIALS));
        }
        if (AIScene.nmNumAnimations(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MANIMATIONS));
        }
        if (AIScene.nmNumTextures(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MTEXTURES));
        }
        if (AIScene.nmNumLights(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MLIGHTS));
        }
        if (AIScene.nmNumCameras(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MCAMERAS));
        }
        if ((mMetaData = MemoryUtil.memGetAddress(struct + (long)MMETADATA)) != 0L) {
            AIMetaData.validate(mMetaData);
        }
    }

    static {
        Struct.Layout layout = AIScene.__struct(AIScene.__member(4), AIScene.__member(POINTER_SIZE), AIScene.__member(4), AIScene.__member(POINTER_SIZE), AIScene.__member(4), AIScene.__member(POINTER_SIZE), AIScene.__member(4), AIScene.__member(POINTER_SIZE), AIScene.__member(4), AIScene.__member(POINTER_SIZE), AIScene.__member(4), AIScene.__member(POINTER_SIZE), AIScene.__member(4), AIScene.__member(POINTER_SIZE), AIScene.__member(POINTER_SIZE), AIScene.__member(AIString.SIZEOF, AIString.ALIGNOF), AIScene.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MFLAGS = layout.offsetof(0);
        MROOTNODE = layout.offsetof(1);
        MNUMMESHES = layout.offsetof(2);
        MMESHES = layout.offsetof(3);
        MNUMMATERIALS = layout.offsetof(4);
        MMATERIALS = layout.offsetof(5);
        MNUMANIMATIONS = layout.offsetof(6);
        MANIMATIONS = layout.offsetof(7);
        MNUMTEXTURES = layout.offsetof(8);
        MTEXTURES = layout.offsetof(9);
        MNUMLIGHTS = layout.offsetof(10);
        MLIGHTS = layout.offsetof(11);
        MNUMCAMERAS = layout.offsetof(12);
        MCAMERAS = layout.offsetof(13);
        MMETADATA = layout.offsetof(14);
        MNAME = layout.offsetof(15);
        MPRIVATE = layout.offsetof(16);
    }

    public static class Buffer
    extends StructBuffer<AIScene, Buffer>
    implements NativeResource {
        private static final AIScene ELEMENT_FACTORY = AIScene.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIScene getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int mFlags() {
            return AIScene.nmFlags(this.address());
        }

        @Nullable
        @NativeType(value="struct aiNode *")
        public AINode mRootNode() {
            return AIScene.nmRootNode(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumMeshes() {
            return AIScene.nmNumMeshes(this.address());
        }

        @Nullable
        @NativeType(value="struct aiMesh **")
        public PointerBuffer mMeshes() {
            return AIScene.nmMeshes(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumMaterials() {
            return AIScene.nmNumMaterials(this.address());
        }

        @Nullable
        @NativeType(value="struct aiMaterial **")
        public PointerBuffer mMaterials() {
            return AIScene.nmMaterials(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumAnimations() {
            return AIScene.nmNumAnimations(this.address());
        }

        @Nullable
        @NativeType(value="struct aiAnimation **")
        public PointerBuffer mAnimations() {
            return AIScene.nmAnimations(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumTextures() {
            return AIScene.nmNumTextures(this.address());
        }

        @Nullable
        @NativeType(value="struct aiTexture **")
        public PointerBuffer mTextures() {
            return AIScene.nmTextures(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumLights() {
            return AIScene.nmNumLights(this.address());
        }

        @Nullable
        @NativeType(value="struct aiLight **")
        public PointerBuffer mLights() {
            return AIScene.nmLights(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumCameras() {
            return AIScene.nmNumCameras(this.address());
        }

        @Nullable
        @NativeType(value="struct aiCamera **")
        public PointerBuffer mCameras() {
            return AIScene.nmCameras(this.address());
        }

        @Nullable
        @NativeType(value="struct aiMetadata *")
        public AIMetaData mMetaData() {
            return AIScene.nmMetaData(this.address());
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AIScene.nmName(this.address());
        }

        public Buffer mFlags(@NativeType(value="unsigned int") int value) {
            AIScene.nmFlags(this.address(), value);
            return this;
        }

        public Buffer mRootNode(@Nullable @NativeType(value="struct aiNode *") AINode value) {
            AIScene.nmRootNode(this.address(), value);
            return this;
        }

        public Buffer mMeshes(@Nullable @NativeType(value="struct aiMesh **") PointerBuffer value) {
            AIScene.nmMeshes(this.address(), value);
            return this;
        }

        public Buffer mMaterials(@Nullable @NativeType(value="struct aiMaterial **") PointerBuffer value) {
            AIScene.nmMaterials(this.address(), value);
            return this;
        }

        public Buffer mAnimations(@Nullable @NativeType(value="struct aiAnimation **") PointerBuffer value) {
            AIScene.nmAnimations(this.address(), value);
            return this;
        }

        public Buffer mTextures(@Nullable @NativeType(value="struct aiTexture **") PointerBuffer value) {
            AIScene.nmTextures(this.address(), value);
            return this;
        }

        public Buffer mLights(@Nullable @NativeType(value="struct aiLight **") PointerBuffer value) {
            AIScene.nmLights(this.address(), value);
            return this;
        }

        public Buffer mCameras(@Nullable @NativeType(value="struct aiCamera **") PointerBuffer value) {
            AIScene.nmCameras(this.address(), value);
            return this;
        }

        public Buffer mMetaData(@Nullable @NativeType(value="struct aiMetadata *") AIMetaData value) {
            AIScene.nmMetaData(this.address(), value);
            return this;
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AIScene.nmName(this.address(), value);
            return this;
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }
    }
}

