/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiPropertyStore")
public class AIPropertyStore
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SENTINEL;

    public AIPropertyStore(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIPropertyStore.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char")
    public byte sentinel() {
        return AIPropertyStore.nsentinel(this.address());
    }

    public AIPropertyStore sentinel(@NativeType(value="char") byte value) {
        AIPropertyStore.nsentinel(this.address(), value);
        return this;
    }

    public AIPropertyStore set(AIPropertyStore src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIPropertyStore malloc() {
        return AIPropertyStore.wrap(AIPropertyStore.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIPropertyStore calloc() {
        return AIPropertyStore.wrap(AIPropertyStore.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIPropertyStore create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AIPropertyStore.wrap(AIPropertyStore.class, MemoryUtil.memAddress(container), container);
    }

    public static AIPropertyStore create(long address) {
        return AIPropertyStore.wrap(AIPropertyStore.class, address);
    }

    @Nullable
    public static AIPropertyStore createSafe(long address) {
        return address == 0L ? null : AIPropertyStore.wrap(AIPropertyStore.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AIPropertyStore.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AIPropertyStore.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIPropertyStore.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIPropertyStore.__create(capacity, SIZEOF);
        return AIPropertyStore.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AIPropertyStore.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIPropertyStore.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static AIPropertyStore mallocStack() {
        return AIPropertyStore.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIPropertyStore callocStack() {
        return AIPropertyStore.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIPropertyStore mallocStack(MemoryStack stack) {
        return AIPropertyStore.malloc(stack);
    }

    @Deprecated
    public static AIPropertyStore callocStack(MemoryStack stack) {
        return AIPropertyStore.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIPropertyStore.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIPropertyStore.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIPropertyStore.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIPropertyStore.calloc(capacity, stack);
    }

    public static AIPropertyStore malloc(MemoryStack stack) {
        return AIPropertyStore.wrap(AIPropertyStore.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIPropertyStore calloc(MemoryStack stack) {
        return AIPropertyStore.wrap(AIPropertyStore.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return AIPropertyStore.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return AIPropertyStore.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte nsentinel(long struct) {
        return UNSAFE.getByte(null, struct + (long)SENTINEL);
    }

    public static void nsentinel(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SENTINEL, value);
    }

    static {
        Struct.Layout layout = AIPropertyStore.__struct(AIPropertyStore.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SENTINEL = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<AIPropertyStore, Buffer>
    implements NativeResource {
        private static final AIPropertyStore ELEMENT_FACTORY = AIPropertyStore.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIPropertyStore getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char")
        public byte sentinel() {
            return AIPropertyStore.nsentinel(this.address());
        }

        public Buffer sentinel(@NativeType(value="char") byte value) {
            AIPropertyStore.nsentinel(this.address(), value);
            return this;
        }
    }
}

