/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIMatrix4x4;
import org.lwjgl.assimp.AIMetaData;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiNode")
public class AINode
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MTRANSFORMATION;
    public static final int MPARENT;
    public static final int MNUMCHILDREN;
    public static final int MCHILDREN;
    public static final int MNUMMESHES;
    public static final int MMESHES;
    public static final int MMETADATA;

    public AINode(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AINode.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AINode.nmName(this.address());
    }

    @NativeType(value="struct aiMatrix4x4")
    public AIMatrix4x4 mTransformation() {
        return AINode.nmTransformation(this.address());
    }

    @Nullable
    @NativeType(value="struct aiNode *")
    public AINode mParent() {
        return AINode.nmParent(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumChildren() {
        return AINode.nmNumChildren(this.address());
    }

    @Nullable
    @NativeType(value="struct aiNode **")
    public PointerBuffer mChildren() {
        return AINode.nmChildren(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumMeshes() {
        return AINode.nmNumMeshes(this.address());
    }

    @Nullable
    @NativeType(value="unsigned int *")
    public IntBuffer mMeshes() {
        return AINode.nmMeshes(this.address());
    }

    @Nullable
    @NativeType(value="struct aiMetadata *")
    public AIMetaData mMetadata() {
        return AINode.nmMetadata(this.address());
    }

    public AINode mName(@NativeType(value="struct aiString") AIString value) {
        AINode.nmName(this.address(), value);
        return this;
    }

    public AINode mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    public AINode mTransformation(@NativeType(value="struct aiMatrix4x4") AIMatrix4x4 value) {
        AINode.nmTransformation(this.address(), value);
        return this;
    }

    public AINode mTransformation(Consumer<AIMatrix4x4> consumer) {
        consumer.accept(this.mTransformation());
        return this;
    }

    public AINode mParent(@Nullable @NativeType(value="struct aiNode *") AINode value) {
        AINode.nmParent(this.address(), value);
        return this;
    }

    public AINode mChildren(@Nullable @NativeType(value="struct aiNode **") PointerBuffer value) {
        AINode.nmChildren(this.address(), value);
        return this;
    }

    public AINode mMeshes(@Nullable @NativeType(value="unsigned int *") IntBuffer value) {
        AINode.nmMeshes(this.address(), value);
        return this;
    }

    public AINode mMetadata(@Nullable @NativeType(value="struct aiMetadata *") AIMetaData value) {
        AINode.nmMetadata(this.address(), value);
        return this;
    }

    public AINode set(AIString mName, AIMatrix4x4 mTransformation, @Nullable AINode mParent, @Nullable PointerBuffer mChildren, @Nullable IntBuffer mMeshes, @Nullable AIMetaData mMetadata) {
        this.mName(mName);
        this.mTransformation(mTransformation);
        this.mParent(mParent);
        this.mChildren(mChildren);
        this.mMeshes(mMeshes);
        this.mMetadata(mMetadata);
        return this;
    }

    public AINode set(AINode src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AINode malloc() {
        return AINode.wrap(AINode.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AINode calloc() {
        return AINode.wrap(AINode.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AINode create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AINode.wrap(AINode.class, MemoryUtil.memAddress(container), container);
    }

    public static AINode create(long address) {
        return AINode.wrap(AINode.class, address);
    }

    @Nullable
    public static AINode createSafe(long address) {
        return address == 0L ? null : AINode.wrap(AINode.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AINode.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AINode.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AINode.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AINode.__create(capacity, SIZEOF);
        return AINode.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AINode.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AINode.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static AINode mallocStack() {
        return AINode.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AINode callocStack() {
        return AINode.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AINode mallocStack(MemoryStack stack) {
        return AINode.malloc(stack);
    }

    @Deprecated
    public static AINode callocStack(MemoryStack stack) {
        return AINode.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AINode.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AINode.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AINode.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AINode.calloc(capacity, stack);
    }

    public static AINode malloc(MemoryStack stack) {
        return AINode.wrap(AINode.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AINode calloc(MemoryStack stack) {
        return AINode.wrap(AINode.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return AINode.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return AINode.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static AIMatrix4x4 nmTransformation(long struct) {
        return AIMatrix4x4.create(struct + (long)MTRANSFORMATION);
    }

    @Nullable
    public static AINode nmParent(long struct) {
        return AINode.createSafe(MemoryUtil.memGetAddress(struct + (long)MPARENT));
    }

    public static int nmNumChildren(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMCHILDREN);
    }

    @Nullable
    public static PointerBuffer nmChildren(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)MCHILDREN), AINode.nmNumChildren(struct));
    }

    public static int nmNumMeshes(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMMESHES);
    }

    @Nullable
    public static IntBuffer nmMeshes(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)MMESHES), AINode.nmNumMeshes(struct));
    }

    @Nullable
    public static AIMetaData nmMetadata(long struct) {
        return AIMetaData.createSafe(MemoryUtil.memGetAddress(struct + (long)MMETADATA));
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MNAME, AIString.SIZEOF);
    }

    public static void nmTransformation(long struct, AIMatrix4x4 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MTRANSFORMATION, AIMatrix4x4.SIZEOF);
    }

    public static void nmParent(long struct, @Nullable AINode value) {
        MemoryUtil.memPutAddress(struct + (long)MPARENT, MemoryUtil.memAddressSafe(value));
    }

    public static void nmNumChildren(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMCHILDREN, value);
    }

    public static void nmChildren(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MCHILDREN, MemoryUtil.memAddressSafe(value));
        AINode.nmNumChildren(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumMeshes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMMESHES, value);
    }

    public static void nmMeshes(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MMESHES, MemoryUtil.memAddressSafe(value));
        AINode.nmNumMeshes(struct, value == null ? 0 : value.remaining());
    }

    public static void nmMetadata(long struct, @Nullable AIMetaData value) {
        MemoryUtil.memPutAddress(struct + (long)MMETADATA, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        long mMetadata;
        if (AINode.nmNumChildren(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MCHILDREN));
        }
        if (AINode.nmNumMeshes(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MMESHES));
        }
        if ((mMetadata = MemoryUtil.memGetAddress(struct + (long)MMETADATA)) != 0L) {
            AIMetaData.validate(mMetadata);
        }
    }

    static {
        Struct.Layout layout = AINode.__struct(AINode.__member(AIString.SIZEOF, AIString.ALIGNOF), AINode.__member(AIMatrix4x4.SIZEOF, AIMatrix4x4.ALIGNOF), AINode.__member(POINTER_SIZE), AINode.__member(4), AINode.__member(POINTER_SIZE), AINode.__member(4), AINode.__member(POINTER_SIZE), AINode.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MTRANSFORMATION = layout.offsetof(1);
        MPARENT = layout.offsetof(2);
        MNUMCHILDREN = layout.offsetof(3);
        MCHILDREN = layout.offsetof(4);
        MNUMMESHES = layout.offsetof(5);
        MMESHES = layout.offsetof(6);
        MMETADATA = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<AINode, Buffer>
    implements NativeResource {
        private static final AINode ELEMENT_FACTORY = AINode.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AINode getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AINode.nmName(this.address());
        }

        @NativeType(value="struct aiMatrix4x4")
        public AIMatrix4x4 mTransformation() {
            return AINode.nmTransformation(this.address());
        }

        @Nullable
        @NativeType(value="struct aiNode *")
        public AINode mParent() {
            return AINode.nmParent(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumChildren() {
            return AINode.nmNumChildren(this.address());
        }

        @Nullable
        @NativeType(value="struct aiNode **")
        public PointerBuffer mChildren() {
            return AINode.nmChildren(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumMeshes() {
            return AINode.nmNumMeshes(this.address());
        }

        @Nullable
        @NativeType(value="unsigned int *")
        public IntBuffer mMeshes() {
            return AINode.nmMeshes(this.address());
        }

        @Nullable
        @NativeType(value="struct aiMetadata *")
        public AIMetaData mMetadata() {
            return AINode.nmMetadata(this.address());
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AINode.nmName(this.address(), value);
            return this;
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }

        public Buffer mTransformation(@NativeType(value="struct aiMatrix4x4") AIMatrix4x4 value) {
            AINode.nmTransformation(this.address(), value);
            return this;
        }

        public Buffer mTransformation(Consumer<AIMatrix4x4> consumer) {
            consumer.accept(this.mTransformation());
            return this;
        }

        public Buffer mParent(@Nullable @NativeType(value="struct aiNode *") AINode value) {
            AINode.nmParent(this.address(), value);
            return this;
        }

        public Buffer mChildren(@Nullable @NativeType(value="struct aiNode **") PointerBuffer value) {
            AINode.nmChildren(this.address(), value);
            return this;
        }

        public Buffer mMeshes(@Nullable @NativeType(value="unsigned int *") IntBuffer value) {
            AINode.nmMeshes(this.address(), value);
            return this;
        }

        public Buffer mMetadata(@Nullable @NativeType(value="struct aiMetadata *") AIMetaData value) {
            AINode.nmMetadata(this.address(), value);
            return this;
        }
    }
}

