/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiColor4D")
public class AIColor4D
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    public AIColor4D(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIColor4D.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float r() {
        return AIColor4D.nr(this.address());
    }

    public float g() {
        return AIColor4D.ng(this.address());
    }

    public float b() {
        return AIColor4D.nb(this.address());
    }

    public float a() {
        return AIColor4D.na(this.address());
    }

    public AIColor4D r(float value) {
        AIColor4D.nr(this.address(), value);
        return this;
    }

    public AIColor4D g(float value) {
        AIColor4D.ng(this.address(), value);
        return this;
    }

    public AIColor4D b(float value) {
        AIColor4D.nb(this.address(), value);
        return this;
    }

    public AIColor4D a(float value) {
        AIColor4D.na(this.address(), value);
        return this;
    }

    public AIColor4D set(float r, float g, float b, float a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public AIColor4D set(AIColor4D src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIColor4D malloc() {
        return AIColor4D.wrap(AIColor4D.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIColor4D calloc() {
        return AIColor4D.wrap(AIColor4D.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIColor4D create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AIColor4D.wrap(AIColor4D.class, MemoryUtil.memAddress(container), container);
    }

    public static AIColor4D create(long address) {
        return AIColor4D.wrap(AIColor4D.class, address);
    }

    @Nullable
    public static AIColor4D createSafe(long address) {
        return address == 0L ? null : AIColor4D.wrap(AIColor4D.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AIColor4D.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AIColor4D.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIColor4D.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIColor4D.__create(capacity, SIZEOF);
        return AIColor4D.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AIColor4D.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIColor4D.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static AIColor4D mallocStack() {
        return AIColor4D.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIColor4D callocStack() {
        return AIColor4D.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIColor4D mallocStack(MemoryStack stack) {
        return AIColor4D.malloc(stack);
    }

    @Deprecated
    public static AIColor4D callocStack(MemoryStack stack) {
        return AIColor4D.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIColor4D.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIColor4D.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIColor4D.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIColor4D.calloc(capacity, stack);
    }

    public static AIColor4D malloc(MemoryStack stack) {
        return AIColor4D.wrap(AIColor4D.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIColor4D calloc(MemoryStack stack) {
        return AIColor4D.wrap(AIColor4D.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return AIColor4D.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return AIColor4D.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nr(long struct) {
        return UNSAFE.getFloat(null, struct + (long)R);
    }

    public static float ng(long struct) {
        return UNSAFE.getFloat(null, struct + (long)G);
    }

    public static float nb(long struct) {
        return UNSAFE.getFloat(null, struct + (long)B);
    }

    public static float na(long struct) {
        return UNSAFE.getFloat(null, struct + (long)A);
    }

    public static void nr(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)R, value);
    }

    public static void ng(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)G, value);
    }

    public static void nb(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)B, value);
    }

    public static void na(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)A, value);
    }

    static {
        Struct.Layout layout = AIColor4D.__struct(AIColor4D.__member(4), AIColor4D.__member(4), AIColor4D.__member(4), AIColor4D.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AIColor4D, Buffer>
    implements NativeResource {
        private static final AIColor4D ELEMENT_FACTORY = AIColor4D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIColor4D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float r() {
            return AIColor4D.nr(this.address());
        }

        public float g() {
            return AIColor4D.ng(this.address());
        }

        public float b() {
            return AIColor4D.nb(this.address());
        }

        public float a() {
            return AIColor4D.na(this.address());
        }

        public Buffer r(float value) {
            AIColor4D.nr(this.address(), value);
            return this;
        }

        public Buffer g(float value) {
            AIColor4D.ng(this.address(), value);
            return this;
        }

        public Buffer b(float value) {
            AIColor4D.nb(this.address(), value);
            return this;
        }

        public Buffer a(float value) {
            AIColor4D.na(this.address(), value);
            return this;
        }
    }
}

