/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.utils.api;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.function.Function;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.I18n;

public final class JsonStreetsideDecoder {
    static final Logger logger = Logger.getLogger(JsonStreetsideDecoder.class);

    private JsonStreetsideDecoder() {
    }

    public static <T> Collection<T> decodeFeatureCollection(JsonObject json, Function<JsonObject, T> featureDecoder) {
        HashSet<T> result = new HashSet<T>();
        if (json != null && "FeatureCollection".equals(json.getString("type", null)) && json.containsKey((Object)"features")) {
            JsonValue features = (JsonValue)json.get((Object)"features");
            for (int i = 0; features instanceof JsonArray && i < ((JsonArray)features).size(); ++i) {
                T feature;
                JsonValue val = (JsonValue)((JsonArray)features).get(i);
                if (!(val instanceof JsonObject) || (feature = featureDecoder.apply((JsonObject)val)) == null) continue;
                result.add(feature);
            }
        }
        return result;
    }

    static LatLon decodeLatLon(JsonArray json) {
        double[] result = JsonStreetsideDecoder.decodeDoublePair(json);
        if (result != null) {
            return new LatLon(result[1], result[0]);
        }
        return null;
    }

    static double[] decodeDoublePair(JsonArray json) {
        if (json != null && json.size() == 2 && json.get(0) instanceof JsonNumber && json.get(1) instanceof JsonNumber) {
            return new double[]{json.getJsonNumber(0).doubleValue(), json.getJsonNumber(1).doubleValue()};
        }
        return null;
    }

    static Long decodeTimestamp(String timestamp) {
        if (timestamp != null) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX", Locale.UK).parse(timestamp).getTime();
            }
            catch (ParseException e) {
                StackTraceElement calledBy = e.getStackTrace()[Math.min(e.getStackTrace().length - 1, 2)];
                logger.warn((Object)I18n.tr((String)String.format("Could not decode time from the timestamp `%s` (called by %s.%s:%d)", timestamp, calledBy.getClassName(), calledBy.getMethodName(), calledBy.getLineNumber()), (Object[])new Object[]{e}));
            }
        }
        return null;
    }
}

