/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.oauth;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.plugins.streetside.oauth.StreetsideLoginListener;
import org.openstreetmap.josm.plugins.streetside.oauth.StreetsideUser;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.I18n;

public class OAuthPortListener
extends Thread {
    public static final int PORT = 8763;
    static final Logger logger = Logger.getLogger(OAuthPortListener.class);
    protected static final String RESPONSE = String.format("<!DOCTYPE html><html><head><meta charset=\"utf8\"><title>%s</title></head><body>%s</body></html>", I18n.tr((String)"Streetside login", (Object[])new Object[0]), I18n.tr((String)"Login successful, return to JOSM.", (Object[])new Object[0]));
    private final StreetsideLoginListener callback;

    public OAuthPortListener(StreetsideLoginListener loginCallback) {
        this.callback = loginCallback;
    }

    @Override
    public void run() {
        try (ServerSocket serverSocket = new ServerSocket(8763);
             Socket clientSocket = serverSocket.accept();
             PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter(clientSocket.getOutputStream(), "UTF-8"), true);
             Scanner in = new Scanner(new InputStreamReader(clientSocket.getInputStream(), "UTF-8"));){
            String accessToken = null;
            while (in.hasNextLine()) {
                String s = in.nextLine();
                Matcher tokenMatcher = Pattern.compile("^.*&access_token=([^&]+)&.*$").matcher('&' + s + '&');
                if (tokenMatcher.matches()) {
                    accessToken = tokenMatcher.group(1);
                    break;
                }
                if (!s.contains("keep-alive")) continue;
                break;
            }
            OAuthPortListener.writeContent(out);
            out.flush();
            StreetsideUser.reset();
            logger.info((Object)I18n.tr((String)"Successful login with Streetside, the access token is: {0}", (Object[])new Object[]{accessToken}));
            StreetsideUser.setTokenValid(true);
            StreetsideProperties.ACCESS_TOKEN.put(accessToken);
            String username = StreetsideUser.getUsername();
            logger.info((Object)I18n.tr((String)"The username is: {0}", (Object[])new Object[]{username}));
            if (this.callback != null) {
                this.callback.onLogin(username);
            }
        }
        catch (BindException e) {
            logger.warn((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    private static void writeContent(PrintWriter out) {
        out.println("HTTP/1.1 200 OK");
        out.println("Content-Length: " + RESPONSE.length());
        out.println("Content-Type: text/html\r\n\r\n");
        out.println(RESPONSE);
    }
}

