/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cubemap;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.plugins.streetside.cache.StreetsideCache;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapBuilder;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.cubemap.ITileDownloadingTaskListener;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;
import us.monoid.web.Resty;

public class TileDownloadingTask
implements Callable<List<String>> {
    static final Logger logger = Logger.getLogger(TileDownloadingTask.class);
    private String tileId;
    private StreetsideCache cache;
    protected CubemapBuilder cb;
    private final List<ITileDownloadingTaskListener> listeners = new CopyOnWriteArrayList<ITileDownloadingTaskListener>();
    boolean cancelled = false;

    public TileDownloadingTask(String id) {
        this.tileId = id;
        this.cb = CubemapBuilder.getInstance();
        this.addListener(CubemapBuilder.getInstance());
    }

    public final void addListener(ITileDownloadingTaskListener lis) {
        this.listeners.add(lis);
    }

    public String getId() {
        return this.tileId;
    }

    public void setId(String id) {
        this.tileId = id;
    }

    public StreetsideCache getCache() {
        return this.cache;
    }

    public void setCache(StreetsideCache cache) {
        this.cache = cache;
    }

    public CubemapBuilder getCb() {
        return this.cb;
    }

    public void setCb(CubemapBuilder cb) {
        this.cb = cb;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public List<String> call() throws Exception {
        ArrayList<String> res = new ArrayList<String>();
        if (StreetsideProperties.DOWNLOAD_CUBEFACE_TILES_TOGETHER.get().booleanValue()) {
            if (!StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
                int tileNr = 0;
                for (int j = 0; j < CubemapUtils.getMaxCols(); ++j) {
                    for (int k = 0; k < CubemapUtils.getMaxRows(); ++k) {
                        String quadKey = String.valueOf(this.tileId + Integer.valueOf(tileNr++).toString());
                        res.add(this.downloadTile(quadKey));
                    }
                }
            } else {
                for (int j = 0; j < CubemapUtils.getMaxCols(); ++j) {
                    for (int k = 0; k < CubemapUtils.getMaxRows(); ++k) {
                        String quadKey = String.valueOf(this.tileId + String.valueOf(Integer.valueOf(j).toString() + Integer.valueOf(k).toString()));
                        res.add(this.downloadTile(quadKey));
                    }
                }
            }
        } else {
            res.add(this.downloadTile(this.tileId));
        }
        return res;
    }

    private String downloadTile(String tileId) {
        long startTime = System.currentTimeMillis();
        try {
            BufferedImage img = ImageIO.read(new Resty(new Resty.Option[0]).bytes(StreetsideURL.VirtualEarth.streetsideTile(tileId, false).toExternalForm()).stream());
            if (img == null) {
                logger.error((Object)("Download of BufferedImage " + tileId + " is null!"));
            }
            CubemapBuilder.getInstance().getTileImages().put(tileId, img);
            this.fireTileAdded(tileId);
            if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
                long endTime = System.currentTimeMillis();
                long runTime = (endTime - startTime) / 1000L;
                logger.debug((Object)MessageFormat.format("Loaded image for {0} in {1} seconds.", tileId, runTime));
            }
        }
        catch (IOException e) {
            logger.error((Object)MessageFormat.format("Error downloading image for tileId {0}", tileId));
            return null;
        }
        return tileId;
    }

    private void fireTileAdded(String id) {
        this.listeners.stream().filter(Objects::nonNull).forEach(lis -> lis.tileAdded(id));
    }
}

