/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya;

import java.math.BigDecimal;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Dimensionless;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.format.SimpleQuantityFormat;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.spi.NumberSystem;
import tech.uom.lib.common.function.UnitSupplier;
import tech.uom.lib.common.function.ValueSupplier;

public abstract class AbstractQuantity<Q extends Quantity<Q>>
implements ComparableQuantity<Q>,
UnitSupplier<Q>,
ValueSupplier<Number> {
    private static final long serialVersionUID = 293852425369811882L;
    private final Unit<Q> unit;
    private final Quantity.Scale scale;
    public static final Quantity<Dimensionless> NONE = Quantities.getQuantity(0, AbstractUnit.ONE);
    public static final Quantity<Dimensionless> ONE = Quantities.getQuantity(1, AbstractUnit.ONE);

    protected AbstractQuantity(Unit<Q> unit, Quantity.Scale sca) {
        this.unit = unit;
        this.scale = sca;
    }

    protected AbstractQuantity(Unit<Q> unit) {
        this(unit, Quantity.Scale.ABSOLUTE);
    }

    @Override
    public abstract Number getValue();

    @Override
    public Unit<Q> getUnit() {
        return this.unit;
    }

    @Override
    public Quantity.Scale getScale() {
        return this.scale;
    }

    @Override
    public ComparableQuantity<Q> to(Unit<Q> anotherUnit) {
        if (anotherUnit.equals(this.getUnit())) {
            return this;
        }
        UnitConverter t = this.getUnit().getConverterTo(anotherUnit);
        Number convertedValue = t.convert(this.getValue());
        return Quantities.getQuantity(convertedValue, anotherUnit);
    }

    @Override
    public boolean isGreaterThan(Quantity<Q> that) {
        return this.compareTo(that) > 0;
    }

    @Override
    public boolean isGreaterThanOrEqualTo(Quantity<Q> that) {
        return this.compareTo(that) >= 0;
    }

    @Override
    public boolean isLessThan(Quantity<Q> that) {
        return this.compareTo(that) < 0;
    }

    @Override
    public boolean isLessThanOrEqualTo(Quantity<Q> that) {
        return this.compareTo(that) <= 0;
    }

    @Override
    public boolean isEquivalentTo(Quantity<Q> that) {
        return this.compareTo(that) == 0;
    }

    @Override
    public int compareTo(Quantity<Q> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return this.numberSystem().compare(this.getValue(), that.getValue());
        }
        return this.numberSystem().compare(this.getValue(), that.to(this.getUnit()).getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && Objects.equals((Object)this.getScale(), (Object)that.getScale()) && Objects.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getUnit(), this.getScale(), this.getValue()});
    }

    public String toString() {
        return SimpleQuantityFormat.getInstance().format(this);
    }

    @Override
    public <T extends Quantity<T>, E extends Quantity<E>> ComparableQuantity<E> divide(Quantity<T> that, Class<E> asTypeQuantity) {
        return this.divide((Quantity)Objects.requireNonNull(that)).asType((Class)Objects.requireNonNull(asTypeQuantity));
    }

    @Override
    public <T extends Quantity<T>, E extends Quantity<E>> ComparableQuantity<E> multiply(Quantity<T> that, Class<E> asTypeQuantity) {
        return this.multiply((Quantity)Objects.requireNonNull(that)).asType((Class)Objects.requireNonNull(asTypeQuantity));
    }

    @Override
    public <T extends Quantity<T>> ComparableQuantity<T> inverse(Class<T> quantityClass) {
        return this.inverse().asType((Class)quantityClass);
    }

    @Override
    public final <T extends Quantity<T>> ComparableQuantity<T> asType(Class<T> type) throws ClassCastException {
        this.getUnit().asType(type);
        return this;
    }

    public static Quantity<?> parse(CharSequence csq) {
        return SimpleQuantityFormat.getInstance().parse(csq);
    }

    protected boolean hasFraction(double value) {
        return (double)Math.round(value) != value;
    }

    protected boolean hasFraction(BigDecimal value) {
        return value.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0;
    }

    protected NumberSystem numberSystem() {
        return Calculus.currentNumberSystem();
    }
}

