/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd.impl;

import java.util.logging.Logger;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.geotools.util.Converters;
import org.geotools.xsd.Binding;
import org.geotools.xsd.SimpleBinding;
import org.geotools.xsd.impl.BindingWalker;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public class AttributeEncodeExecutor
implements BindingWalker.Visitor {
    Object object;
    XSDAttributeDeclaration attribute;
    Attr encoding;
    Document document;
    Logger logger;

    public AttributeEncodeExecutor(Object object, XSDAttributeDeclaration attribute, Document document, Logger logger) {
        this.object = object;
        this.attribute = attribute;
        this.document = document;
        this.logger = logger;
        this.encoding = document.createAttributeNS(attribute.getTargetNamespace(), attribute.getName());
    }

    public Attr getEncodedAttribute() {
        return this.encoding;
    }

    @Override
    public void visit(Binding binding) {
        if (binding.getType() == null) {
            this.logger.fine("Binding: " + binding.getTarget() + " does not declare a target type");
            return;
        }
        if (!binding.getType().isAssignableFrom(this.object.getClass())) {
            Object converted = Converters.convert(this.object, binding.getType());
            if (converted != null) {
                this.object = converted;
            } else {
                this.logger.fine(this.object + "[ " + this.object.getClass() + " ] is not of type " + binding.getType());
                return;
            }
        }
        if (binding instanceof SimpleBinding) {
            SimpleBinding simple = (SimpleBinding)binding;
            try {
                this.encoding.setValue(simple.encode(this.object, this.encoding.getValue()));
            }
            catch (Throwable t) {
                String msg = "Encode failed for " + this.attribute.getName() + ". Cause: " + t.getLocalizedMessage();
                throw new RuntimeException(msg, t);
            }
        }
    }
}

