/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers.xsi;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.geotools.xml.XSIElementHandler;
import org.geotools.xml.handlers.xsi.AnyHandler;
import org.geotools.xml.handlers.xsi.ElementGroupingHandler;
import org.geotools.xml.handlers.xsi.ElementTypeHandler;
import org.geotools.xml.handlers.xsi.GroupHandler;
import org.geotools.xml.handlers.xsi.SchemaHandler;
import org.geotools.xml.handlers.xsi.SequenceHandler;
import org.geotools.xml.schema.Choice;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ChoiceHandler
extends ElementGroupingHandler {
    public static final String LOCALNAME = "choice";
    private String id;
    private int minOccurs;
    private int maxOccurs;
    private List<XSIElementHandler> children;
    private DefaultChoice cache = null;

    @Override
    public int hashCode() {
        return LOCALNAME.hashCode() * (this.id == null ? 1 : this.id.hashCode()) + this.minOccurs * this.maxOccurs;
    }

    @Override
    public XSIElementHandler getHandler(String namespaceURI, String localName) {
        if ("http://www.w3.org/2001/XMLSchema".equalsIgnoreCase(namespaceURI)) {
            if ("group".equalsIgnoreCase(localName)) {
                if (this.children == null) {
                    this.children = new LinkedList<XSIElementHandler>();
                }
                GroupHandler gh = new GroupHandler();
                this.children.add(gh);
                return gh;
            }
            if (LOCALNAME.equalsIgnoreCase(localName)) {
                if (this.children == null) {
                    this.children = new LinkedList<XSIElementHandler>();
                }
                GroupHandler gh = new GroupHandler();
                this.children.add(gh);
                return gh;
            }
            if ("sequence".equalsIgnoreCase(localName)) {
                if (this.children == null) {
                    this.children = new LinkedList<XSIElementHandler>();
                }
                SequenceHandler gh = new SequenceHandler();
                this.children.add(gh);
                return gh;
            }
            if ("any".equalsIgnoreCase(localName)) {
                if (this.children == null) {
                    this.children = new LinkedList<XSIElementHandler>();
                }
                AnyHandler gh = new AnyHandler();
                this.children.add(gh);
                return gh;
            }
            if ("element".equalsIgnoreCase(localName)) {
                if (this.children == null) {
                    this.children = new LinkedList<XSIElementHandler>();
                }
                ElementTypeHandler gh = new ElementTypeHandler();
                this.children.add(gh);
                return gh;
            }
        }
        return null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, Attributes atts) {
        String max;
        String min;
        this.id = atts.getValue("", "id");
        if (this.id == null) {
            this.id = atts.getValue(namespaceURI, "id");
        }
        if ((min = atts.getValue("", "minOccurs")) == null) {
            min = atts.getValue(namespaceURI, "minOccurs");
        }
        if ((max = atts.getValue("", "maxOccurs")) == null) {
            max = atts.getValue(namespaceURI, "maxOccurs");
        }
        int n = this.minOccurs = min == null || "".equalsIgnoreCase(min) ? 1 : Integer.parseInt(min);
        this.maxOccurs = max == null || "".equalsIgnoreCase(max) ? 1 : ("unbounded".equalsIgnoreCase(max) ? Integer.MAX_VALUE : Integer.parseInt(max));
    }

    @Override
    public String getLocalName() {
        return LOCALNAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ElementGrouping compress(SchemaHandler parent) throws SAXException {
        ChoiceHandler choiceHandler = this;
        synchronized (choiceHandler) {
            if (this.cache != null) {
                return this.cache;
            }
            this.cache = new DefaultChoice();
        }
        this.cache.id = this.id;
        this.cache.maxOccurs = this.maxOccurs;
        this.cache.minOccurs = this.minOccurs;
        if (this.children != null) {
            this.cache.children = new ElementGrouping[this.children.size()];
            for (int i = 0; i < this.cache.children.length; ++i) {
                this.cache.children[i] = ((ElementGroupingHandler)this.children.get(i)).compress(parent);
            }
        }
        this.id = null;
        this.children = null;
        return this.cache;
    }

    @Override
    public int getHandlerType() {
        return 0;
    }

    @Override
    public void endElement(String namespaceURI, String localName) {
    }

    private static class DefaultChoice
    implements Choice {
        ElementGrouping[] children;
        String id;
        int maxOccurs;
        int minOccurs;

        private DefaultChoice() {
        }

        @Override
        public Element findChildElement(String name) {
            if (this.children == null) {
                return null;
            }
            for (ElementGrouping child : this.children) {
                Element t = child.findChildElement(name);
                if (t == null) continue;
                return t;
            }
            return null;
        }

        @Override
        public ElementGrouping[] getChildren() {
            return this.children;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public int getMaxOccurs() {
            return this.maxOccurs;
        }

        @Override
        public int getMinOccurs() {
            return this.minOccurs;
        }

        @Override
        public int getGrouping() {
            return 16;
        }

        @Override
        public Element findChildElement(String localName, URI namespaceURI) {
            if (this.children == null) {
                return null;
            }
            for (ElementGrouping child : this.children) {
                Element t = child.findChildElement(localName, namespaceURI);
                if (t == null) continue;
                return t;
            }
            return null;
        }
    }
}

