/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;

public abstract class XSIElementHandler
implements Serializable {
    public static final Logger logger = Logging.getLogger(XSIElementHandler.class);
    private static Level level = Level.WARNING;
    public static final int DEFAULT = 0;
    public static final int UNION = 1;
    public static final int LIST = 2;
    public static final int RESTRICTION = 4;
    public static final int EXTENSION = 64;
    public static final int SIMPLETYPE = 8;
    public static final int SEQUENCE = 16;
    public static final int FACET = 32;

    protected XSIElementHandler() {
        logger.setLevel(level);
    }

    public abstract int getHandlerType();

    public void characters(String text) throws SAXException {
        throw new SAXNotSupportedException("Should overide this method.");
    }

    public abstract void endElement(String var1, String var2) throws SAXException;

    public abstract void startElement(String var1, String var2, Attributes var3) throws SAXException;

    public abstract XSIElementHandler getHandler(String var1, String var2) throws SAXException;

    public abstract String getLocalName();

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof XSIElementHandler) {
            XSIElementHandler ob = (XSIElementHandler)obj;
            if (this.getLocalName() != null) {
                return this.getLocalName().equals(ob.getLocalName());
            }
            return null == ob.getLocalName();
        }
        return false;
    }

    public abstract int hashCode();

    public static void setLogLevel(Level l) {
        level = l;
        logger.setLevel(l);
    }
}

