/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.geotools.util.ObjectCache;

final class SoftObjectCache<K, V>
implements ObjectCache<K, V> {
    private final Map<K, SoftReference<V>> cache;
    private final Map<K, ReentrantLock> locks;

    public SoftObjectCache() {
        this(50);
    }

    public SoftObjectCache(int initialSize) {
        this.cache = Collections.synchronizedMap(new HashMap(initialSize));
        this.locks = new HashMap<K, ReentrantLock>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<K, ReentrantLock> map = this.locks;
        synchronized (map) {
            this.locks.clear();
            this.cache.clear();
        }
    }

    @Override
    public V get(K key) {
        SoftReference<V> reference = this.cache.get(key);
        if (reference == null) {
            return null;
        }
        V value = reference.get();
        if (value == null) {
            this.cache.remove(key);
        }
        return value;
    }

    @Override
    public Set<K> getKeys() {
        return new HashSet<K>(this.cache.keySet());
    }

    @Override
    public V peek(K key) {
        SoftReference<V> reference = this.cache.get(key);
        if (reference == null) {
            return null;
        }
        return reference.get();
    }

    @Override
    public void put(K key, V object) {
        this.writeLock(key);
        SoftReference<V> reference = new SoftReference<V>(object);
        this.cache.put(key, reference);
        this.writeUnLock(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object key) {
        Map<K, ReentrantLock> map = this.locks;
        synchronized (map) {
            this.locks.remove(key);
            this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLock(K key) {
        ReentrantLock lock;
        Map<K, ReentrantLock> map = this.locks;
        synchronized (map) {
            lock = this.locks.get(key);
            if (lock == null) {
                lock = new ReentrantLock();
                this.locks.put(key, lock);
            }
        }
        lock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeUnLock(K key) {
        Map<K, ReentrantLock> map = this.locks;
        synchronized (map) {
            ReentrantLock lock = this.locks.get(key);
            if (lock == null) {
                throw new IllegalMonitorStateException("Cannot unlock prior to locking");
            }
            if (lock.getHoldCount() == 0) {
                throw new IllegalMonitorStateException("Cannot unlock prior to locking");
            }
            lock.unlock();
        }
    }
}

