/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.geotools.util.ObjectCache;

final class DefaultObjectCache<K, V>
implements ObjectCache<K, V> {
    private final Map<K, ObjectCacheEntry<V>> cache;

    public DefaultObjectCache() {
        this.cache = new HashMap<K, ObjectCacheEntry<V>>();
    }

    public DefaultObjectCache(int initialSize) {
        this.cache = new HashMap<K, ObjectCacheEntry<V>>(initialSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<K, ObjectCacheEntry<V>> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    public V get(K key) {
        return this.getEntry(key).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V peek(K key) {
        Map<K, ObjectCacheEntry<V>> map = this.cache;
        synchronized (map) {
            if (!this.cache.containsKey(key)) {
                return null;
            }
            return this.getEntry(key).peek();
        }
    }

    @Override
    public void writeLock(K key) {
        this.getEntry(key).writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeUnLock(K key) {
        Map<K, ObjectCacheEntry<V>> map = this.cache;
        synchronized (map) {
            if (!this.cache.containsKey(key)) {
                throw new IllegalStateException("Cannot unlock prior to locking");
            }
            this.getEntry(key).writeUnLock();
        }
    }

    @Override
    public void put(K key, V object) {
        this.getEntry(key).setValue(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectCacheEntry<V> getEntry(K key) {
        Map<K, ObjectCacheEntry<V>> map = this.cache;
        synchronized (map) {
            ObjectCacheEntry<V> entry = this.cache.get(key);
            if (entry == null) {
                entry = new ObjectCacheEntry();
                this.cache.put(key, entry);
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> getKeys() {
        Map<K, ObjectCacheEntry<V>> map = this.cache;
        synchronized (map) {
            return new HashSet<K>(this.cache.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        Map<K, ObjectCacheEntry<V>> map = this.cache;
        synchronized (map) {
            this.cache.remove(key);
        }
    }

    static final class ObjectCacheEntry<V> {
        private volatile V value;
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        public ObjectCacheEntry() {
        }

        public ObjectCacheEntry(V value) {
            this.value = value;
        }

        public V peek() {
            try {
                this.lock.writeLock().lock();
                V v = this.value;
                return v;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public V getValue() {
            try {
                this.lock.readLock().lock();
                V v = this.value;
                return v;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setValue(V value) {
            try {
                this.lock.writeLock().lock();
                this.value = value;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public boolean writeLock() {
            this.lock.writeLock().lock();
            return true;
        }

        public void writeUnLock() {
            this.lock.writeLock().unlock();
        }
    }
}

