/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public class Robinson
extends MapProjection {
    private static final long serialVersionUID = 8428056162968814860L;
    private static final Coeff[] X = new Coeff[]{new Coeff(1.0, -5.67239E-12, -7.15511E-5, 3.11028E-6), new Coeff(0.9986, -4.82241E-4, -2.4897E-5, -1.33094E-6), new Coeff(0.9954, -8.31031E-4, -4.4861E-5, -9.86588E-7), new Coeff(0.99, -0.00135363, -5.96598E-5, 3.67749E-6), new Coeff(0.9822, -0.00167442, -4.4975E-6, -5.72394E-6), new Coeff(0.973, -0.00214869, -9.03565E-5, 1.88767E-8), new Coeff(0.96, -0.00305084, -9.00732E-5, 1.64869E-6), new Coeff(0.9427, -0.00382792, -6.53428E-5, -2.61493E-6), new Coeff(0.9216, -0.00467747, -1.04566E-4, 4.8122E-6), new Coeff(0.8962, -0.00536222, -3.23834E-5, -5.43445E-6), new Coeff(0.8679, -0.00609364, -1.139E-4, 3.32521E-6), new Coeff(0.835, -0.00698325, -6.40219E-5, 9.34582E-7), new Coeff(0.7986, -0.00755337, -5.00038E-5, 9.35532E-7), new Coeff(0.7597, -0.00798325, -3.59716E-5, -2.27604E-6), new Coeff(0.7186, -0.00851366, -7.0112E-5, -8.63072E-6), new Coeff(0.6732, -0.00986209, -1.99572E-4, 1.91978E-5), new Coeff(0.6213, -0.010418, 8.83948E-5, 6.24031E-6), new Coeff(0.5722, -0.00906601, 1.81999E-4, 6.24033E-6), new Coeff(0.5322, 0.0, 0.0, 0.0)};
    private static final Coeff[] Y = new Coeff[]{new Coeff(0.0, 0.0124, 3.72529E-10, 1.15484E-9), new Coeff(0.062, 0.0124001, 1.76951E-8, -5.92321E-9), new Coeff(0.124, 0.0123998, -7.09668E-8, 2.25753E-8), new Coeff(0.186, 0.0124008, 2.66917E-7, -8.44523E-8), new Coeff(0.248, 0.0123971, -9.99682E-7, 3.15569E-7), new Coeff(0.31, 0.0124108, 3.73349E-6, -1.1779E-6), new Coeff(0.372, 0.0123598, -1.3935E-5, 4.39588E-6), new Coeff(0.434, 0.0125501, 5.20034E-5, -1.00051E-5), new Coeff(0.4968, 0.0123198, -9.80735E-5, 9.22397E-6), new Coeff(0.5571, 0.0120308, 4.02857E-5, -5.2901E-6), new Coeff(0.6176, 0.0120369, -3.90662E-5, 7.36117E-7), new Coeff(0.6769, 0.0117015, -2.80246E-5, -8.54283E-7), new Coeff(0.7346, 0.0113572, -4.08389E-5, -5.18524E-7), new Coeff(0.7903, 0.0109099, -4.86169E-5, -1.0718E-6), new Coeff(0.8435, 0.0103433, -6.46934E-5, 5.36384E-9), new Coeff(0.8936, 0.00969679, -6.46129E-5, -8.54894E-6), new Coeff(0.9394, 0.00840949, -1.92847E-4, -4.21023E-6), new Coeff(0.9761, 0.00616525, -2.56001E-4, -4.21021E-6), new Coeff(1.0, 0.0, 0.0, 0.0)};
    private static final double FXC = 0.8487;
    private static final double FYC = 1.3523;
    private static final double C1 = 11.459155902616464;
    private static final double RC1 = 0.08726646259971647;
    private final int NODES = 18;
    private static final double ONEEPS = 1.000001;
    private static final double EPS = 1.0E-12;

    protected Robinson(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    protected Point2D transformNormalized(double lam, double phi, Point2D ptDst) throws ProjectionException {
        double dphi = Math.abs(phi);
        int i = (int)Math.floor(dphi * 11.459155902616464);
        if (i >= 18) {
            i = 17;
        }
        dphi = Math.toDegrees(dphi - 0.08726646259971647 * (double)i);
        double x = X[i].forward(dphi) * 0.8487 * lam;
        double y = Y[i].forward(dphi) * 1.3523;
        if (phi < 0.0) {
            y = -y;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double lam = x / 0.8487;
        double phi = Math.abs(y / 1.3523);
        if (phi >= 1.0) {
            if (phi > 1.000001) {
                throw new ProjectionException("Tolerance error occurred appling inverse Robinson projection");
            }
            phi = y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            lam /= Robinson.X[18].c0;
        } else {
            double t1;
            int i = (int)Math.floor(phi * 18.0);
            while (true) {
                if (Robinson.Y[i].c0 > phi) {
                    --i;
                    continue;
                }
                if (!(Robinson.Y[i + 1].c0 <= phi)) break;
                ++i;
            }
            Coeff T = new Coeff(Y[i]);
            double t = 5.0 * (phi - T.c0) / (Robinson.Y[i + 1].c0 - T.c0);
            T.c0 -= phi;
            do {
                t1 = T.forward(t) / T.inverse(t);
                t -= t1;
            } while (!(Math.abs(t1) < 1.0E-12));
            phi = Math.toRadians((double)(5 * i) + t);
            if (y < 0.0) {
                phi = -phi;
            }
            lam /= X[i].forward(t);
        }
        if (ptDst != null) {
            ptDst.setLocation(lam, phi);
            return ptDst;
        }
        return new Point2D.Double(lam, phi);
    }

    @Override
    protected double getToleranceForAssertions(double longitude, double latitude) {
        return 2.0;
    }

    public static void main(String ... args) {
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 3586488124601927036L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, "Robinson"), new NamedIdentifier(Citations.ESRI, "Robinson")}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN});

        public Provider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new Robinson(parameters);
        }
    }

    static final class Coeff {
        double c0;
        double c1;
        double c2;
        double c3;

        public Coeff(double c0, double c1, double c2, double c3) {
            this.c0 = c0;
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
        }

        public Coeff(Coeff other) {
            this.c0 = other.c0;
            this.c1 = other.c1;
            this.c2 = other.c2;
            this.c3 = other.c3;
        }

        public final double forward(double z) {
            return this.c0 + z * (this.c1 + z * (this.c2 + z * this.c3));
        }

        public final double inverse(double z) {
            return this.c1 + z * (this.c2 + this.c2 + z * 3.0 * this.c3);
        }
    }
}

