/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml3.simple.CurveEncoder;
import org.geotools.gml3.simple.LineStringEncoder;
import org.geotools.gml3.simple.LinearRingEncoder;
import org.geotools.gml3.simple.MultiLineStringEncoder;
import org.geotools.gml3.simple.MultiPointEncoder;
import org.geotools.gml3.simple.MultiPolygonEncoder;
import org.geotools.gml3.simple.PointEncoder;
import org.geotools.gml3.simple.PolygonEncoder;
import org.geotools.xsd.Encoder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.xml.sax.helpers.AttributesImpl;

public class GenericGeometryEncoder
extends GeometryEncoder<Geometry> {
    Encoder encoder;
    String gmlPrefix;
    String gmlUri;

    public GenericGeometryEncoder(Encoder encoder) {
        this(encoder, "gml", "http://www.opengis.net/gml");
    }

    public GenericGeometryEncoder(Encoder encoder, String gmlPrefix, String gmlUri) {
        super(encoder);
        this.init(encoder, gmlPrefix, gmlUri);
    }

    public GenericGeometryEncoder(Encoder encoder, String gmlPrefix, String gmlUri, boolean encodeGmlId) {
        super(encoder, encodeGmlId);
        this.init(encoder, gmlPrefix, gmlUri);
    }

    private void init(Encoder encoder, String gmlPrefix, String gmlUri) {
        this.encoder = encoder;
        this.gmlPrefix = gmlPrefix;
        this.gmlUri = gmlUri;
    }

    @Override
    public void encode(Geometry geometry, AttributesImpl atts, GMLWriter handler, String parentId) throws Exception {
        if (geometry instanceof LineString) {
            LineStringEncoder lineString = new LineStringEncoder(this.encoder, LineStringEncoder.LINE_STRING);
            lineString.encode((LineString)geometry, atts, handler, parentId);
        } else if (geometry instanceof Point) {
            PointEncoder pt = new PointEncoder(this.encoder, this.gmlPrefix, this.gmlUri);
            pt.encode((Point)geometry, atts, handler, parentId);
        } else if (geometry instanceof Polygon) {
            PolygonEncoder polygon = new PolygonEncoder(this.encoder, this.gmlPrefix, this.gmlUri);
            polygon.encode((Polygon)geometry, atts, handler, parentId);
        } else if (geometry instanceof MultiLineString) {
            MultiLineStringEncoder multiLineString = new MultiLineStringEncoder(this.encoder, this.gmlPrefix, this.gmlUri, true);
            multiLineString.encode(geometry, atts, handler, parentId);
        } else if (geometry instanceof MultiPoint) {
            MultiPointEncoder multiPoint = new MultiPointEncoder(this.encoder, this.gmlPrefix, this.gmlUri);
            multiPoint.encode((MultiPoint)geometry, atts, handler, parentId);
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygonEncoder multiPolygon = new MultiPolygonEncoder(this.encoder, this.gmlPrefix, this.gmlUri);
            multiPolygon.encode((MultiPolygon)geometry, atts, handler, parentId);
        } else if (geometry instanceof LinearRing) {
            LinearRingEncoder linearRing = new LinearRingEncoder(this.encoder, this.gmlPrefix, this.gmlUri);
            linearRing.encode((LineString)((LinearRing)geometry), atts, handler, parentId);
        } else if (geometry instanceof CircularString || geometry instanceof CompoundCurve || geometry instanceof CircularRing || geometry instanceof CompoundRing) {
            CurveEncoder curve = new CurveEncoder(this.encoder, this.gmlPrefix, this.gmlUri);
            curve.encode((LineString)geometry, atts, handler, parentId);
        } else {
            throw new Exception("Unsupported geometry " + geometry.toString());
        }
    }
}

