/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml.producer;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;

public final class CoordinateFormatter {
    private static final double DECIMAL_MIN = Math.pow(10.0, -3.0);
    private static final double DECIMAL_MAX = Math.pow(10.0, 7.0);
    private final NumberFormat coordFormatter = NumberFormat.getInstance(Locale.US);
    private final FieldPosition ZERO = new FieldPosition(0);
    private final double scale;
    private boolean forcedDecimal;
    private boolean padWithZeros = false;

    public CoordinateFormatter(int numDecimals) {
        this.coordFormatter.setMaximumFractionDigits(numDecimals);
        this.coordFormatter.setGroupingUsed(false);
        this.scale = Math.pow(10.0, numDecimals);
    }

    public String format(double x) {
        StringBuffer sb = new StringBuffer();
        this.format(x, sb);
        return sb.toString();
    }

    private String zeroPad(String formatted) {
        if (this.padWithZeros) {
            int numDecimals = this.coordFormatter.getMaximumFractionDigits();
            if (formatted.indexOf(".") == -1) {
                return formatted + "." + this.repeatZeros(numDecimals);
            }
            int decimals = numDecimals - formatted.substring(formatted.toString().indexOf(46) + 1).length();
            if (formatted.toString().toLowerCase().indexOf("e") == -1 && decimals > 0) {
                return formatted + this.repeatZeros(decimals);
            }
        }
        return formatted;
    }

    private String repeatZeros(int num) {
        char[] zeros = new char[num];
        Arrays.fill(zeros, '0');
        return new String(zeros);
    }

    public StringBuffer format(double x, StringBuffer sb) {
        String formatted;
        if (Math.abs(x) >= DECIMAL_MIN && Math.abs(x) < DECIMAL_MAX || x == 0.0) {
            long lx = (long)(x = this.truncate(x));
            formatted = (double)lx == x ? lx + "" : x + "";
        } else if (this.forcedDecimal) {
            StringBuffer temp = new StringBuffer();
            this.coordFormatter.format(x, temp, this.ZERO);
            formatted = temp.toString();
        } else {
            formatted = this.truncate(x) + "";
        }
        return sb.append(this.zeroPad(formatted));
    }

    final double truncate(double x) {
        double scaled = x * this.scale;
        scaled = Math.signum(x) < 0.0 ? Math.ceil(scaled) : Math.floor(scaled += Math.signum(x) * 0.5);
        return scaled / this.scale;
    }

    public int getMaximumFractionDigits() {
        return this.coordFormatter.getMaximumFractionDigits();
    }

    public void setMaximumFractionDigits(int maxDigits) {
        this.coordFormatter.setMaximumFractionDigits(maxDigits);
    }

    public boolean isForcedDecimal() {
        return this.forcedDecimal;
    }

    public boolean isPadWithZeros() {
        return this.padWithZeros;
    }

    public void setForcedDecimal(boolean forcedDecimal) {
        this.forcedDecimal = forcedDecimal;
    }

    public void setPadWithZeros(boolean pad) {
        this.padWithZeros = pad;
    }
}

