/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.geopkg.DataColumn;
import org.geotools.geopkg.DataColumnConstraint;
import org.geotools.geopkg.GeoPackage;
import org.geotools.geopkg.GeoPkgExtension;
import org.geotools.geopkg.GeoPkgExtensionFactory;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;

public class GeoPkgSchemaExtension
extends GeoPkgExtension {
    static final Logger LOGGER = Logging.getLogger(GeoPkgSchemaExtension.class);
    static final String NAME = "gpkg_schema";
    static final String DEFINITION = "http://www.geopackage.org/spec121/index.html#extension_schema";

    public GeoPkgSchemaExtension(GeoPackage geoPackage) {
        super(NAME, DEFINITION, GeoPkgExtension.Scope.ReadWrite, geoPackage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DataColumn> getDataColumns(String tableName) throws IOException {
        try (Connection cx = this.geoPackage.connPool.getConnection();){
            List<DataColumn> list = this.getDataColumns(tableName, cx);
            return list;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    List<DataColumn> getDataColumns(String tableName, Connection cx) throws IOException, SQLException {
        ArrayList<DataColumn> result = new ArrayList<DataColumn>();
        if (!this.isRegistered(cx)) {
            return Collections.emptyList();
        }
        String sql = String.format("SELECT * FROM %s WHERE table_name = ? order by table_name, column_name", "gpkg_data_columns");
        try (PreparedStatement ps = cx.prepareStatement(sql);){
            ps.setString(1, tableName);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    DataColumn dc = new DataColumn();
                    String columnName = rs.getString("column_name");
                    dc.setColumnName(columnName);
                    dc.setName(rs.getString("column_name"));
                    dc.setTitle(rs.getString("title"));
                    dc.setDescription(rs.getString("description"));
                    dc.setMimeType(rs.getString("mime_type"));
                    String constraintName = rs.getString("constraint_name");
                    if (constraintName != null) {
                        dc.setConstraint(this.getConstraint(constraintName, cx));
                    }
                    result.add(dc);
                }
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataColumnConstraint getConstraint(String contraintName) throws IOException {
        try (Connection cx = this.geoPackage.connPool.getConnection();){
            DataColumnConstraint dataColumnConstraint = this.getConstraint(contraintName, cx);
            return dataColumnConstraint;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    DataColumnConstraint getConstraint(String contraintName, Connection cx) throws SQLException {
        if (!this.isRegistered(cx)) {
            return null;
        }
        String sql = String.format("SELECT * FROM %s dcc  WHERE dcc.constraint_name = ?", "gpkg_data_column_constraints");
        DataColumnConstraint constraint = null;
        try (PreparedStatement ps = cx.prepareStatement(sql);){
            ps.setString(1, contraintName);
            LinkedHashMap<String, String> enumValues = null;
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String constraintName = rs.getString("constraint_name");
                    String constraintType = rs.getString("constraint_type");
                    if (constraint == null) {
                        if ("enum".equals(constraintType)) {
                            enumValues = new LinkedHashMap<String, String>();
                            constraint = new DataColumnConstraint.Enum(constraintName, enumValues);
                        } else if ("glob".equals(constraintType)) {
                            constraint = new DataColumnConstraint.Glob(constraintName, rs.getString("value"));
                        } else if ("range".equals(constraintType)) {
                            Double min = rs.getDouble("min");
                            boolean minInclusve = rs.getBoolean("min_is_inclusive");
                            Double max = rs.getDouble("max");
                            boolean maxInclusve = rs.getBoolean("max_is_inclusive");
                            NumberRange<Double> range = new NumberRange<Double>(Double.class, min, minInclusve, max, maxInclusve);
                            constraint = new DataColumnConstraint.Range<Double>(constraintName, range);
                        } else {
                            LOGGER.warning("Cannot process a constraint of type " + constraintType + ", ignoring");
                        }
                    }
                    if (!"enum".equals(constraintType)) continue;
                    enumValues.put(rs.getString("value"), rs.getString("description"));
                }
            }
        }
        return constraint;
    }

    public void addDataColumn(String tableName, DataColumn dataColumn) throws IOException {
        try (Connection cx = this.geoPackage.connPool.getConnection();){
            this.addDataColumn(tableName, dataColumn, cx);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    void addDataColumn(String tableName, DataColumn dataColumn, Connection cx) throws IOException, SQLException {
        DataColumnConstraint constraint = dataColumn.getConstraint();
        String constraintName = null;
        if (constraint != null) {
            constraintName = constraint.getName();
            if (this.getConstraint(constraint.getName(), cx) == null) {
                this.addConstraint(cx, constraint);
            }
        }
        String dataColumnSql = String.format("INSERT INTO %s VALUES(?, ?, ?, ?, ?, ?, ?)", "gpkg_data_columns");
        try (PreparedStatement ps = cx.prepareStatement(dataColumnSql);){
            ps.setString(1, tableName);
            ps.setString(2, dataColumn.getColumnName());
            ps.setString(3, dataColumn.getName());
            ps.setString(4, dataColumn.getTitle());
            ps.setString(5, dataColumn.getDescription());
            ps.setString(6, dataColumn.getMimeType());
            ps.setString(7, constraintName);
            ps.executeUpdate();
        }
        String extensionSql = String.format("INSERT INTO %s VALUES(?, ?, ?, ?, ?)", "gpkg_extensions");
        try (PreparedStatement ps = cx.prepareStatement(extensionSql);){
            ps.setString(1, tableName);
            ps.setString(2, dataColumn.getColumnName());
            ps.setString(3, NAME);
            ps.setString(4, DEFINITION);
            ps.setString(5, "read-write");
            ps.executeUpdate();
        }
    }

    public void addConstraint(DataColumnConstraint constraint) throws SQLException {
        try (Connection cx = this.geoPackage.connPool.getConnection();){
            this.addConstraint(cx, constraint);
        }
    }

    public void addConstraint(Connection cx, DataColumnConstraint constraint) throws SQLException {
        String constraintName = constraint.getName();
        String sql = String.format("INSERT INTO %s VALUES(?, ?, ?, ?, ?, ?, ?, ?)", "gpkg_data_column_constraints");
        if (constraint instanceof DataColumnConstraint.Enum) {
            DataColumnConstraint.Enum cEnum = (DataColumnConstraint.Enum)constraint;
            for (Map.Entry<String, String> entry : cEnum.getValues().entrySet()) {
                PreparedStatement ps = cx.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    ps.setString(1, constraintName);
                    ps.setString(2, "enum");
                    ps.setString(3, entry.getKey());
                    ps.setObject(4, null);
                    ps.setObject(5, null);
                    ps.setObject(6, null);
                    ps.setObject(7, null);
                    ps.setString(8, entry.getValue());
                    ps.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps == null) continue;
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ps.close();
                }
            }
        } else {
            if (constraint instanceof DataColumnConstraint.Glob) {
                try (PreparedStatement ps = cx.prepareStatement(sql);){
                    ps.setString(1, constraintName);
                    ps.setString(2, "glob");
                    ps.setString(3, ((DataColumnConstraint.Glob)constraint).getGlob());
                    ps.setObject(4, null);
                    ps.setObject(5, null);
                    ps.setObject(6, null);
                    ps.setObject(7, null);
                    ps.setString(8, null);
                    ps.executeUpdate();
                }
            }
            if (constraint instanceof DataColumnConstraint.Range) {
                DataColumnConstraint.Range rangeConstraint = (DataColumnConstraint.Range)constraint;
                NumberRange range = rangeConstraint.getRange();
                try (PreparedStatement ps = cx.prepareStatement(sql);){
                    ps.setString(1, constraintName);
                    ps.setString(2, "range");
                    ps.setString(3, null);
                    ps.setDouble(4, range.getMinimum());
                    ps.setBoolean(5, range.isMinIncluded());
                    ps.setDouble(6, range.getMaximum());
                    ps.setBoolean(7, range.isMaxIncluded());
                    ps.setString(8, null);
                    ps.executeUpdate();
                }
            }
        }
    }

    public static class Factory
    implements GeoPkgExtensionFactory {
        @Override
        public GeoPkgExtension getExtension(String name, GeoPackage geoPackage) {
            if (GeoPkgSchemaExtension.NAME.equals(name)) {
                return new GeoPkgSchemaExtension(geoPackage);
            }
            return null;
        }

        @Override
        public GeoPkgExtension getExtension(Class extensionClass, GeoPackage geoPackage) {
            if (GeoPkgSchemaExtension.class.equals((Object)extensionClass)) {
                return new GeoPkgSchemaExtension(geoPackage);
            }
            return null;
        }
    }
}

