/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import javax.xml.namespace.QName;
import org.geotools.filter.Filters;
import org.geotools.filter.v1_0.OGC;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.picocontainer.MutablePicoContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.NamespaceSupport;

public class OGCPropertyNameTypeBinding
extends AbstractComplexBinding {
    protected FilterFactory2 factory;
    protected NamespaceSupport namespaceSupport;

    public OGCPropertyNameTypeBinding(FilterFactory2 factory, NamespaceSupport namespaceSupport) {
        this.factory = factory;
        this.namespaceSupport = namespaceSupport;
    }

    @Override
    public QName getTarget() {
        return OGC.PropertyNameType;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return PropertyName.class;
    }

    @Override
    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        Expression expression = (Expression)value;
        String xpath = Filters.asString(expression);
        if (xpath == null) {
            xpath = "";
        }
        return this.factory.property(xpath, GML3EncodingUtils.copyNamespaceSupport(this.namespaceSupport));
    }

    @Override
    public Element encode(Object object, Document document, Element value) throws Exception {
        PropertyName propertyName = (PropertyName)object;
        if (propertyName.getPropertyName() != null) {
            value.appendChild(document.createTextNode(propertyName.getPropertyName()));
        }
        return value;
    }
}

