/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import javax.xml.namespace.QName;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.v1_0.OGC;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.gml3.GML;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Envelope;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OGCBBOXTypeBinding
extends AbstractComplexBinding {
    private FilterFactory2 factory = CommonFactoryFinder.getFilterFactory2(null);
    private CoordinateReferenceSystem crs;

    @Override
    public QName getTarget() {
        return OGC.BBOXType;
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public Class getType() {
        return BBOX.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        Node srsNode;
        String srs;
        PropertyName propertyName = node.getChildValue(PropertyName.class);
        Envelope box = node.getChildValue(Envelope.class);
        if (box instanceof ReferencedEnvelope) {
            return this.factory.bbox((Expression)(propertyName == null ? this.factory.property("") : propertyName), (ReferencedEnvelope)box);
        }
        String name = null;
        if (propertyName != null) {
            name = propertyName.getPropertyName();
        }
        if (name == null) {
            name = "";
        }
        String string = srs = (srsNode = node.getChild(Envelope.class).getAttribute("srsName")) != null ? srsNode.getValue().toString() : null;
        if (srs == null && this.crs != null) {
            srs = GML2EncodingUtils.toURI(this.crs);
        }
        return this.factory.bbox(name, box.getMinX(), box.getMinY(), box.getMaxX(), box.getMaxY(), srs);
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        BBOX box = (BBOX)object;
        if (OGC.PropertyName.equals(name)) {
            return box.getExpression1();
        }
        if (org.geotools.gml2.GML.Box.equals(name) || GML.Envelope.equals(name)) {
            Envelope env = box.getExpression2().evaluate(null, ReferencedEnvelope.class);
            if (env == null) {
                env = box.getExpression2().evaluate(null, Envelope.class);
            }
            return env;
        }
        return null;
    }
}

