/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.geotools.filter.CompareFilterImpl;
import org.geotools.util.Converters;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;

public abstract class MultiCompareFilterImpl
extends CompareFilterImpl {
    protected MultiValuedFilter.MatchAction matchAction;

    protected MultiCompareFilterImpl(Expression e1, Expression e2) {
        super(e1, e2);
        this.matchAction = MultiValuedFilter.MatchAction.ANY;
    }

    protected MultiCompareFilterImpl(Expression e1, Expression e2, boolean matchCase) {
        super(e1, e2, matchCase);
        this.matchAction = MultiValuedFilter.MatchAction.ANY;
    }

    protected MultiCompareFilterImpl(Expression e1, Expression e2, MultiValuedFilter.MatchAction matchAction) {
        super(e1, e2);
        this.matchAction = matchAction;
    }

    protected MultiCompareFilterImpl(Expression e1, Expression e2, boolean matchCase, MultiValuedFilter.MatchAction matchAction) {
        super(e1, e2, matchCase);
        this.matchAction = matchAction;
    }

    @Override
    public MultiValuedFilter.MatchAction getMatchAction() {
        return this.matchAction;
    }

    private Collection<Object> toCollection(Object obj) {
        Object collection = null;
        if (obj instanceof Collection) {
            collection = obj;
        }
        if (obj != null && obj.getClass().isArray()) {
            collection = Converters.convert(obj, List.class);
        }
        Collection cast = (Collection)collection;
        return cast;
    }

    @Override
    public final boolean evaluate(Object feature) {
        Object object1 = this.eval(this.expression1, feature);
        Object object2 = this.eval(this.expression2, feature);
        Collection<Object> collection1 = this.toCollection(object1);
        Collection<Object> collection2 = this.toCollection(object2);
        if (collection1 == null && collection2 == null) {
            return this.evaluateInternal(object1, object2);
        }
        Collection<Object> leftValues = collection1 instanceof Collection ? collection1 : Collections.singletonList(object1);
        Collection<Object> rightValues = collection2 instanceof Collection ? collection2 : Collections.singletonList(object2);
        int count = 0;
        for (Object value1 : leftValues) {
            for (Object value2 : rightValues) {
                boolean temp = this.evaluateInternal(value1, value2);
                if (temp) {
                    ++count;
                }
                switch (this.matchAction) {
                    case ONE: {
                        if (count <= 1) break;
                        return false;
                    }
                    case ALL: {
                        if (temp) break;
                        return false;
                    }
                    case ANY: {
                        if (!temp) break;
                        return true;
                    }
                }
            }
        }
        switch (this.matchAction) {
            case ONE: {
                return count == 1;
            }
            case ALL: {
                return true;
            }
            case ANY: {
                return false;
            }
        }
        return false;
    }

    public abstract boolean evaluateInternal(Object var1, Object var2);
}

