/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import it.geosolutions.jaiext.JAIExt;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.media.jai.OperationDescriptor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.ExtendedImagingParameterDescriptors;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.ImagingParameterDescriptors;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public abstract class BaseMathOperationJAI
extends OperationJAI {
    private static final long serialVersionUID = 6830028735162290160L;
    public static final Logger LOGGER = Logging.getLogger(BaseMathOperationJAI.class);
    public static final String SOURCES_NAME = "Sources";
    public static final ParameterDescriptor<Collection> SOURCES = new DefaultParameterDescriptor<Object>(Citations.JAI, "Sources", Collection.class, null, null, null, null, null, true);
    private static Set<ParameterDescriptor> REPLACED_DESCRIPTORS;

    public BaseMathOperationJAI(OperationDescriptor operationDescriptor) {
        super(operationDescriptor, new ImagingParameterDescriptors(BaseMathOperationJAI.getOperationDescriptor(operationDescriptor.getName()), REPLACED_DESCRIPTORS));
    }

    public BaseMathOperationJAI(OperationDescriptor operationDescriptor, ImagingParameterDescriptors replacements) {
        super(operationDescriptor, new ImagingParameterDescriptors(ImagingParameterDescriptors.properties(operationDescriptor), operationDescriptor, "rendered", ImagingParameterDescriptors.DEFAULT_SOURCE_TYPE_MAP, REPLACED_DESCRIPTORS));
    }

    public BaseMathOperationJAI(String name, OperationDescriptor operationDescriptor) {
        super(BaseMathOperationJAI.getOperationDescriptor(JAIExt.getOperationName(name)), new ExtendedImagingParameterDescriptors(name, operationDescriptor, new HashSet<ParameterDescriptor>(REPLACED_DESCRIPTORS)));
    }

    public BaseMathOperationJAI(String name) {
        super(BaseMathOperationJAI.getOperationDescriptor(name), new ImagingParameterDescriptors(BaseMathOperationJAI.getOperationDescriptor(name), new HashSet<ParameterDescriptor>(REPLACED_DESCRIPTORS)));
    }

    @Override
    protected void extractSources(ParameterValueGroup parameters, Collection<GridCoverage2D> sources, String[] sourceNames) throws ParameterNotFoundException, InvalidParameterValueException {
        if (!JAIExt.isJAIExtOperation(JAIExt.getOperationName(this.getName()))) {
            super.extractSources(parameters, sources, sourceNames);
        } else {
            Utilities.ensureNonNull("parameters", parameters);
            Utilities.ensureNonNull("sources", sources);
            Object srcCoverages = parameters.parameter(SOURCES_NAME).getValue();
            if (!(srcCoverages instanceof Collection) || ((Collection)srcCoverages).isEmpty() || !(((Collection)srcCoverages).iterator().next() instanceof GridCoverage2D)) {
                throw new InvalidParameterValueException(Errors.format(57, "sources"), "sources", srcCoverages);
            }
            Collection sourceCoverages = (Collection)srcCoverages;
            sources.addAll(sourceCoverages);
        }
    }

    static {
        HashSet<ParameterDescriptor<Collection>> replacedDescriptors = new HashSet<ParameterDescriptor<Collection>>();
        replacedDescriptors.add(SOURCES);
        REPLACED_DESCRIPTORS = Collections.unmodifiableSet(replacedDescriptors);
    }
}

