/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.logging.Logging;
import org.geotools.xml.XMLUtils;
import org.geotools.xsd.Binding;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.EncoderDelegate;
import org.geotools.xsd.PropertyExtractor;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.impl.BindingFactoryImpl;
import org.geotools.xsd.impl.BindingLoader;
import org.geotools.xsd.impl.BindingPropertyExtractor;
import org.geotools.xsd.impl.BindingVisitorDispatch;
import org.geotools.xsd.impl.BindingWalker;
import org.geotools.xsd.impl.BindingWalkerFactoryImpl;
import org.geotools.xsd.impl.ElementEncoder;
import org.geotools.xsd.impl.GetPropertyExecutor;
import org.geotools.xsd.impl.NamespaceSupportWrapper;
import org.geotools.xsd.impl.SchemaIndexImpl;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Property;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Encoder {
    public static final QName COMMENT = new QName("http://www.geotools.org", "comment");
    static final String INDENT_AMOUNT_KEY = "{http://xml.apache.org/xslt}indent-amount";
    private XSDSchema schema;
    private SchemaIndex index;
    private BindingLoader bindingLoader;
    private MutablePicoContainer context;
    private BindingWalker bindingWalker;
    private List<PropertyExtractor> propertyExtractors;
    private ElementEncoder encoder;
    private Document doc;
    private NamespaceSupport namespaces;
    private ContentHandler serializer;
    private Map<String, String> schemaLocations;
    private Properties outputProps;
    private boolean namespaceAware = true;
    private boolean inline = false;
    private QName rootElementType;
    private Logger logger;
    private boolean relaxed = Boolean.parseBoolean(System.getProperty("encoder.relaxed", "true"));
    private Configuration configuration;

    public Encoder(Configuration configuration) {
        this(configuration, Encoder.getSchema(configuration));
    }

    public static XSDSchema getSchema(Configuration configuration) {
        try {
            return configuration.getXSD().getSchema();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Encoder(Configuration configuration, XSDSchema schema) {
        this.configuration = configuration;
        this.schema = schema;
        this.index = new SchemaIndexImpl(new XSDSchema[]{schema});
        this.bindingLoader = new BindingLoader(configuration.setupBindings());
        this.bindingWalker = new BindingWalker(this.bindingLoader);
        this.context = new DefaultPicoContainer();
        this.context.registerComponentInstance(this);
        BindingFactoryImpl bindingFactory = new BindingFactoryImpl(this.bindingLoader);
        this.context.registerComponentInstance(bindingFactory);
        this.encoder = new ElementEncoder(this.bindingWalker, this.context);
        this.context.registerComponentInstance(this.encoder);
        this.context.registerComponentInstance(this.index);
        this.context.registerComponentInstance(new BindingWalkerFactoryImpl(this.bindingLoader, this.context));
        this.context = configuration.setupContext(this.context);
        this.encoder.setContext(this.context);
        this.schemaLocations = new HashMap<String, String>();
        this.logger = (Logger)this.context.getComponentInstanceOfType(Logger.class);
        if (this.logger == null) {
            this.logger = Logging.getLogger(Encoder.class);
            this.context.registerComponentInstance(this.logger);
        }
        this.encoder.setLogger(this.logger);
        this.namespaces = new NamespaceSupport();
        this.context.registerComponentInstance(this.namespaces);
        this.context.registerComponentInstance(new NamespaceSupportWrapper(this.namespaces));
        this.context.registerComponentInstance(configuration);
        this.propertyExtractors = Schemas.getComponentInstancesOfType(this.context, PropertyExtractor.class);
        this.propertyExtractors.add(0, new BindingPropertyExtractor(this, this.context));
        this.outputProps = new Properties();
        this.outputProps.setProperty(INDENT_AMOUNT_KEY, "2");
        configuration.setupEncoder(this);
    }

    public void setEncoding(Charset charset) {
        String charsetName = charset.name();
        this.outputProps.put("encoding", charsetName);
    }

    public Charset getEncoding() {
        String charsetName = this.outputProps.getProperty("encoding");
        return charsetName != null ? Charset.forName(charsetName) : null;
    }

    public void setOmitXMLDeclaration(boolean ommitXmlDeclaration) {
        this.outputProps.put("omit-xml-declaration", ommitXmlDeclaration ? "yes" : "no");
    }

    public boolean isOmitXMLDeclaration() {
        return "yes".equals(this.outputProps.get("omit-xml-declaration"));
    }

    public void setIndenting(boolean doIndent) {
        this.outputProps.put("indent", doIndent ? "yes" : "no");
    }

    public boolean isIndenting() {
        return "yes".equals(this.outputProps.get("indent"));
    }

    public void setIndentSize(int indentSize) {
        if (indentSize < 0) {
            throw new IllegalArgumentException("indentSize shall be >= 0: " + indentSize);
        }
        this.setIndenting(true);
        this.outputProps.setProperty(INDENT_AMOUNT_KEY, String.valueOf(indentSize));
    }

    public int getIndentSize() {
        if (this.outputProps.containsKey(INDENT_AMOUNT_KEY)) {
            return Integer.parseInt(this.outputProps.getProperty(INDENT_AMOUNT_KEY));
        }
        return 0;
    }

    public void setLineWidth(int lineWidth) {
        if (lineWidth < 0) {
            throw new IllegalArgumentException("lineWidth shall be >= 0: " + lineWidth);
        }
    }

    public int getLineWidth() {
        return 72;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public NamespaceSupport getNamespaces() {
        return this.namespaces;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public void setRootElementType(QName rootElementType) {
        this.rootElementType = rootElementType;
    }

    public void setSchemaLocation(String namespaceURI, String location) {
        this.schemaLocations.put(namespaceURI, location);
    }

    public BindingWalker getBindingWalker() {
        return this.bindingWalker;
    }

    public SchemaIndex getSchemaIndex() {
        return this.index;
    }

    public XSDSchema getSchema() {
        return this.schema;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void encode(Object object, QName name, OutputStream out) throws IOException {
        TransformerHandler xmls;
        if (this.inline) {
            String msg = "Must use 'encode(Object,QName,ContentHandler)' when inline flag is set";
            throw new IllegalStateException(msg);
        }
        SAXTransformerFactory txFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            xmls = txFactory.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e);
        }
        xmls.getTransformer().setOutputProperties(this.outputProps);
        xmls.getTransformer().setOutputProperty("method", "xml");
        xmls.setResult(new StreamResult(out));
        try {
            this.encode(object, name, xmls);
        }
        catch (SAXException e) {
            if (e.getException() != null && e.getCause() == null) {
                e.initCause(e.getException());
            }
            throw (IOException)new IOException().initCause(e);
        }
    }

    private boolean isNonStripedNestedElement(Object next, XSDElementDeclaration element) {
        if (!(next instanceof ComplexAttribute)) {
            return false;
        }
        ComplexAttribute complex = (ComplexAttribute)next;
        Collection<Property> nestedProperties = complex.getProperties();
        if (nestedProperties == null || nestedProperties.isEmpty()) {
            return false;
        }
        if (!nestedProperties.stream().allMatch(property -> property == null || property.getType().getName().equals(complex.getType().getName()))) {
            return false;
        }
        for (XSDParticle childParticle : Schemas.getChildElementParticles(element.getTypeDefinition(), true)) {
            XSDElementDeclaration childElement = (XSDElementDeclaration)childParticle.getContent();
            if (!childElement.isElementDeclarationReference() || !(childElement = childElement.getResolvedElementDeclaration()).getType().getName().equals(complex.getType().getName().getLocalPart())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encode(Object object, QName name, ContentHandler handler) throws IOException, SAXException {
        Stack<EncodingEntry> encoded = null;
        if (this.namespaces.getPrefix("http://www.w3.org/2001/XMLSchema") == null) {
            this.namespaces.declarePrefix("xs", "http://www.w3.org/2001/XMLSchema");
        }
        try {
            this.serializer = handler;
            if (!this.inline) {
                this.serializer.startDocument();
            }
            if (this.namespaceAware) {
                this.setupNamespaces();
            }
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            try {
                this.doc = docFactory.newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException e) {
                new IOException().initCause(e);
            }
            encoded = new Stack<EncodingEntry>();
            XSDElementDeclaration root = this.getRootDeclaration(name);
            encoded.add(new EncodingEntry(object, root, null));
            while (!encoded.isEmpty()) {
                EncodingEntry entry = (EncodingEntry)encoded.peek();
                if (entry.encoding != null) {
                    if (!entry.children.isEmpty()) {
                        this.processChildren(handler, encoded, entry);
                        continue;
                    }
                    this.finishElement(encoded, entry);
                    continue;
                }
                this.startEncoding(object, entry);
            }
            if (!this.inline) {
                this.serializer.endDocument();
            }
            this.index.destroy();
            if (encoded == null) return;
        }
        catch (Throwable throwable) {
            this.index.destroy();
            if (encoded == null) throw throwable;
            while (!encoded.isEmpty()) {
                EncodingEntry entry = (EncodingEntry)encoded.pop();
                if (entry.children.isEmpty()) continue;
                Object[] child = entry.children.get(0);
                Iterator itr = (Iterator)child[1];
                try {
                    this.closeIterator(itr, child[2]);
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        while (!encoded.isEmpty()) {
            EncodingEntry entry = (EncodingEntry)encoded.pop();
            if (entry.children.isEmpty()) continue;
            Object[] child = entry.children.get(0);
            Iterator itr = (Iterator)child[1];
            try {
                this.closeIterator(itr, child[2]);
            }
            catch (Exception exception) {}
        }
        return;
    }

    private void startEncoding(Object object, EncodingEntry entry) throws SAXException, IOException {
        XSDElementDeclaration substitute;
        List<XSDElementDeclaration> sub;
        if (entry.element.isAbstract() && !(sub = this.safeCopy(entry.element.getSubstitutionGroup())).isEmpty() && (substitute = this.getConcreteSubstitute(entry, sub)) != null) {
            entry.element = substitute;
        }
        if (entry.element.isAbstract()) {
            this.logger.fine(entry.element.getName() + " is abstract");
        }
        entry.encoding = entry.parent != null ? (Element)this.encode(entry.object, entry.element, entry.parent.element.getType()) : (Element)this.encode(entry.object, entry.element);
        this.setupEntryAttributes(object, entry);
        this.setupSchemaLocations(entry);
        this.start(entry.encoding, entry.element);
        this.populateChildren(entry);
    }

    private void setupEntryAttributes(Object object, EncodingEntry entry) {
        List attributes = this.index.getAttributes(entry.element);
        for (Object value : attributes) {
            Attr attr;
            String local;
            XSDAttributeDeclaration attribute = (XSDAttributeDeclaration)value;
            String ns = attribute.getTargetNamespace();
            if (entry.encoding.getAttributeNS(ns, local = attribute.getName()) != null && !"".equals(entry.encoding.getAttributeNS(ns, local))) continue;
            GetPropertyExecutor executor = new GetPropertyExecutor(entry.object, attribute);
            BindingVisitorDispatch.walk(object, this.bindingWalker, entry.element, executor, this.context);
            if (executor.getChildObject() == null || (attr = (Attr)this.encode(executor.getChildObject(), attribute)) == null) continue;
            entry.encoding.setAttributeNodeNS(attr);
        }
    }

    private void populateChildren(EncodingEntry entry) throws SAXException, IOException {
        for (PropertyExtractor propertyExtractor : this.propertyExtractors) {
            if (!propertyExtractor.canHandle(entry.object)) continue;
            List extracted = propertyExtractor.properties(entry.object, entry.element);
            block1: for (Object o : extracted) {
                XSDParticle cParticle;
                XSDModelGroup group;
                Object[] tuple = (Object[])o;
                XSDParticle particle = (XSDParticle)tuple[0];
                XSDElementDeclaration child = (XSDElementDeclaration)particle.getContent();
                if (child == null) continue;
                if (child != null && COMMENT.getNamespaceURI().equals(child.getTargetNamespace()) && COMMENT.getLocalPart().equals(child.getName())) {
                    this.comment(child.getElement());
                    continue;
                }
                if (child.isElementDeclarationReference()) {
                    child = child.getResolvedElementDeclaration();
                }
                String ns = child.getTargetNamespace();
                String local = child.getName();
                for (int i = 0; i < entry.encoding.getChildNodes().getLength(); ++i) {
                    Node node = entry.encoding.getChildNodes().item(i);
                    if (node instanceof Element && (ns != null ? ns.equals(node.getNamespaceURI()) && local.equals(node.getLocalName()) : local.equals(node.getLocalName()))) continue block1;
                }
                Object obj = tuple[1];
                if (obj == null) {
                    if (particle.getMinOccurs() == 0) continue;
                    if (!child.isNillable()) {
                        this.logger.fine("Property " + ns + ":" + local + " not found but minoccurs > 0 ");
                        continue;
                    }
                }
                int maxOccurs = 1;
                if (particle.isSetMaxOccurs()) {
                    maxOccurs = particle.getMaxOccurs();
                } else if (particle.eContainer() instanceof XSDModelGroup && (group = (XSDModelGroup)particle.eContainer()).eContainer() instanceof XSDParticle && (cParticle = (XSDParticle)group.eContainer()).isSetMaxOccurs()) {
                    maxOccurs = cParticle.getMaxOccurs();
                }
                if (maxOccurs == -1 || maxOccurs > 1) {
                    Object collection;
                    Iterator iterator = null;
                    if (obj instanceof Iterator) {
                        iterator = (SingleIterator)obj;
                    } else if (obj != null && obj.getClass().isArray()) {
                        Object[] array = (Object[])obj;
                        iterator = Arrays.asList(array).iterator();
                    } else if (obj instanceof Collection) {
                        collection = (Collection)obj;
                        iterator = collection.iterator();
                    } else if (obj instanceof FeatureCollection) {
                        collection = (FeatureCollection)obj;
                        iterator = DataUtilities.iterator(collection.features());
                    } else {
                        iterator = new SingleIterator(obj);
                    }
                    entry.children.add(new Object[]{child, iterator, obj});
                    continue;
                }
                entry.children.add(new Object[]{child, new SingleIterator(obj), obj});
            }
        }
    }

    private void setupSchemaLocations(EncodingEntry entry) throws SAXException {
        if (this.schemaLocations != null) {
            if (!this.schemaLocations.isEmpty()) {
                this.serializer.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                this.serializer.endPrefixMapping("xsi");
                this.namespaces.declarePrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                StringBuffer schemaLocation = new StringBuffer();
                Iterator<Map.Entry<String, String>> e = this.schemaLocations.entrySet().iterator();
                while (e.hasNext()) {
                    Map.Entry<String, String> tuple = e.next();
                    String namespaceURI = tuple.getKey();
                    String location = tuple.getValue();
                    schemaLocation.append(namespaceURI + " " + location);
                    if (!e.hasNext()) continue;
                    schemaLocation.append(" ");
                }
                entry.encoding.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", schemaLocation.toString());
            }
            this.schemaLocations = null;
        }
    }

    private XSDElementDeclaration getConcreteSubstitute(EncodingEntry entry, List sub) {
        ArrayList<Object[]> matches = new ArrayList<Object[]>();
        for (Object o : sub) {
            XSDElementDeclaration e = (XSDElementDeclaration)o;
            if (e == null || e.equals(entry.element) || e.getName() == null) continue;
            Binding binding = this.bindingLoader.loadBinding(new QName(e.getTargetNamespace(), e.getName()), this.context);
            if (binding == null) {
                XSDTypeDefinition type = e.getType();
                if (type == null || type.getName() == null) continue;
                binding = this.bindingLoader.loadBinding(new QName(type.getTargetNamespace(), type.getName()), this.context);
            }
            if (binding == null) continue;
            if (binding.getType() == null) {
                this.logger.warning("Binding: " + binding.getTarget() + " returns null type.");
                continue;
            }
            if (!binding.getType().isAssignableFrom(entry.object.getClass())) continue;
            matches.add(new Object[]{e, binding});
        }
        if (matches.size() == 1) {
            entry.element = (XSDElementDeclaration)((Object[])matches.get(0))[0];
        } else if (!matches.isEmpty()) {
            if (this.logger.isLoggable(Level.FINE)) {
                StringBuffer msg = new StringBuffer("Found multiple non-abstract bindings for ");
                msg.append(entry.element.getName()).append(": ");
                for (Object[] match : matches) {
                    msg.append(match.getClass().getName());
                    msg.append(", ");
                }
                this.logger.fine(msg.toString());
            }
            Collections.sort(matches, new MatchComparator());
        }
        if (!matches.isEmpty()) {
            return (XSDElementDeclaration)((Object[])matches.get(0))[0];
        }
        return null;
    }

    private void finishElement(Stack<EncodingEntry> encoded, EncodingEntry entry) throws SAXException {
        this.end(entry.encoding, entry.element);
        encoded.pop();
        entry.object = null;
        entry.element = null;
        entry.encoding = null;
        entry.children = null;
        entry.parent = null;
    }

    private void processChildren(ContentHandler handler, Stack<EncodingEntry> encoded, EncodingEntry entry) {
        Object[] child = entry.children.get(0);
        XSDElementDeclaration element = ((XSDElementDeclaration)child[0]).getResolvedElementDeclaration();
        Iterator itr = (Iterator)child[1];
        if (itr.hasNext()) {
            Object next = itr.next();
            if (next instanceof EncoderDelegate) {
                try {
                    ((EncoderDelegate)next).encode(handler);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if (next instanceof ComplexAttribute && this.relaxed && this.isNonStripedNestedElement(next, element)) {
                for (Property property : ((ComplexAttribute)next).getProperties()) {
                    encoded.push(new EncodingEntry(property, element, entry));
                }
            } else {
                encoded.push(new EncodingEntry(next, element, entry));
            }
        } else {
            Object source = child[2];
            this.closeIterator(itr, source);
            entry.children.remove(0);
        }
    }

    private XSDElementDeclaration getRootDeclaration(QName name) {
        XSDElementDeclaration root = this.index.getElementDeclaration(name);
        if (root == null) {
            QName typeDefintion = this.rootElementType;
            if (typeDefintion == null) {
                typeDefintion = (QName)this.context.getComponentInstance("http://geotools.org/typeDefinition");
            }
            if (typeDefintion != null) {
                XSDTypeDefinition type = this.index.getTypeDefinition(typeDefintion);
                if (type == null) {
                    throw new NullPointerException();
                }
                root = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                root.setName(name.getLocalPart());
                root.setTargetNamespace(name.getNamespaceURI());
                root.setTypeDefinition(type);
            }
        }
        if (root == null) {
            String msg = "Could not find element declaration for:" + name;
            throw new IllegalArgumentException(msg);
        }
        return root;
    }

    private void setupNamespaces() throws SAXException {
        Enumeration<String> e = this.namespaces.getPrefixes();
        while (e.hasMoreElements()) {
            String prefix = e.nextElement();
            String uri = this.namespaces.getURI(prefix);
            if ("xml".equals(prefix)) continue;
            this.serializer.startPrefixMapping(prefix, uri);
        }
        Iterator<Map.Entry<String, String>> iterator = this.schema.getQNamePrefixToNamespaceMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> stringStringEntry;
            Map.Entry<String, String> entry = stringStringEntry = iterator.next();
            String pre = entry.getKey();
            String ns = entry.getValue();
            if ("http://www.w3.org/2001/XMLSchema".equals(ns) || this.namespaces.getPrefix(ns) != null) continue;
            this.serializer.startPrefixMapping(pre != null ? pre : "", ns);
            this.serializer.endPrefixMapping(pre != null ? pre : "");
            this.namespaces.declarePrefix(pre != null ? pre : "", ns);
        }
        if (this.namespaces.getURI("") == null) {
            this.namespaces.declarePrefix("", this.schema.getTargetNamespace());
        }
    }

    private <T> List<T> safeCopy(EList<T> substitutionGroup) {
        while (true) {
            try {
                return new ArrayList<T>(substitutionGroup);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                continue;
            }
            break;
        }
    }

    public Document encodeAsDOM(Object object, QName name) throws IOException, SAXException, TransformerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.encode(object, name, out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        DOMResult result = new DOMResult();
        Transformer tx = TransformerFactory.newInstance().newTransformer();
        tx.transform(new StreamSource(in), result);
        return (Document)result.getNode();
    }

    public String encodeAsString(Object object, QName name) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.encode(object, name, out);
        return new String(out.toByteArray());
    }

    protected void closeIterator(Iterator iterator, Object source) {
        DataUtilities.close(iterator);
    }

    protected Node encode(Object object, XSDNamedComponent component) {
        return this.encode(object, component, null);
    }

    protected Node encode(Object object, XSDNamedComponent component, XSDTypeDefinition container) {
        if (component instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = (XSDElementDeclaration)component;
            return this.encoder.encode(object, element, this.doc, container);
        }
        if (component instanceof XSDAttributeDeclaration) {
            XSDAttributeDeclaration attribute = (XSDAttributeDeclaration)component;
            return this.encoder.encode(object, attribute, this.doc, container);
        }
        return null;
    }

    protected void start(Element element, XSDElementDeclaration declaration) throws SAXException {
        Node node;
        int i;
        String local;
        String uri;
        if (element.getLocalName() != null) {
            uri = element.getNamespaceURI();
            local = element.getLocalName();
        } else {
            local = element.getNodeName();
            if (local.contains(":")) {
                String[] split = local.split(":");
                local = split[1];
                uri = this.namespaces.getURI(split[0]);
            } else {
                uri = null;
            }
        }
        String qName = local;
        NamespaceSupport namespaces = this.namespaces;
        if (this.forceQualified(declaration)) {
            uri = uri != null ? uri : namespaces.getURI("");
            qName = namespaces.getPrefix(uri) + ":" + qName;
        } else {
            uri = "";
        }
        DOMAttributes atts = new DOMAttributes(element.getAttributes(), namespaces);
        this.serializer.startElement(uri, local, qName, atts);
        for (i = 0; i < element.getChildNodes().getLength(); ++i) {
            node = element.getChildNodes().item(i);
            if (!(node instanceof Text)) continue;
            String data = XMLUtils.removeXMLInvalidChars(((Text)node).getData());
            char[] ch = data.toCharArray();
            this.serializer.characters(ch, 0, ch.length);
        }
        for (i = 0; i < element.getChildNodes().getLength(); ++i) {
            node = element.getChildNodes().item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            QName childName = new QName(child.getNamespaceURI(), child.getNodeName());
            XSDElementDeclaration childDecl = declaration != null ? Schemas.getChildElementDeclaration(declaration, childName) : null;
            this.start(child, childDecl);
            this.end(child, childDecl);
        }
        this.namespaces.pushContext();
        if (uri != null) {
            this.namespaces.declarePrefix("", uri);
        }
    }

    boolean forceQualified(XSDElementDeclaration e) {
        return this.namespaceAware && (e == null || e.isGlobal() || e.getSchema() == null || e.getSchema().getElementFormDefault() == XSDForm.QUALIFIED_LITERAL);
    }

    protected void comment(Element element) throws SAXException, IOException {
        if (this.serializer instanceof LexicalHandler) {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node text = children.item(i);
                String str = text.getNodeValue();
                ((LexicalHandler)((Object)this.serializer)).comment(str.toCharArray(), 0, str.length());
            }
        }
    }

    protected void end(Element element, XSDElementDeclaration declaration) throws SAXException {
        this.namespaces.popContext();
        String uri = element.getNamespaceURI();
        String local = element.getLocalName();
        String qName = element.getLocalName();
        if (element.getPrefix() != null && !"".equals(element.getPrefix())) {
            qName = element.getPrefix() + ":" + qName;
        } else if (this.forceQualified(declaration)) {
            String string = uri = uri != null ? uri : this.namespaces.getURI("");
            if (uri != null) {
                qName = this.namespaces.getPrefix(uri) + ":" + qName;
            } else {
                uri = "";
            }
        }
        this.serializer.endElement(uri, local, qName);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public BindingLoader getBindingLoader() {
        return this.bindingLoader;
    }

    public PicoContainer getContext() {
        return this.context;
    }

    private static class MatchComparator
    implements Comparator<Object[]> {
        private MatchComparator() {
        }

        @Override
        public int compare(Object[] match1, Object[] match2) {
            Binding b1 = (Binding)match1[1];
            Binding b2 = (Binding)match2[1];
            if (b1.getType() != b2.getType()) {
                if (b2.getType().isAssignableFrom(b1.getType())) {
                    return -1;
                }
                if (b1.getType().isAssignableFrom(b2.getType())) {
                    return 1;
                }
            }
            if (b1 instanceof Comparable) {
                return ((Comparable)((Object)b1)).compareTo(b2);
            }
            if (b2 instanceof Comparable) {
                return -1 * ((Comparable)((Object)b2)).compareTo(b1);
            }
            return 0;
        }
    }

    private static class DOMAttributes
    implements Attributes {
        NamedNodeMap atts;
        NamespaceSupport namespaces;

        public DOMAttributes(NamedNodeMap atts, NamespaceSupport namespaces) {
            this.atts = atts;
            this.namespaces = namespaces;
        }

        @Override
        public int getLength() {
            return this.atts.getLength();
        }

        @Override
        public String getLocalName(int index) {
            int dot;
            String qName;
            String local = this.atts.item(index).getLocalName();
            if (this.nullOrEmpty(local) && !this.nullOrEmpty(qName = this.getQName(index)) && (dot = qName.indexOf(58)) > -1) {
                local = qName.split(":")[1];
            }
            return this.emptyIfNull(local);
        }

        @Override
        public String getQName(int index) {
            Node n = this.atts.item(index);
            if (this.namespaces != null) {
                String prefix;
                String uri = n.getNamespaceURI();
                String string = prefix = uri != null ? this.namespaces.getPrefix(uri) : null;
                if (prefix != null) {
                    return prefix + ":" + n.getLocalName();
                }
            }
            return n.getLocalName() != null ? n.getLocalName() : n.getNodeName();
        }

        @Override
        public String getType(int index) {
            return "CDATA";
        }

        @Override
        public String getURI(int index) {
            String ns = this.atts.item(index).getNamespaceURI();
            if (ns == null) {
                ns = XMLUtils.qName(this.getQName(index), this.namespaces).getNamespaceURI();
            }
            return this.emptyIfNull(ns);
        }

        @Override
        public String getValue(int index) {
            return this.atts.item(index).getNodeValue();
        }

        @Override
        public int getIndex(String qName) {
            String pre = null;
            String local = null;
            if (qName.lastIndexOf(58) != -1) {
                String[] split = qName.split(":");
                pre = split[0];
                local = split[1];
            } else {
                pre = "";
                local = qName;
            }
            for (int i = 0; i < this.atts.getLength(); ++i) {
                Node att = this.atts.item(i);
                if (!att.getLocalName().equals(local)) continue;
                String apre = att.getPrefix();
                if (apre == null) {
                    apre = "";
                }
                if (!pre.equals(apre)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String getType(String qName) {
            return this.getType(this.getIndex(qName));
        }

        @Override
        public String getValue(String qName) {
            return this.getValue(this.getIndex(qName));
        }

        @Override
        public int getIndex(String uri, String localName) {
            if (uri == null || uri.equals("")) {
                return this.getIndex(localName);
            }
            return this.getIndex(uri + ":" + localName);
        }

        @Override
        public String getType(String uri, String localName) {
            return this.getType(this.getIndex(uri, localName));
        }

        @Override
        public String getValue(String uri, String localName) {
            return this.getValue(this.getIndex(uri, localName));
        }

        boolean nullOrEmpty(String val) {
            return val == null || "".equals(val);
        }

        String emptyIfNull(String val) {
            return val != null ? val : "";
        }
    }

    private static class EncodingEntry {
        public Object object;
        public XSDElementDeclaration element;
        public Element encoding;
        public List<Object[]> children;
        public EncodingEntry parent;

        public EncodingEntry(Object object, XSDElementDeclaration element, EncodingEntry parent) {
            this.object = object;
            this.element = element;
            this.parent = parent;
            this.children = new ArrayList<Object[]>();
        }
    }

    private static class SingleIterator
    implements Iterator {
        Object object;
        boolean more;

        public SingleIterator(Object object) {
            this.object = object;
            this.more = true;
        }

        @Override
        public void remove() {
        }

        @Override
        public boolean hasNext() {
            return this.more;
        }

        public Object next() {
            this.more = false;
            return this.object;
        }
    }

    private static class NullIterator
    implements Iterator {
        private NullIterator() {
        }

        @Override
        public void remove() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }
    }
}

