/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.FeatureWriterIterator;
import org.geotools.data.store.NoContentIterator;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureReaderIterator;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public abstract class DataFeatureCollection
implements SimpleFeatureCollection {
    static Logger LOGGER = Logging.getLogger(DataFeatureCollection.class);
    private static int unique = 0;
    private final Set<Object> open = new HashSet<Object>();
    protected List<CollectionListener> listeners = new ArrayList<CollectionListener>();
    protected String id;
    protected SimpleFeatureType schema;

    protected DataFeatureCollection() {
        this("features" + unique++);
    }

    protected DataFeatureCollection(String id) {
        this(id, null);
    }

    protected DataFeatureCollection(String id, SimpleFeatureType memberType) {
        this.id = id == null ? "featureCollection" : id;
        this.schema = memberType;
    }

    protected void fireChange(SimpleFeature[] features, int type) {
        CollectionEvent cEvent = new CollectionEvent(this, features, type);
        for (CollectionListener listener : this.listeners) {
            listener.collectionChanged(cEvent);
        }
    }

    protected void fireChange(SimpleFeature feature, int type) {
        this.fireChange(new SimpleFeature[]{feature}, type);
    }

    protected void fireChange(Collection coll, int type) {
        SimpleFeature[] features = coll.toArray(new SimpleFeature[coll.size()]);
        this.fireChange(features, type);
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        return new DelegateFeatureReader<SimpleFeatureType, SimpleFeature>(this.getSchema(), this.features());
    }

    @Override
    public abstract ReferencedEnvelope getBounds();

    public abstract int getCount() throws IOException;

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> writer() throws IOException {
        return null;
    }

    @Override
    public SimpleFeatureIterator features() {
        DelegateSimpleFeatureIterator iterator = new DelegateSimpleFeatureIterator(this.iterator());
        this.open.add(iterator);
        return iterator;
    }

    public final Iterator<SimpleFeature> iterator() {
        Iterator<SimpleFeature> iterator;
        try {
            iterator = this.openIterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.open.add(iterator);
        return iterator;
    }

    protected Iterator<SimpleFeature> openIterator() throws IOException {
        try {
            FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.writer();
            if (writer != null) {
                return new FeatureWriterIterator(this.writer());
            }
        }
        catch (IOException badWriter) {
            return new NoContentIterator(badWriter);
        }
        catch (UnsupportedOperationException badWriter) {
            // empty catch block
        }
        try {
            return new FeatureReaderIterator<SimpleFeature>(this.reader());
        }
        catch (IOException e) {
            return new NoContentIterator(e);
        }
    }

    public final void close(Iterator<SimpleFeature> close) {
        try {
            this.closeIterator(close);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error closing iterator", e);
        }
        this.open.remove(close);
    }

    protected void closeIterator(Iterator<SimpleFeature> close) throws IOException {
        if (close instanceof FeatureReaderIterator) {
            FeatureReaderIterator iterator = (FeatureReaderIterator)close;
            iterator.close();
        } else if (close instanceof FeatureWriterIterator) {
            FeatureWriterIterator iterator = (FeatureWriterIterator)close;
            iterator.close();
        }
    }

    public void close(FeatureIterator<SimpleFeature> iterator) {
        iterator.close();
        this.open.remove(iterator);
    }

    @Override
    public int size() {
        try {
            return this.getCount();
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "IOException while calculating size() of FeatureCollection", e);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Iterator<Object> i = this.open.iterator();
        while (i.hasNext()) {
            Object iterator = i.next();
            try {
                if (iterator instanceof Iterator) {
                    Iterator cast = (Iterator)iterator;
                    this.closeIterator(cast);
                }
                if (!(iterator instanceof FeatureIterator)) continue;
                ((SimpleFeatureIterator)iterator).close();
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                i.remove();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isEmpty() {
        try {
            Throwable throwable = null;
            try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.reader();){
                boolean bl = !reader.hasNext();
                return bl;
            }
            catch (IOException e) {
                boolean bl3 = true;
                return bl3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (IOException e2) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(Object o) {
        if (!(o instanceof SimpleFeature)) {
            return false;
        }
        SimpleFeature value = (SimpleFeature)o;
        String ID2 = value.getID();
        try {
            Throwable throwable = null;
            try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.reader();){
                while (reader.hasNext()) {
                    SimpleFeature feature = reader.next();
                    if (!ID2.equals(feature.getID()) || !value.equals(feature)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean feature = false;
                return feature;
            }
            catch (IOException | NoSuchElementException | IllegalAttributeException e) {
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArray((T[])new SimpleFeature[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] array) {
        ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>();
        Iterator<SimpleFeature> i = this.iterator();
        try {
            while (i.hasNext()) {
                SimpleFeature next = i.next();
                list.add(next);
            }
        }
        finally {
            this.close(i);
        }
        return list.toArray(array);
    }

    public boolean add(SimpleFeature arg0) {
        return false;
    }

    public boolean remove(Object arg0) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object o : collection) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addAll(Collection collection) {
        if (collection instanceof FeatureCollection) {
            return this.addAll((FeatureCollection)((Object)collection));
        }
        try (FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.writer();){
            if (writer == null) {
                boolean bl2 = false;
                return bl2;
            }
            while (writer.hasNext()) {
                writer.next();
            }
            for (Object obj : collection) {
                if (!(obj instanceof SimpleFeature)) continue;
                SimpleFeature copy = (SimpleFeature)obj;
                SimpleFeature feature = writer.next();
                feature.setAttributes(copy.getAttributes());
                writer.write();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public boolean addAll(FeatureCollection resource) {
        return false;
    }

    public boolean removeAll(Collection arg0) {
        return false;
    }

    public boolean retainAll(Collection arg0) {
        return false;
    }

    public void clear() {
    }

    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        DataUtilities.visit(this, visitor, progress);
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        return new SubFeatureCollection(this, filter);
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        return null;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public final void addListener(CollectionListener listener) throws NullPointerException {
        this.listeners.add(listener);
    }

    public final void removeListener(CollectionListener listener) throws NullPointerException {
        this.listeners.remove(listener);
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.schema;
    }
}

