/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.iterators;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RandomIter;

public class RandomIterFallbackIntNoCache
implements RandomIter {
    protected RenderedImage im;
    protected Rectangle boundsRect;
    protected SampleModel sampleModel;
    protected int boundsX;
    protected int boundsY;
    private int[] xTiles;
    private int[] yTiles;

    public RandomIterFallbackIntNoCache(RenderedImage im, Rectangle bounds) {
        this.im = im;
        Rectangle imBounds = new Rectangle(im.getMinX(), im.getMinY(), im.getWidth(), im.getHeight());
        this.boundsRect = imBounds.intersection(bounds);
        this.sampleModel = im.getSampleModel();
        this.boundsX = this.boundsRect.x;
        this.boundsY = this.boundsRect.y;
        int width = this.boundsRect.width;
        int height = this.boundsRect.height;
        this.xTiles = new int[width];
        this.yTiles = new int[height];
        int tileWidth = im.getTileWidth();
        int tileGridXOffset = im.getTileGridXOffset();
        int minTileX = PlanarImage.XToTileX(this.boundsX, tileGridXOffset, tileWidth);
        int offsetX = this.boundsX - PlanarImage.tileXToX(minTileX, tileGridXOffset, tileWidth);
        int tileX = minTileX;
        for (int i = 0; i < width; ++i) {
            this.xTiles[i] = tileX++;
            if (++offsetX != tileWidth) continue;
            offsetX = 0;
        }
        int tileHeight = im.getTileHeight();
        int tileGridYOffset = im.getTileGridYOffset();
        int minTileY = PlanarImage.YToTileY(this.boundsY, tileGridYOffset, tileHeight);
        int offsetY = this.boundsY - PlanarImage.tileYToY(minTileY, tileGridYOffset, tileHeight);
        int tileY = minTileY;
        for (int i = 0; i < height; ++i) {
            this.yTiles[i] = tileY++;
            if (++offsetY != tileHeight) continue;
            offsetY = 0;
        }
    }

    private Raster makeCurrent(int xLocal, int yLocal) {
        int tileX = this.xTiles[xLocal];
        int tileY = this.yTiles[yLocal];
        return this.im.getTile(tileX, tileY);
    }

    @Override
    public int getSample(int x, int y, int b) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getSample(x - sampleModelTranslateX, y - sampleModelTranslateY, b, tile.getDataBuffer());
    }

    @Override
    public float getSampleFloat(int x, int y, int b) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getSampleFloat(x - sampleModelTranslateX, y - sampleModelTranslateY, b, tile.getDataBuffer());
    }

    @Override
    public double getSampleDouble(int x, int y, int b) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getSampleDouble(x - sampleModelTranslateX, y - sampleModelTranslateY, b, tile.getDataBuffer());
    }

    @Override
    public int[] getPixel(int x, int y, int[] iArray) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getPixel(x - sampleModelTranslateX, y - sampleModelTranslateY, iArray, tile.getDataBuffer());
    }

    @Override
    public float[] getPixel(int x, int y, float[] fArray) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getPixel(x - sampleModelTranslateX, y - sampleModelTranslateY, fArray, tile.getDataBuffer());
    }

    @Override
    public double[] getPixel(int x, int y, double[] dArray) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getPixel(x - sampleModelTranslateX, y - sampleModelTranslateY, dArray, tile.getDataBuffer());
    }

    @Override
    public void done() {
        this.xTiles = null;
        this.yTiles = null;
    }
}

