/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic.geopackage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.geopkg.GeoPkgDataStoreFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoCrsException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoMathTransformException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeographicReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeotoolsConverter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.geopackage.GeoPackageHandler;

public final class GeoPackageReader
extends GeographicReader {
    public static DataSet parseDataSet(InputStream in, File file, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException {
        if (in != null) {
            in.close();
        }
        return new GeoPackageReader(handler != null ? handler.getGeoPackageHandler() : null).parse(file, instance);
    }

    private GeoPackageReader(GeoPackageHandler handler) {
        super(handler, new GeoPackageHandler[0]);
    }

    private DataSet parse(File file, ProgressMonitor instance) throws IOException {
        if (file != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(GeoPkgDataStoreFactory.DATABASE.key, file);
            params.put(GeoPkgDataStoreFactory.READ_ONLY.key, true);
            params.put(GeoPkgDataStoreFactory.DBTYPE.key, (String)GeoPkgDataStoreFactory.DBTYPE.sample);
            DataStore dataStore = DataStoreFinder.getDataStore(params);
            try {
                new GeotoolsConverter(this, dataStore).convert(instance);
            }
            catch (FactoryException | TransformException | GeoCrsException | GeoMathTransformException e) {
                throw new IOException(e);
            }
        }
        return this.ds;
    }
}

