/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.LinkedIndex;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableLinkConnection;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.DataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableLink
extends Table {
    private static final long ROW_COUNT_APPROXIMATION = 100000L;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String originalSchema;
    private String originalTable;
    private String qualifiedTableName;
    private TableLinkConnection conn;
    private HashMap<String, PreparedStatement> prepared = New.hashMap();
    private final ObjectArray<Index> indexes = ObjectArray.newInstance();
    private final boolean emitUpdates;
    private LinkedIndex linkedIndex;
    private SQLException connectException;
    private boolean storesLowerCase;
    private boolean storesMixedCase;
    private boolean supportsMixedCaseIdentifiers;
    private boolean globalTemporary;
    private boolean readOnly;

    public TableLink(Schema schema, int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, boolean bl2) throws SQLException {
        super(schema, n, string, false, true);
        this.driver = string2;
        this.url = string3;
        this.user = string4;
        this.password = string5;
        this.originalSchema = string6;
        this.originalTable = string7;
        this.emitUpdates = bl;
        try {
            this.connect();
        }
        catch (SQLException sQLException) {
            this.connectException = sQLException;
            if (!bl2) {
                throw sQLException;
            }
            Column[] columnArray = new Column[]{};
            this.setColumns(columnArray);
            this.linkedIndex = new LinkedIndex(this, n, IndexColumn.wrap(columnArray), IndexType.createNonUnique(false));
            this.indexes.add(this.linkedIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws SQLException {
        TableLinkConnection tableLinkConnection = this.conn = this.database.getLinkConnection(this.driver, this.url, this.user, this.password);
        synchronized (tableLinkConnection) {
            try {
                this.readMetaData();
            }
            catch (SQLException sQLException) {
                this.conn.close();
                this.conn = null;
                throw sQLException;
            }
        }
    }

    private void readMetaData() throws SQLException {
        Object object;
        int n;
        int n2;
        int n3;
        long l;
        int n4;
        String string;
        Object[] objectArray;
        Object object2;
        DatabaseMetaData databaseMetaData = this.conn.getConnection().getMetaData();
        this.storesLowerCase = databaseMetaData.storesLowerCaseIdentifiers();
        this.storesMixedCase = databaseMetaData.storesMixedCaseIdentifiers();
        this.supportsMixedCaseIdentifiers = databaseMetaData.supportsMixedCaseIdentifiers();
        ResultSet resultSet = databaseMetaData.getTables(null, this.originalSchema, this.originalTable, null);
        if (resultSet.next() && resultSet.next()) {
            throw Message.getSQLException(90080, this.originalTable);
        }
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, this.originalSchema, this.originalTable, null);
        int n5 = 0;
        ObjectArray<Column> objectArray2 = ObjectArray.newInstance();
        HashMap<String, Column> hashMap = New.hashMap();
        String string2 = null;
        String string3 = null;
        while (resultSet.next()) {
            object2 = resultSet.getString("TABLE_CAT");
            if (string2 == null) {
                string2 = object2;
            }
            objectArray = resultSet.getString("TABLE_SCHEM");
            if (string3 == null) {
                string3 = objectArray;
            }
            if (!StringUtils.equals(string2, (String)object2) || !StringUtils.equals(string3, (String)objectArray)) {
                hashMap.clear();
                objectArray2.clear();
                break;
            }
            string = resultSet.getString("COLUMN_NAME");
            string = this.convertColumnName(string);
            n4 = resultSet.getInt("DATA_TYPE");
            l = resultSet.getInt("COLUMN_SIZE");
            l = this.convertPrecision(n4, l);
            n3 = resultSet.getInt("DECIMAL_DIGITS");
            n2 = MathUtils.convertLongToInt(l);
            n = DataType.convertSQLTypeToValueType(n4);
            object = new Column(string, n, l, n3, n2);
            ((Column)object).setTable(this, n5++);
            objectArray2.add((Column)object);
            hashMap.put(string, (Column)object);
        }
        resultSet.close();
        this.qualifiedTableName = this.originalTable.indexOf(46) < 0 && !StringUtils.isNullOrEmpty(string3) ? string3 + "." + this.originalTable : this.originalTable;
        object2 = null;
        try {
            object2 = this.conn.getConnection().createStatement();
            resultSet = object2.executeQuery("SELECT * FROM " + this.qualifiedTableName + " T WHERE 1=0");
            if (objectArray2.size() == 0) {
                objectArray = resultSet.getMetaData();
                n5 = 0;
                while (n5 < objectArray.getColumnCount()) {
                    string = objectArray.getColumnName(n5 + 1);
                    string = this.convertColumnName(string);
                    n4 = objectArray.getColumnType(n5 + 1);
                    l = objectArray.getPrecision(n5 + 1);
                    l = this.convertPrecision(n4, l);
                    n3 = objectArray.getScale(n5 + 1);
                    n2 = objectArray.getColumnDisplaySize(n5 + 1);
                    n = DataType.convertSQLTypeToValueType(n4);
                    object = new Column(string, n, l, n3, n2);
                    ((Column)object).setTable(this, n5++);
                    objectArray2.add((Column)object);
                    hashMap.put(string, (Column)object);
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw Message.getSQLException(42102, sQLException, this.originalTable + "(" + sQLException.toString() + ")");
        }
        finally {
            JdbcUtils.closeSilently((Statement)object2);
        }
        objectArray = new Column[objectArray2.size()];
        objectArray2.toArray(objectArray);
        this.setColumns((Column[])objectArray);
        int n6 = this.getId();
        this.linkedIndex = new LinkedIndex(this, n6, IndexColumn.wrap((Column[])objectArray), IndexType.createNonUnique(false));
        this.indexes.add(this.linkedIndex);
        try {
            resultSet = databaseMetaData.getPrimaryKeys(null, this.originalSchema, this.originalTable);
        }
        catch (SQLException sQLException) {
            resultSet = null;
        }
        String string4 = "";
        if (resultSet != null && resultSet.next()) {
            ObjectArray<Column> objectArray3 = ObjectArray.newInstance();
            do {
                int n7 = resultSet.getInt("KEY_SEQ");
                if (string4 == null) {
                    string4 = resultSet.getString("PK_NAME");
                }
                while (objectArray3.size() < n7) {
                    objectArray3.add(null);
                }
                String string5 = resultSet.getString("COLUMN_NAME");
                string5 = this.convertColumnName(string5);
                Column column = (Column)hashMap.get(string5);
                if (n7 == 0) {
                    objectArray3.add(column);
                    continue;
                }
                objectArray3.set(n7 - 1, column);
            } while (resultSet.next());
            this.addIndex(objectArray3, IndexType.createPrimaryKey(false, false));
            resultSet.close();
        }
        try {
            resultSet = databaseMetaData.getIndexInfo(null, this.originalSchema, this.originalTable, false, true);
        }
        catch (SQLException sQLException) {
            resultSet = null;
        }
        String string6 = null;
        ObjectArray<Column> objectArray4 = ObjectArray.newInstance();
        IndexType indexType = null;
        if (resultSet != null) {
            while (resultSet.next()) {
                String string7;
                if (resultSet.getShort("TYPE") == 0 || string4.equals(string7 = resultSet.getString("INDEX_NAME"))) continue;
                if (string6 != null && !string6.equals(string7)) {
                    this.addIndex(objectArray4, indexType);
                    string6 = null;
                }
                if (string6 == null) {
                    string6 = string7;
                    objectArray4.clear();
                }
                n = !resultSet.getBoolean("NON_UNIQUE") ? 1 : 0;
                indexType = n != 0 ? IndexType.createUnique(false, false) : IndexType.createNonUnique(false);
                object = resultSet.getString("COLUMN_NAME");
                object = this.convertColumnName((String)object);
                Column column = (Column)hashMap.get(object);
                objectArray4.add(column);
            }
            resultSet.close();
        }
        if (string6 != null) {
            this.addIndex(objectArray4, indexType);
        }
    }

    private long convertPrecision(int n, long l) {
        switch (n) {
            case 91: {
                l = Math.max(8L, l);
                break;
            }
            case 93: {
                l = Math.max(23L, l);
                break;
            }
            case 92: {
                l = Math.max(6L, l);
            }
        }
        return l;
    }

    private String convertColumnName(String string) {
        if ((this.storesMixedCase || this.storesLowerCase) && string.equals(StringUtils.toLowerEnglish(string))) {
            string = StringUtils.toUpperEnglish(string);
        } else if (this.storesMixedCase && !this.supportsMixedCaseIdentifiers) {
            string = StringUtils.toUpperEnglish(string);
        }
        return string;
    }

    private void addIndex(ObjectArray<Column> objectArray, IndexType indexType) {
        Object[] objectArray2 = new Column[objectArray.size()];
        objectArray.toArray(objectArray2);
        LinkedIndex linkedIndex = new LinkedIndex(this, 0, IndexColumn.wrap((Column[])objectArray2), indexType);
        this.indexes.add(linkedIndex);
    }

    @Override
    public String getDropSQL() {
        return "DROP TABLE IF EXISTS " + this.getSQL();
    }

    @Override
    public String getCreateSQL() {
        StringBuilder stringBuilder = new StringBuilder("CREATE FORCE ");
        if (this.isTemporary()) {
            if (this.globalTemporary) {
                stringBuilder.append("GLOBAL ");
            } else {
                stringBuilder.append("LOCAL ");
            }
            stringBuilder.append("TEMPORARY ");
        }
        stringBuilder.append("LINKED TABLE ").append(this.getSQL());
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuilder.append('(').append(StringUtils.quoteStringSQL(this.driver)).append(", ").append(StringUtils.quoteStringSQL(this.url)).append(", ").append(StringUtils.quoteStringSQL(this.user)).append(", ").append(StringUtils.quoteStringSQL(this.password)).append(", ").append(StringUtils.quoteStringSQL(this.originalTable)).append(')');
        if (this.emitUpdates) {
            stringBuilder.append(" EMIT UPDATES");
        }
        if (this.readOnly) {
            stringBuilder.append(" READONLY");
        }
        return stringBuilder.toString();
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2, String string2) throws SQLException {
        throw Message.getUnsupportedException("LINK");
    }

    @Override
    public void lock(Session session, boolean bl, boolean bl2) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.linkedIndex;
    }

    private void checkReadOnly() throws SQLException {
        if (this.readOnly) {
            throw Message.getSQLException(90097);
        }
    }

    @Override
    public void removeRow(Session session, Row row) throws SQLException {
        this.checkReadOnly();
        this.getScanIndex(session).remove(session, row);
    }

    @Override
    public void addRow(Session session, Row row) throws SQLException {
        this.checkReadOnly();
        this.getScanIndex(session).add(session, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Session session) throws SQLException {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            finally {
                this.conn = null;
            }
        }
    }

    @Override
    public synchronized long getRowCount(Session session) throws SQLException {
        String string = "SELECT COUNT(*) FROM " + this.qualifiedTableName;
        try {
            PreparedStatement preparedStatement = this.getPreparedStatement(string, false);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            long l = resultSet.getLong(1);
            resultSet.close();
            return l;
        }
        catch (SQLException sQLException) {
            throw this.wrapException(string, sQLException);
        }
    }

    public SQLException wrapException(String string, SQLException sQLException) {
        return Message.getSQLException(90111, sQLException, string, sQLException.toString());
    }

    public String getQualifiedTable() {
        return this.qualifiedTableName;
    }

    public PreparedStatement getPreparedStatement(String string, boolean bl) throws SQLException {
        Trace trace = this.database.getTrace("table");
        if (trace.isDebugEnabled()) {
            trace.debug(this.getName() + ":\n" + string);
        }
        if (this.conn == null) {
            throw this.connectException;
        }
        PreparedStatement preparedStatement = this.prepared.get(string);
        if (preparedStatement == null) {
            preparedStatement = this.conn.getConnection().prepareStatement(string);
            this.prepared.put(string, preparedStatement);
        }
        if (bl) {
            this.prepared.remove(string);
        }
        return preparedStatement;
    }

    @Override
    public void unlock(Session session) {
    }

    @Override
    public void checkRename() {
    }

    @Override
    public void checkSupportAlter() throws SQLException {
        throw Message.getUnsupportedException("LINK");
    }

    @Override
    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException("LINK");
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public String getTableType() {
        return "TABLE LINK";
    }

    @Override
    public void removeChildrenAndResources(Session session) throws SQLException {
        super.removeChildrenAndResources(session);
        this.close(session);
        this.database.removeMeta(session, this.getId());
        this.driver = null;
        this.originalTable = null;
        this.password = null;
        this.user = null;
        this.url = null;
        this.prepared = null;
        this.invalidate();
    }

    public boolean isOracle() {
        return this.url.startsWith("jdbc:oracle:");
    }

    @Override
    public ObjectArray<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    @Override
    public Index getUniqueIndex() {
        for (Index index : this.indexes) {
            if (!index.getIndexType().isUnique()) continue;
            return index;
        }
        return null;
    }

    @Override
    public void updateRows(Prepared prepared, Session session, RowList rowList) throws SQLException {
        boolean bl;
        this.checkReadOnly();
        if (this.emitUpdates) {
            rowList.reset();
            while (rowList.hasNext()) {
                prepared.checkCanceled();
                Row row = rowList.next();
                Row row2 = rowList.next();
                this.linkedIndex.update(row, row2);
                session.log(this, (short)1, row);
                session.log(this, (short)0, row2);
            }
            bl = false;
        } else {
            bl = true;
        }
        if (bl) {
            super.updateRows(prepared, session, rowList);
        }
    }

    public void setGlobalTemporary(boolean bl) {
        this.globalTemporary = bl;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public TableLinkConnection getConnection() {
        return this.conn;
    }

    @Override
    public long getRowCountApproximation() {
        return 100000L;
    }

    public void reusePreparedStatement(PreparedStatement preparedStatement, String string) {
        this.prepared.put(string, preparedStatement);
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }
}

