/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.FilteringFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.SortedSimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.geometry.BoundingBox;
import org.opengis.util.ProgressListener;

public abstract class BaseFeatureCollection<T extends FeatureType, F extends Feature>
implements FeatureCollection<T, F> {
    protected String id;
    protected T schema;

    protected BaseFeatureCollection() {
        this(null, null);
    }

    protected BaseFeatureCollection(T schema) {
        this(schema, null);
    }

    protected BaseFeatureCollection(T schema, String id) {
        this.id = id == null ? "featureCollection" : id;
        this.schema = schema;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public T getSchema() {
        return this.schema;
    }

    @Override
    public abstract FeatureIterator<F> features();

    @Override
    public boolean contains(Object o) {
        try (FeatureIterator<F> e = this.features();){
            if (o == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                while (e.hasNext()) {
                    if (!o.equals(e.next())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        try (FeatureIterator<F> e = this.features();){
            while (e.hasNext()) {
                F feature = e.next();
                if (c.contains(feature)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean isEmpty() {
        try (FeatureIterator<F> iterator = this.features();){
            boolean bl = !iterator.hasNext();
            return bl;
        }
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        try (FeatureIterator<F> e = this.features();){
            int i = 0;
            while (e.hasNext()) {
                result[i] = e.next();
                ++i;
            }
            Object[] objectArray = result;
            return objectArray;
        }
    }

    @Override
    public <O> O[] toArray(O[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        try (FeatureIterator<F> it = this.features();){
            O[] result = a;
            for (int i = 0; i < size; ++i) {
                result[i] = it.next();
            }
            if (a.length > size) {
                a[size] = null;
            }
            Object[] objectArray = a;
            return objectArray;
        }
    }

    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        DataUtilities.visit(this, visitor, progress);
    }

    @Override
    public FeatureCollection<T, F> subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        return new FilteringFeatureCollection(this, filter);
    }

    @Override
    public FeatureCollection<T, F> sort(SortBy order) {
        if (this.getSchema() instanceof SimpleFeatureType) {
            SimpleFeatureCollection simple = DataUtilities.simple(this);
            return new SortedSimpleFeatureCollection(simple, order);
        }
        throw new UnsupportedOperationException("Cannot sort on complex features at the moment");
    }

    @Override
    public int size() {
        int count = 0;
        try (FeatureIterator<F> it = this.features();){
            while (it.hasNext()) {
                F feature = it.next();
                ++count;
            }
        }
        return count;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        ReferencedEnvelope bounds = null;
        try (FeatureIterator<F> it = this.features();){
            while (it.hasNext()) {
                F feature = it.next();
                BoundingBox bbox = feature.getBounds();
                if (bbox == null) continue;
                if (bounds == null) {
                    bounds = new ReferencedEnvelope(bbox);
                    continue;
                }
                bounds.include(bbox);
            }
        }
        return bounds;
    }
}

