/*
 * Decompiled with CFR 0.152.
 */
package indoor_sweepline;

import indoor_sweepline.CorridorPart;
import indoor_sweepline.IndoorSweeplineController;
import indoor_sweepline.IndoorSweeplineModel;
import indoor_sweepline.Strip;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class IndoorSweeplineWizardDialog
extends JDialog {
    private IndoorSweeplineController controller;
    private int beamIndex;
    private int leftRightCount;
    private PrevAction prev;
    private NextAction next;
    boolean inRefresh;
    private DefaultComboBoxModel<String> typeBoxModel;
    private JLabel widthOffsetLabel;
    private JTextField stripWidth;
    private JTextField level;
    private StructureTableModel structureTableModel;

    public IndoorSweeplineWizardDialog(IndoorSweeplineController controller) {
        super(JOptionPane.getFrameForComponent((Component)MainApplication.getMainFrame()), "Indoor Sweepline Wizard", false);
        this.controller = controller;
        this.beamIndex = 0;
        this.prev = new PrevAction();
        this.next = new NextAction();
        GridbagPanel panel = new GridbagPanel();
        panel.add(new JLabel(I18n.tr((String)"Vertical layer:", (Object[])new Object[0])), 0, 0, 3, 1);
        panel.add(this.makeLevelField(), 3, 0, 1, 1);
        panel.add(new JLabel(I18n.tr((String)"Structure type:", (Object[])new Object[0])), 0, 1, 3, 1);
        panel.add(this.typeBox(), 3, 1, 1, 1);
        panel.add(new JButton(this.prev), 0, 2, 1, 1);
        panel.add(this.structureBox(), 1, 2, 1, 1);
        panel.add(new JButton(this.next), 2, 2, 2, 1);
        panel.add(this.makeWidthLabel(), 0, 3, 3, 1);
        panel.add(this.makeWidthField(), 3, 3, 1, 1);
        panel.add(this.makeStructureTable(), 0, 4, 4, 1);
        this.add(panel);
        this.pack();
        this.refresh();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setLocationRelativeTo(JOptionPane.getFrameForComponent((Component)MainApplication.getMainFrame()));
        }
        super.setVisible(visible);
    }

    private void refresh() {
        this.inRefresh = true;
        this.leftRightCount = this.controller.leftRightCount();
        this.prev.setEnabled(this.beamIndex > 0);
        DefaultComboBoxModel<String> structureBoxModel = this.controller.structures();
        structureBoxModel.setSelectedItem(structureBoxModel.getElementAt(this.beamIndex));
        try {
            if (this.beamIndex % 2 == 0) {
                this.widthOffsetLabel.setText("Offset into background:");
                this.stripWidth.setText(Double.toString(this.controller.getBeamOffset(this.beamIndex)));
            } else {
                this.widthOffsetLabel.setText("Strip width:");
                this.stripWidth.setText(Double.toString(this.controller.getStripWidth(this.beamIndex)));
            }
        }
        catch (IllegalStateException ex) {
            Logging.trace((Throwable)ex);
        }
        try {
            this.level.setText(this.controller.getLevel());
        }
        catch (IllegalStateException ex) {
            Logging.trace((Throwable)ex);
        }
        this.typeBoxModel.setSelectedItem(this.structureTypeToString(this.controller.getType()));
        this.structureTableModel.setRowCount(0);
        if (this.beamIndex % 2 == 0) {
            Vector<String> row = new Vector<String>();
            row.addElement("");
            row.addElement("");
            row.addElement("");
            this.structureTableModel.addRow(row);
            List<CorridorPart> parts = this.controller.getBeamParts(this.beamIndex);
            for (CorridorPart part : parts) {
                row = new Vector();
                row.addElement(Double.toString(part.width));
                row.addElement(this.corridorPartTypeToString(part.getType()));
                row.addElement(this.corridorPartSideToString(part.getSide()));
                this.structureTableModel.addRow(row);
            }
            row = new Vector();
            row.addElement("");
            row.addElement("");
            row.addElement("");
            this.structureTableModel.addRow(row);
            this.structureTableModel.isBeam = true;
        } else {
            Strip strip = this.controller.getStrip(this.beamIndex);
            for (int i = 0; i < strip.lhs.size() || i < strip.rhs.size(); ++i) {
                Vector<String> row = new Vector<String>();
                String position = i < strip.lhs.size() ? strip.lhs.elementAt(i).toString() : "X";
                position = position + " - " + (i < strip.rhs.size() ? strip.rhs.elementAt(i).toString() : "X");
                row.addElement(position);
                row.addElement(i < strip.parts.size() ? this.corridorPartTypeToString(strip.parts.elementAt(i).getType()) : "wall");
                row.addElement(i < strip.parts.size() ? this.corridorPartSideToString(strip.parts.elementAt(i).getSide()) : "all");
                this.structureTableModel.addRow(row);
            }
            this.structureTableModel.isBeam = false;
        }
        this.inRefresh = false;
    }

    private String corridorPartTypeToString(CorridorPart.Type type) {
        if (type == CorridorPart.Type.VOID) {
            return "void";
        }
        if (type == CorridorPart.Type.PASSAGE) {
            return "passage";
        }
        if (type == CorridorPart.Type.WALL) {
            return "wall";
        }
        if (type == CorridorPart.Type.STAIRS_UP) {
            return "stairs to upper level";
        }
        if (type == CorridorPart.Type.STAIRS_DOWN) {
            return "stairs to lower level";
        }
        if (type == CorridorPart.Type.ESCALATOR_UP_LEAVING) {
            return "escalator leaving to upper level";
        }
        if (type == CorridorPart.Type.ESCALATOR_UP_ARRIVING) {
            return "escalator arriving from upper level";
        }
        if (type == CorridorPart.Type.ESCALATOR_UP_BIDIRECTIONAL) {
            return "escalator (reversible) to upper level";
        }
        if (type == CorridorPart.Type.ESCALATOR_DOWN_LEAVING) {
            return "escalator leaving to lower level";
        }
        if (type == CorridorPart.Type.ESCALATOR_DOWN_ARRIVING) {
            return "escalator arriving from lower level";
        }
        if (type == CorridorPart.Type.ESCALATOR_DOWN_BIDIRECTIONAL) {
            return "escalator (reversible) to lower level";
        }
        if (type == CorridorPart.Type.ELEVATOR) {
            return "elevator";
        }
        return "";
    }

    private CorridorPart.Type parseCorridorPartType(String val) {
        if (val == "void") {
            return CorridorPart.Type.VOID;
        }
        if (val == "passage") {
            return CorridorPart.Type.PASSAGE;
        }
        if (val == "wall") {
            return CorridorPart.Type.WALL;
        }
        if (val == "stairs to upper level") {
            return CorridorPart.Type.STAIRS_UP;
        }
        if (val == "stairs to lower level") {
            return CorridorPart.Type.STAIRS_DOWN;
        }
        if (val == "escalator leaving to upper level") {
            return CorridorPart.Type.ESCALATOR_UP_LEAVING;
        }
        if (val == "escalator arriving from upper level") {
            return CorridorPart.Type.ESCALATOR_UP_ARRIVING;
        }
        if (val == "escalator (reversible) to upper level") {
            return CorridorPart.Type.ESCALATOR_UP_BIDIRECTIONAL;
        }
        if (val == "escalator leaving to lower level") {
            return CorridorPart.Type.ESCALATOR_DOWN_LEAVING;
        }
        if (val == "escalator arriving from lower level") {
            return CorridorPart.Type.ESCALATOR_DOWN_ARRIVING;
        }
        if (val == "escalator (reversible) to lower level") {
            return CorridorPart.Type.ESCALATOR_DOWN_BIDIRECTIONAL;
        }
        if (val == "elevator") {
            return CorridorPart.Type.ELEVATOR;
        }
        return CorridorPart.Type.VOID;
    }

    private String corridorPartSideToString(CorridorPart.ReachableSide side) {
        if (side == CorridorPart.ReachableSide.ALL) {
            return "all";
        }
        if (side == CorridorPart.ReachableSide.FRONT) {
            return "front";
        }
        if (side == CorridorPart.ReachableSide.BACK) {
            return "back";
        }
        if (side == CorridorPart.ReachableSide.LEFT) {
            return "left";
        }
        if (side == CorridorPart.ReachableSide.RIGHT) {
            return "right";
        }
        return "";
    }

    private CorridorPart.ReachableSide parseCorridorPartSide(String val) {
        if (val == "all") {
            return CorridorPart.ReachableSide.ALL;
        }
        if (val == "front") {
            return CorridorPart.ReachableSide.FRONT;
        }
        if (val == "back") {
            return CorridorPart.ReachableSide.BACK;
        }
        if (val == "left") {
            return CorridorPart.ReachableSide.LEFT;
        }
        if (val == "right") {
            return CorridorPart.ReachableSide.RIGHT;
        }
        return CorridorPart.ReachableSide.ALL;
    }

    private String structureTypeToString(IndoorSweeplineModel.Type type) {
        if (type == IndoorSweeplineModel.Type.CORRIDOR) {
            return "corridor";
        }
        if (type == IndoorSweeplineModel.Type.PLATFORM) {
            return "platform";
        }
        return "";
    }

    private JComboBox<String> structureBox() {
        JComboBox<String> structureBox = new JComboBox<String>(this.controller.structures());
        structureBox.addActionListener(new StructureBoxListener());
        return structureBox;
    }

    private JComboBox<String> typeBox() {
        if (this.typeBoxModel == null) {
            this.typeBoxModel = new DefaultComboBoxModel();
            this.typeBoxModel.addElement("corridor");
            this.typeBoxModel.addElement("platform");
        }
        JComboBox<String> typeBox = new JComboBox<String>(this.typeBoxModel);
        typeBox.addActionListener(new TypeBoxListener());
        return typeBox;
    }

    private JLabel makeWidthLabel() {
        this.widthOffsetLabel = new JLabel(I18n.tr((String)"Offset into background:", (Object[])new Object[0]));
        return this.widthOffsetLabel;
    }

    private JTextField makeWidthField() {
        this.stripWidth = new JTextField(5);
        this.stripWidth.getDocument().addDocumentListener(new StripWidthListener());
        return this.stripWidth;
    }

    private JTextField makeLevelField() {
        this.level = new JTextField(5);
        this.level.getDocument().addDocumentListener(new LevelFieldListener());
        return this.level;
    }

    private JScrollPane makeStructureTable() {
        this.structureTableModel = new StructureTableModel();
        this.structureTableModel.addColumn("Width");
        this.structureTableModel.addColumn("Type");
        this.structureTableModel.addColumn("Reachable Side");
        this.structureTableModel.addTableModelListener(new StructureTableListener());
        JTable table = new JTable(this.structureTableModel);
        TableColumn column = table.getColumnModel().getColumn(1);
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("void");
        comboBox.addItem("passage");
        comboBox.addItem("wall");
        comboBox.addItem("stairs to upper level");
        comboBox.addItem("stairs to lower level");
        comboBox.addItem("escalator leaving to upper level");
        comboBox.addItem("escalator arriving from upper level");
        comboBox.addItem("escalator (reversible) to upper level");
        comboBox.addItem("escalator leaving to lower level");
        comboBox.addItem("escalator arriving from lower level");
        comboBox.addItem("escalator (reversible) to lower level");
        comboBox.addItem("elevator");
        column.setCellEditor(new DefaultCellEditor(comboBox));
        column = table.getColumnModel().getColumn(2);
        comboBox = new JComboBox();
        comboBox.addItem("all");
        comboBox.addItem("left");
        comboBox.addItem("right");
        column.setCellEditor(new DefaultCellEditor(comboBox));
        return new JScrollPane(table);
    }

    private static class GridbagPanel
    extends JPanel {
        private GridBagLayout gridbag = new GridBagLayout();
        private GridBagConstraints layoutCons = new GridBagConstraints();

        GridbagPanel() {
            this.setLayout(this.gridbag);
        }

        public void add(Component comp, int gridx, int gridy, int gridwidth, int gridheight) {
            this.layoutCons.gridx = gridx;
            this.layoutCons.gridy = gridy;
            this.layoutCons.gridwidth = gridwidth;
            this.layoutCons.gridheight = gridheight;
            this.layoutCons.weightx = 0.0;
            this.layoutCons.weighty = 0.0;
            this.layoutCons.fill = 1;
            this.gridbag.setConstraints(comp, this.layoutCons);
            this.add(comp);
        }
    }

    private class StructureTableListener
    implements TableModelListener {
        private StructureTableListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            block12: {
                if (IndoorSweeplineWizardDialog.this.inRefresh) {
                    return;
                }
                int column = e.getColumn();
                int row = e.getFirstRow();
                if (column == 0 && IndoorSweeplineWizardDialog.this.beamIndex % 2 == 0) {
                    try {
                        if (row == 0 || row == IndoorSweeplineWizardDialog.this.structureTableModel.getRowCount() - 1) {
                            IndoorSweeplineWizardDialog.this.controller.addCorridorPart(IndoorSweeplineWizardDialog.this.beamIndex, row != 0, Double.parseDouble(((TableModel)e.getSource()).getValueAt(row, column).toString()));
                            break block12;
                        }
                        IndoorSweeplineWizardDialog.this.controller.setCorridorPartWidth(IndoorSweeplineWizardDialog.this.beamIndex, row - 1, Double.parseDouble(((TableModel)e.getSource()).getValueAt(row, column).toString()));
                    }
                    catch (NumberFormatException ex) {
                        Logging.trace((Throwable)ex);
                    }
                } else if (column == 1 && IndoorSweeplineWizardDialog.this.beamIndex % 2 == 0) {
                    if (row > 0 && row < IndoorSweeplineWizardDialog.this.structureTableModel.getRowCount() - 1) {
                        IndoorSweeplineWizardDialog.this.controller.setCorridorPartType(IndoorSweeplineWizardDialog.this.beamIndex, row - 1, IndoorSweeplineWizardDialog.this.parseCorridorPartType(((TableModel)e.getSource()).getValueAt(row, column).toString()));
                    }
                } else if (column == 1 && IndoorSweeplineWizardDialog.this.beamIndex % 2 == 1) {
                    IndoorSweeplineWizardDialog.this.controller.setCorridorPartType(IndoorSweeplineWizardDialog.this.beamIndex, row, IndoorSweeplineWizardDialog.this.parseCorridorPartType(((TableModel)e.getSource()).getValueAt(row, column).toString()));
                } else if (column == 2 && IndoorSweeplineWizardDialog.this.beamIndex % 2 == 0 && row > 0 && row < IndoorSweeplineWizardDialog.this.structureTableModel.getRowCount() - 1) {
                    IndoorSweeplineWizardDialog.this.controller.setCorridorPartSide(IndoorSweeplineWizardDialog.this.beamIndex, row - 1, IndoorSweeplineWizardDialog.this.parseCorridorPartSide(((TableModel)e.getSource()).getValueAt(row, column).toString()));
                }
            }
            IndoorSweeplineWizardDialog.this.refresh();
        }
    }

    private static class StructureTableModel
    extends DefaultTableModel {
        public boolean isBeam;

        private StructureTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return this.isBeam || column == 1;
        }
    }

    private class LevelFieldListener
    implements DocumentListener {
        private LevelFieldListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            if (IndoorSweeplineWizardDialog.this.inRefresh) {
                return;
            }
            IndoorSweeplineWizardDialog.this.controller.setLevel(IndoorSweeplineWizardDialog.this.level.getText());
            IndoorSweeplineWizardDialog.this.refresh();
        }
    }

    private class StripWidthListener
    implements DocumentListener {
        private StripWidthListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            if (IndoorSweeplineWizardDialog.this.inRefresh) {
                return;
            }
            try {
                if (IndoorSweeplineWizardDialog.this.beamIndex % 2 == 0) {
                    IndoorSweeplineWizardDialog.this.controller.setBeamOffset(IndoorSweeplineWizardDialog.this.beamIndex, Double.parseDouble(IndoorSweeplineWizardDialog.this.stripWidth.getText()));
                } else {
                    IndoorSweeplineWizardDialog.this.controller.setStripWidth(IndoorSweeplineWizardDialog.this.beamIndex, Double.parseDouble(IndoorSweeplineWizardDialog.this.stripWidth.getText()));
                }
            }
            catch (NumberFormatException ex) {
                Logging.trace((Throwable)ex);
            }
            IndoorSweeplineWizardDialog.this.refresh();
        }
    }

    private class StructureBoxListener
    implements ActionListener {
        private StructureBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IndoorSweeplineWizardDialog.this.inRefresh) {
                return;
            }
            String entry = (String)((JComboBox)e.getSource()).getSelectedItem();
            DefaultComboBoxModel<String> structureBoxModel = IndoorSweeplineWizardDialog.this.controller.structures();
            for (int i = 0; i < structureBoxModel.getSize(); ++i) {
                if (!structureBoxModel.getElementAt(i).equals(entry)) continue;
                IndoorSweeplineWizardDialog.this.beamIndex = i;
            }
            IndoorSweeplineWizardDialog.this.refresh();
        }
    }

    private class NextAction
    extends AbstractAction {
        NextAction() {
            super("Next");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IndoorSweeplineWizardDialog.this.inRefresh) {
                return;
            }
            ++IndoorSweeplineWizardDialog.this.beamIndex;
            if (IndoorSweeplineWizardDialog.this.beamIndex >= IndoorSweeplineWizardDialog.this.leftRightCount) {
                IndoorSweeplineWizardDialog.this.controller.addRightStructure();
            }
            IndoorSweeplineWizardDialog.this.refresh();
        }
    }

    private class PrevAction
    extends AbstractAction {
        PrevAction() {
            super("Prev");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IndoorSweeplineWizardDialog.this.inRefresh) {
                return;
            }
            if (IndoorSweeplineWizardDialog.this.beamIndex > 0) {
                --IndoorSweeplineWizardDialog.this.beamIndex;
            }
            IndoorSweeplineWizardDialog.this.refresh();
        }
    }

    private class TypeBoxListener
    implements ActionListener {
        private TypeBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IndoorSweeplineWizardDialog.this.inRefresh) {
                return;
            }
            String entry = (String)((JComboBox)e.getSource()).getSelectedItem();
            if (entry == "corridor") {
                IndoorSweeplineWizardDialog.this.controller.setType(IndoorSweeplineModel.Type.CORRIDOR);
            } else {
                IndoorSweeplineWizardDialog.this.controller.setType(IndoorSweeplineModel.Type.PLATFORM);
            }
            IndoorSweeplineWizardDialog.this.refresh();
        }
    }
}

