/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.public_transport.commands;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.public_transport.TransText;
import org.openstreetmap.josm.plugins.public_transport.actions.StopImporterAction;
import org.openstreetmap.josm.plugins.public_transport.dialogs.StopImporterDialog;
import org.openstreetmap.josm.plugins.public_transport.models.TrackStoplistTableModel;
import org.openstreetmap.josm.tools.I18n;

public class TrackSuggestStopsCommand
extends Command {
    private TrackStoplistTableModel stoplistTM = null;
    private String type = null;
    private String stopwatchStart;
    private String gpsStartTime;
    private String gpsSyncTime;
    private double timeWindow;
    private double threshold;
    private Collection<IGpxTrackSegment> segments = null;
    private Vector<Vector<Object>> tableDataModel = null;
    private Vector<Node> nodes = null;
    private Vector<String> times = null;

    public TrackSuggestStopsCommand(StopImporterAction controller) {
        super(MainApplication.getLayerManager().getEditDataSet());
        if (controller.getCurrentTrack() == null) {
            return;
        }
        this.stoplistTM = controller.getCurrentTrack().stoplistTM;
        this.type = controller.getDialog().getStoptype();
        this.stopwatchStart = controller.getCurrentTrack().stopwatchStart;
        this.gpsStartTime = controller.getCurrentTrack().gpsStartTime;
        this.gpsSyncTime = controller.getCurrentTrack().gpsSyncTime;
        this.timeWindow = controller.getCurrentTrack().timeWindow;
        this.threshold = controller.getCurrentTrack().threshold;
        this.segments = controller.getCurrentTrack().getGpxTrack().getSegments();
    }

    public boolean executeCommand() {
        int i;
        if (this.stoplistTM == null) {
            return false;
        }
        this.tableDataModel = (Vector)this.stoplistTM.getDataVector().clone();
        this.nodes = (Vector)this.stoplistTM.getNodes().clone();
        this.times = (Vector)this.stoplistTM.getTimes().clone();
        for (int i2 = 0; i2 < this.stoplistTM.getNodes().size(); ++i2) {
            Node node = this.stoplistTM.nodeAt(i2);
            if (node == null) continue;
            MainApplication.getLayerManager().getEditDataSet().removePrimitive((PrimitiveId)node);
            node.setDeleted(true);
        }
        this.stoplistTM.clear();
        Vector<WayPoint> wayPoints = new Vector<WayPoint>();
        Iterator<IGpxTrackSegment> siter = this.segments.iterator();
        while (siter.hasNext()) {
            Iterator witer = siter.next().getWayPoints().iterator();
            while (witer.hasNext()) {
                wayPoints.add((WayPoint)witer.next());
            }
        }
        Vector<Double> wayPointsDist = new Vector<Double>(wayPoints.size());
        double time = -172800.0;
        double dGpsStartTime = StopImporterDialog.parseTime(this.gpsStartTime);
        for (i = 0; i < wayPoints.size() && time < dGpsStartTime + this.timeWindow / 2.0; ++i) {
            if (((WayPoint)wayPoints.elementAt(i)).getString("time") != null) {
                time = StopImporterDialog.parseTime(((WayPoint)wayPoints.elementAt(i)).getString("time").substring(11, 19));
            }
            if (time < dGpsStartTime) {
                time += 86400.0;
            }
            wayPointsDist.add(Double.POSITIVE_INFINITY);
        }
        while (i < wayPoints.size()) {
            int k;
            int j = i;
            double time2 = time;
            while (j > 0 && time - this.timeWindow / 2.0 < time2) {
                if (((WayPoint)wayPoints.elementAt(--j)).getString("time") != null) {
                    time2 = StopImporterDialog.parseTime(((WayPoint)wayPoints.elementAt(j)).getString("time").substring(11, 19));
                }
                if (!(time2 < dGpsStartTime)) continue;
                time2 += 86400.0;
            }
            time2 = time;
            for (k = i + 1; k < wayPoints.size() && time + this.timeWindow / 2.0 > time2; ++k) {
                if (((WayPoint)wayPoints.elementAt(k)).getString("time") != null) {
                    time2 = StopImporterDialog.parseTime(((WayPoint)wayPoints.elementAt(k)).getString("time").substring(11, 19));
                }
                if (!(time2 < dGpsStartTime)) continue;
                time2 += 86400.0;
            }
            if (j < k) {
                double dist = 0.0;
                LatLon latLonI = ((WayPoint)wayPoints.elementAt(i)).getCoor();
                for (int l = j; l < k; ++l) {
                    double distL = latLonI.greatCircleDistance((ILatLon)wayPoints.elementAt(l));
                    if (!(distL > dist)) continue;
                    dist = distL;
                }
                wayPointsDist.add(dist);
            } else {
                wayPointsDist.add(Double.POSITIVE_INFINITY);
            }
            if (((WayPoint)wayPoints.elementAt(i)).getString("time") != null) {
                time = StopImporterDialog.parseTime(((WayPoint)wayPoints.elementAt(i)).getString("time").substring(11, 19));
            }
            if (time < dGpsStartTime) {
                time += 86400.0;
            }
            ++i;
        }
        LatLon lastStopCoor = null;
        for (i = 1; i < wayPoints.size() - 1; ++i) {
            if ((Double)wayPointsDist.elementAt(i) >= this.threshold || ((Double)wayPointsDist.elementAt(i)).compareTo((Double)wayPointsDist.elementAt(i - 1)) != -1 || ((Double)wayPointsDist.elementAt(i)).compareTo((Double)wayPointsDist.elementAt(i + 1)) != -1) continue;
            LatLon latLon = ((WayPoint)wayPoints.elementAt(i)).getCoor();
            if (lastStopCoor != null && lastStopCoor.greatCircleDistance((ILatLon)latLon) < this.threshold) continue;
            if (((WayPoint)wayPoints.elementAt(i)).getString("time") != null) {
                time = StopImporterDialog.parseTime(((WayPoint)wayPoints.elementAt(i)).getString("time").substring(11, 19));
                double gpsSyncTime = StopImporterDialog.parseTime(this.gpsSyncTime);
                if (gpsSyncTime < dGpsStartTime - 43200.0) {
                    gpsSyncTime += 86400.0;
                }
                double timeDelta = gpsSyncTime - StopImporterDialog.parseTime(this.stopwatchStart);
                Node node = StopImporterAction.createNode(latLon, this.type, "");
                this.stoplistTM.insertRow(-1, node, StopImporterAction.timeOf(time -= timeDelta), "", new TransText(null));
            }
            lastStopCoor = latLon;
        }
        return true;
    }

    public void undoCommand() {
        Node node;
        int i;
        if (this.stoplistTM == null) {
            return;
        }
        for (i = 0; i < this.stoplistTM.getNodes().size(); ++i) {
            node = this.stoplistTM.nodeAt(i);
            if (node == null) continue;
            MainApplication.getLayerManager().getEditDataSet().removePrimitive((PrimitiveId)node);
            node.setDeleted(true);
        }
        this.stoplistTM.setDataVector(this.tableDataModel);
        this.stoplistTM.setNodes(this.nodes);
        this.stoplistTM.setTimes(this.times);
        for (i = 0; i < this.stoplistTM.getNodes().size(); ++i) {
            node = this.stoplistTM.nodeAt(i);
            if (node == null) continue;
            node.setDeleted(false);
            MainApplication.getLayerManager().getEditDataSet().addPrimitive((OsmPrimitive)node);
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Public Transport: Suggest stops", (Object[])new Object[0]);
    }
}

