/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.measure.MetricPrefix;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.operation.AbstractCoordinateOperationFactory;
import org.geotools.referencing.operation.DefaultOperation;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.DefaultPassThroughOperation;
import org.geotools.referencing.operation.ProjectionAnalyzer;
import org.geotools.referencing.operation.matrix.Matrix4;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.SingularMatrixException;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.util.Classes;
import org.geotools.util.factory.Hints;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.Projection;
import si.uom.NonSI;
import si.uom.SI;

public class DefaultCoordinateOperationFactory
extends AbstractCoordinateOperationFactory {
    static final int PRIORITY = 50;
    private static final double EPS = 1.0E-9;
    private static final Unit<Time> MILLISECOND = MetricPrefix.MILLI(SI.SECOND);
    private final String molodenskiMethod;
    private final boolean lenientDatumShift;

    public DefaultCoordinateOperationFactory() {
        this(null);
    }

    public DefaultCoordinateOperationFactory(Hints userHints) {
        this(userHints, 50);
    }

    public DefaultCoordinateOperationFactory(Hints userHints, int priority) {
        super(userHints, priority);
        String molodenskiMethod = "Molodenski";
        boolean lenientDatumShift = false;
        if (userHints != null) {
            Object candidate = userHints.get(Hints.DATUM_SHIFT_METHOD);
            if (candidate instanceof String && (molodenskiMethod = (String)candidate).trim().equalsIgnoreCase("Geocentric")) {
                molodenskiMethod = null;
            }
            if ((candidate = userHints.get(Hints.LENIENT_DATUM_SHIFT)) instanceof Boolean) {
                lenientDatumShift = (Boolean)candidate;
            }
        }
        this.molodenskiMethod = molodenskiMethod;
        this.lenientDatumShift = lenientDatumShift;
        this.hints.put(Hints.DATUM_SHIFT_METHOD, molodenskiMethod);
        this.hints.put(Hints.LENIENT_DATUM_SHIFT, lenientDatumShift);
    }

    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws OperationNotFoundException, FactoryException {
        Set<CoordinateOperation> operations = this.findOperations(sourceCRS, targetCRS, 1);
        Iterator<CoordinateOperation> iterator = operations.iterator();
        if (iterator.hasNext()) {
            CoordinateOperation op = iterator.next();
            return op;
        }
        throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceCRS, targetCRS));
    }

    @Override
    public Set<CoordinateOperation> findOperations(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        return this.findOperations(sourceCRS, targetCRS, -1);
    }

    protected Set<CoordinateOperation> findOperations(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, int limit) throws FactoryException {
        List<SingleCRS> targets;
        List<SingleCRS> sources;
        DefaultCoordinateOperationFactory.ensureNonNull("sourceCRS", sourceCRS);
        DefaultCoordinateOperationFactory.ensureNonNull("targetCRS", targetCRS);
        if (CRS.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
            int dim = DefaultCoordinateOperationFactory.getDimension(sourceCRS);
            assert (dim == DefaultCoordinateOperationFactory.getDimension(targetCRS)) : dim;
            CoordinateOperation op = this.createFromAffineTransform(IDENTITY, sourceCRS, targetCRS, MatrixFactory.create(dim + 1));
            return Collections.singleton(op);
        }
        Set<CoordinateOperation> result = this.findFromDatabase(sourceCRS, targetCRS, limit);
        if (!result.isEmpty()) {
            return result;
        }
        if (this.isWildcard(sourceCRS) || this.isWildcard(targetCRS)) {
            int dimSource = DefaultCoordinateOperationFactory.getDimension(sourceCRS);
            int dimTarget = DefaultCoordinateOperationFactory.getDimension(targetCRS);
            if (dimTarget == dimSource) {
                XMatrix matrix = MatrixFactory.create(dimTarget + 1, dimSource + 1);
                CoordinateOperation op = this.createFromAffineTransform(IDENTITY, sourceCRS, targetCRS, matrix);
                return Collections.singleton(op);
            }
        }
        if (sourceCRS instanceof CompoundCRS && DefaultCoordinateOperationFactory.containsIgnoreMetadata(sources = DefaultCompoundCRS.getSingleCRS(sourceCRS), targets = DefaultCompoundCRS.getSingleCRS(targetCRS))) {
            CompoundCRS source = (CompoundCRS)sourceCRS;
            if (targetCRS instanceof CompoundCRS) {
                CompoundCRS target = (CompoundCRS)targetCRS;
                return this.findOperationSteps(source, target, limit);
            }
            if (targetCRS instanceof SingleCRS) {
                SingleCRS target = (SingleCRS)targetCRS;
                return this.findOperationSteps(source, target, limit);
            }
        }
        if (sourceCRS instanceof GeographicCRS) {
            GeographicCRS source = (GeographicCRS)sourceCRS;
            if (targetCRS instanceof GeographicCRS) {
                GeographicCRS target = (GeographicCRS)targetCRS;
                return Collections.singleton(this.createOperationStep(source, target));
            }
            if (targetCRS instanceof ProjectedCRS) {
                ProjectedCRS target = (ProjectedCRS)targetCRS;
                return this.findOperationSteps(source, target, limit);
            }
            if (targetCRS instanceof GeocentricCRS) {
                GeocentricCRS target = (GeocentricCRS)targetCRS;
                return Collections.singleton(this.createOperationStep(source, target));
            }
            if (targetCRS instanceof VerticalCRS) {
                VerticalCRS target = (VerticalCRS)targetCRS;
                return Collections.singleton(this.createOperationStep(source, target));
            }
        }
        if (sourceCRS instanceof ProjectedCRS) {
            ProjectedCRS source = (ProjectedCRS)sourceCRS;
            if (targetCRS instanceof ProjectedCRS) {
                ProjectedCRS target = (ProjectedCRS)targetCRS;
                return this.findOperationSteps(source, target, limit);
            }
            if (targetCRS instanceof GeographicCRS) {
                GeographicCRS target = (GeographicCRS)targetCRS;
                return this.findOperationSteps(source, target, limit);
            }
        }
        if (sourceCRS instanceof GeocentricCRS) {
            GeocentricCRS source = (GeocentricCRS)sourceCRS;
            if (targetCRS instanceof GeocentricCRS) {
                GeocentricCRS target = (GeocentricCRS)targetCRS;
                return Collections.singleton(this.createOperationStep(source, target));
            }
            if (targetCRS instanceof GeographicCRS) {
                GeographicCRS target = (GeographicCRS)targetCRS;
                return Collections.singleton(this.createOperationStep(source, target));
            }
        }
        if (sourceCRS instanceof VerticalCRS) {
            VerticalCRS source = (VerticalCRS)sourceCRS;
            if (targetCRS instanceof VerticalCRS) {
                VerticalCRS target = (VerticalCRS)targetCRS;
                return Collections.singleton(this.createOperationStep(source, target));
            }
        }
        if (sourceCRS instanceof TemporalCRS) {
            TemporalCRS source = (TemporalCRS)sourceCRS;
            if (targetCRS instanceof TemporalCRS) {
                TemporalCRS target = (TemporalCRS)targetCRS;
                return Collections.singleton(this.createOperationStep(source, target));
            }
        }
        if (targetCRS instanceof GeneralDerivedCRS) {
            GeneralDerivedCRS target = (GeneralDerivedCRS)targetCRS;
            CoordinateReferenceSystem base = target.getBaseCRS();
            Set<CoordinateOperation> step1 = this.findOperations(sourceCRS, base, limit);
            Conversion step2 = target.getConversionFromBase();
            return this.concatenate(step1, Collections.singleton(step2));
        }
        if (sourceCRS instanceof GeneralDerivedCRS) {
            GeneralDerivedCRS source = (GeneralDerivedCRS)sourceCRS;
            CoordinateReferenceSystem base = source.getBaseCRS();
            Set<CoordinateOperation> step2 = this.findOperations(base, targetCRS, limit);
            CoordinateOperation step1 = source.getConversionFromBase();
            MathTransform transform = step1.getMathTransform();
            try {
                transform = transform.inverse();
            }
            catch (NoninvertibleTransformException exception) {
                throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceCRS, base), exception);
            }
            step1 = this.createFromMathTransform(INVERSE_OPERATION, sourceCRS, base, transform);
            return this.concatenate(Collections.singleton(step1), step2);
        }
        if (sourceCRS instanceof CompoundCRS) {
            CompoundCRS source = (CompoundCRS)sourceCRS;
            if (targetCRS instanceof CompoundCRS) {
                CompoundCRS target = (CompoundCRS)targetCRS;
                return this.findOperationSteps(source, target, limit);
            }
            if (targetCRS instanceof SingleCRS) {
                SingleCRS target = (SingleCRS)targetCRS;
                return this.findOperationSteps(source, target, limit);
            }
        }
        if (targetCRS instanceof CompoundCRS) {
            CompoundCRS target = (CompoundCRS)targetCRS;
            if (sourceCRS instanceof SingleCRS) {
                SingleCRS source = (SingleCRS)sourceCRS;
                return this.findOperationSteps(source, target, limit);
            }
        }
        return Collections.emptySet();
    }

    boolean isWildcard(CoordinateReferenceSystem sourceCRS) {
        return sourceCRS instanceof DefaultEngineeringCRS && ((DefaultEngineeringCRS)sourceCRS).isWildcard();
    }

    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, OperationMethod method) throws OperationNotFoundException, FactoryException {
        return this.createOperation(sourceCRS, targetCRS);
    }

    private GeocentricCRS normalize(GeocentricCRS crs, GeodeticDatum datum) throws FactoryException {
        DefaultCartesianCS STANDARD = DefaultCartesianCS.GEOCENTRIC;
        GeodeticDatum candidate = crs.getDatum();
        if (DefaultCoordinateOperationFactory.equalsIgnorePrimeMeridian(candidate, datum) && DefaultCoordinateOperationFactory.getGreenwichLongitude(candidate.getPrimeMeridian()) == DefaultCoordinateOperationFactory.getGreenwichLongitude(datum.getPrimeMeridian()) && DefaultCoordinateOperationFactory.hasStandardAxis(crs.getCoordinateSystem(), STANDARD)) {
            return crs;
        }
        CRSFactory crsFactory = this.getFactoryContainer().getCRSFactory();
        return crsFactory.createGeocentricCRS(DefaultCoordinateOperationFactory.getTemporaryName(crs), datum, STANDARD);
    }

    private GeographicCRS normalize(GeographicCRS crs, boolean forceGreenwich) throws FactoryException {
        DefaultEllipsoidalCS STANDARD;
        GeodeticDatum datum = crs.getDatum();
        EllipsoidalCS cs = crs.getCoordinateSystem();
        DefaultEllipsoidalCS defaultEllipsoidalCS = STANDARD = cs.getDimension() <= 2 ? DefaultEllipsoidalCS.GEODETIC_2D : DefaultEllipsoidalCS.GEODETIC_3D;
        if (forceGreenwich && DefaultCoordinateOperationFactory.getGreenwichLongitude(datum.getPrimeMeridian()) != 0.0) {
            datum = new TemporaryDatum(datum);
        } else if (DefaultCoordinateOperationFactory.hasStandardAxis(cs, STANDARD)) {
            return crs;
        }
        CRSFactory crsFactory = this.getFactoryContainer().getCRSFactory();
        return crsFactory.createGeographicCRS(DefaultCoordinateOperationFactory.getTemporaryName(crs), datum, STANDARD);
    }

    private static boolean hasStandardAxis(CoordinateSystem cs, CoordinateSystem standard) {
        int dimension = standard.getDimension();
        if (cs.getDimension() != dimension) {
            return false;
        }
        for (int i = 0; i < dimension; ++i) {
            CoordinateSystemAxis a1 = cs.getAxis(i);
            CoordinateSystemAxis a2 = standard.getAxis(i);
            if (a1.getDirection().equals(a2.getDirection()) && a1.getUnit().equals(a2.getUnit())) continue;
            return false;
        }
        return true;
    }

    private Matrix swapAndScaleAxis(EllipsoidalCS sourceCS, EllipsoidalCS targetCS, PrimeMeridian sourcePM, PrimeMeridian targetPM) throws OperationNotFoundException {
        Matrix matrix = this.swapAndScaleAxis(sourceCS, targetCS);
        int i = targetCS.getDimension();
        while (--i >= 0) {
            CoordinateSystemAxis axis = targetCS.getAxis(i);
            AxisDirection direction = axis.getDirection();
            if (!AxisDirection.EAST.equals(direction.absolute())) continue;
            Unit<Angle> unit = axis.getUnit().asType(Angle.class);
            double sourceLongitude = DefaultCoordinateOperationFactory.getGreenwichLongitude(sourcePM, unit);
            double targetLongitude = DefaultCoordinateOperationFactory.getGreenwichLongitude(targetPM, unit);
            int lastMatrixColumn = matrix.getNumCol() - 1;
            double rotate = sourceLongitude - targetLongitude;
            if (AxisDirection.WEST.equals(direction)) {
                rotate = -rotate;
            }
            matrix.setElement(i, lastMatrixColumn, rotate += matrix.getElement(i, lastMatrixColumn));
        }
        return matrix;
    }

    private static double getGreenwichLongitude(PrimeMeridian pm, Unit<Angle> unit) {
        return pm.getAngularUnit().getConverterTo(unit).convert(pm.getGreenwichLongitude());
    }

    private static double getGreenwichLongitude(PrimeMeridian pm) {
        return DefaultCoordinateOperationFactory.getGreenwichLongitude(pm, NonSI.DEGREE_ANGLE);
    }

    protected CoordinateOperation createOperationStep(TemporalCRS sourceCRS, TemporalCRS targetCRS) throws FactoryException {
        TemporalDatum targetDatum;
        TemporalDatum sourceDatum = sourceCRS.getDatum();
        if (!CRS.equalsIgnoreMetadata(sourceDatum, targetDatum = targetCRS.getDatum())) {
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceDatum, targetDatum));
        }
        TimeCS sourceCS = sourceCRS.getCoordinateSystem();
        TimeCS targetCS = targetCRS.getCoordinateSystem();
        Unit<?> targetUnit = targetCS.getAxis(0).getUnit();
        double epochShift = sourceDatum.getOrigin().getTime() - targetDatum.getOrigin().getTime();
        epochShift = MILLISECOND.getConverterTo(targetUnit).convert(epochShift);
        Matrix matrix = this.swapAndScaleAxis(sourceCS, targetCS);
        int translationColumn = matrix.getNumCol() - 1;
        if (translationColumn >= 0) {
            double translation = matrix.getElement(0, translationColumn);
            matrix.setElement(0, translationColumn, translation + epochShift);
        }
        return this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, matrix);
    }

    protected CoordinateOperation createOperationStep(VerticalCRS sourceCRS, VerticalCRS targetCRS) throws FactoryException {
        VerticalDatum targetDatum;
        VerticalDatum sourceDatum = sourceCRS.getDatum();
        if (!CRS.equalsIgnoreMetadata(sourceDatum, targetDatum = targetCRS.getDatum())) {
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceDatum, targetDatum));
        }
        VerticalCS sourceCS = sourceCRS.getCoordinateSystem();
        VerticalCS targetCS = targetCRS.getCoordinateSystem();
        Matrix matrix = this.swapAndScaleAxis(sourceCS, targetCS);
        return this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, matrix);
    }

    protected CoordinateOperation createOperationStep(GeographicCRS sourceCRS, VerticalCRS targetCRS) throws FactoryException {
        if (VerticalDatumType.ELLIPSOIDAL.equals(targetCRS.getDatum().getVerticalDatumType())) {
            Matrix matrix = this.swapAndScaleAxis(sourceCRS.getCoordinateSystem(), targetCRS.getCoordinateSystem());
            return this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, matrix);
        }
        throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceCRS, targetCRS));
    }

    protected CoordinateOperation createOperationStep(GeographicCRS sourceCRS, GeographicCRS targetCRS) throws FactoryException {
        EllipsoidalCS sourceCS = sourceCRS.getCoordinateSystem();
        EllipsoidalCS targetCS = targetCRS.getCoordinateSystem();
        GeodeticDatum sourceDatum = sourceCRS.getDatum();
        GeodeticDatum targetDatum = targetCRS.getDatum();
        PrimeMeridian sourcePM = sourceDatum.getPrimeMeridian();
        PrimeMeridian targetPM = targetDatum.getPrimeMeridian();
        if (DefaultCoordinateOperationFactory.equalsIgnorePrimeMeridian(sourceDatum, targetDatum)) {
            Matrix matrix = this.swapAndScaleAxis(sourceCS, targetCS, sourcePM, targetPM);
            return this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, matrix);
        }
        if (this.molodenskiMethod != null) {
            ReferenceIdentifier identifier = DATUM_SHIFT;
            BursaWolfParameters bursaWolf = null;
            if (sourceDatum instanceof DefaultGeodeticDatum) {
                bursaWolf = ((DefaultGeodeticDatum)sourceDatum).getBursaWolfParameters(targetDatum);
            }
            if (bursaWolf == null) {
                Matrix shift = DefaultGeodeticDatum.getAffineTransform(sourceDatum, targetDatum);
                if (shift != null) {
                    try {
                        bursaWolf = new BursaWolfParameters(targetDatum);
                        bursaWolf.setAffineTransform(shift, 1.0E-4);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (this.lenientDatumShift) {
                    bursaWolf = new BursaWolfParameters(targetDatum);
                    identifier = ELLIPSOID_SHIFT;
                }
            }
            if (bursaWolf != null && bursaWolf.isTranslation()) {
                Ellipsoid sourceEllipsoid = sourceDatum.getEllipsoid();
                Ellipsoid targetEllipsoid = targetDatum.getEllipsoid();
                if (bursaWolf.isIdentity() && CRS.equalsIgnoreMetadata(sourceEllipsoid, targetEllipsoid)) {
                    Matrix matrix = this.swapAndScaleAxis(sourceCS, targetCS, sourcePM, targetPM);
                    return this.createFromAffineTransform(identifier, sourceCRS, targetCRS, matrix);
                }
                int sourceDim = DefaultCoordinateOperationFactory.getDimension(sourceCRS);
                int targetDim = DefaultCoordinateOperationFactory.getDimension(targetCRS);
                ParameterValueGroup parameters = this.getMathTransformFactory().getDefaultParameters(this.molodenskiMethod);
                parameters.parameter("src_semi_major").setValue(sourceEllipsoid.getSemiMajorAxis());
                parameters.parameter("src_semi_minor").setValue(sourceEllipsoid.getSemiMinorAxis());
                parameters.parameter("tgt_semi_major").setValue(targetEllipsoid.getSemiMajorAxis());
                parameters.parameter("tgt_semi_minor").setValue(targetEllipsoid.getSemiMinorAxis());
                parameters.parameter("dx").setValue(bursaWolf.dx);
                parameters.parameter("dy").setValue(bursaWolf.dy);
                parameters.parameter("dz").setValue(bursaWolf.dz);
                parameters.parameter("dim").setValue(sourceDim);
                if (sourceDim == targetDim) {
                    GeographicCRS normSourceCRS = this.normalize(sourceCRS, true);
                    GeographicCRS normTargetCRS = this.normalize(targetCRS, true);
                    CoordinateOperation step1 = this.createOperationStep(sourceCRS, normSourceCRS);
                    CoordinateOperation step2 = this.createFromParameters(identifier, normSourceCRS, normTargetCRS, parameters);
                    CoordinateOperation step3 = this.createOperationStep(normTargetCRS, targetCRS);
                    return this.concatenate(step1, step2, step3);
                }
            }
        }
        DefaultCartesianCS STANDARD = DefaultCartesianCS.GEOCENTRIC;
        CRSFactory crsFactory = this.getFactoryContainer().getCRSFactory();
        GeocentricCRS stepCRS = DefaultCoordinateOperationFactory.getGreenwichLongitude(targetPM) == 0.0 ? crsFactory.createGeocentricCRS(DefaultCoordinateOperationFactory.getTemporaryName(targetCRS), targetDatum, STANDARD) : crsFactory.createGeocentricCRS(DefaultCoordinateOperationFactory.getTemporaryName(sourceCRS), sourceDatum, STANDARD);
        CoordinateOperation step1 = this.createOperationStep(sourceCRS, stepCRS);
        CoordinateOperation step2 = this.createOperationStep(stepCRS, targetCRS);
        return this.concatenate(step1, step2);
    }

    protected CoordinateOperation createOperationStep(ProjectedCRS sourceCRS, ProjectedCRS targetCRS) throws FactoryException {
        Iterator<CoordinateOperation> iterator = this.findOperationSteps(sourceCRS, targetCRS, 1).iterator();
        if (iterator.hasNext()) {
            CoordinateOperation op = iterator.next();
            return op;
        }
        return null;
    }

    protected Set<CoordinateOperation> findOperationSteps(ProjectedCRS sourceCRS, ProjectedCRS targetCRS, int limit) throws FactoryException {
        Set<CoordinateOperation> step3;
        Set<CoordinateOperation> step2;
        Matrix linear = ProjectionAnalyzer.createLinearConversion(sourceCRS, targetCRS, 1.0E-9);
        if (linear != null) {
            return Collections.singleton(this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, linear));
        }
        GeographicCRS sourceGeo = sourceCRS.getBaseCRS();
        GeographicCRS targetGeo = targetCRS.getBaseCRS();
        Set<CoordinateOperation> step1 = this.tryDB(sourceCRS, sourceGeo, limit);
        if (step1.isEmpty()) {
            step1 = this.findOperationSteps(sourceCRS, sourceGeo, limit);
        }
        if ((step2 = this.tryDB(sourceGeo, targetGeo, limit)).isEmpty()) {
            step2 = Collections.singleton(this.createOperationStep(sourceGeo, targetGeo));
        }
        if ((step3 = this.tryDB(targetGeo, targetCRS, limit)).isEmpty()) {
            step3 = this.findOperationSteps(targetGeo, targetCRS, limit);
        }
        return this.concatenate(step1, step2, step3);
    }

    protected CoordinateOperation createOperationStep(GeographicCRS sourceCRS, ProjectedCRS targetCRS) throws FactoryException {
        Iterator<CoordinateOperation> iterator = this.findOperationSteps(sourceCRS, targetCRS, 1).iterator();
        if (iterator.hasNext()) {
            CoordinateOperation op = iterator.next();
            return op;
        }
        return null;
    }

    protected Set<CoordinateOperation> findOperationSteps(GeographicCRS sourceCRS, ProjectedCRS targetCRS, int limit) throws FactoryException {
        GeographicCRS base = targetCRS.getBaseCRS();
        Projection step2 = targetCRS.getConversionFromBase();
        HashSet<CoordinateOperation> result = new HashSet<CoordinateOperation>();
        Set<CoordinateOperation> step1Candidates = this.tryDB(sourceCRS, base, limit);
        if (step1Candidates.isEmpty()) {
            CoordinateOperation step1 = this.createOperationStep(sourceCRS, base);
            step1Candidates = Collections.singleton(step1);
        }
        for (CoordinateOperation step1 : step1Candidates) {
            result.add(this.concatenate(step1, step2));
        }
        return result;
    }

    protected CoordinateOperation createOperationStep(ProjectedCRS sourceCRS, GeographicCRS targetCRS) throws FactoryException {
        Iterator<CoordinateOperation> iterator = this.findOperationSteps(sourceCRS, targetCRS, 1).iterator();
        if (iterator.hasNext()) {
            CoordinateOperation op = iterator.next();
            return op;
        }
        return null;
    }

    protected Set<CoordinateOperation> findOperationSteps(ProjectedCRS sourceCRS, GeographicCRS targetCRS, int limit) throws FactoryException {
        GeographicCRS base = sourceCRS.getBaseCRS();
        CoordinateOperation step1 = sourceCRS.getConversionFromBase();
        HashSet<CoordinateOperation> result = new HashSet<CoordinateOperation>();
        Set<CoordinateOperation> step2Candidates = this.tryDB(base, targetCRS, limit);
        if (step2Candidates.isEmpty()) {
            CoordinateOperation step2 = this.createOperationStep(base, targetCRS);
            step2Candidates = Collections.singleton(step2);
        }
        MathTransform transform = step1.getMathTransform();
        try {
            transform = transform.inverse();
        }
        catch (NoninvertibleTransformException exception) {
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceCRS, base), exception);
        }
        for (CoordinateOperation step2 : step2Candidates) {
            step1 = this.createFromMathTransform(INVERSE_OPERATION, sourceCRS, base, transform);
            result.add(this.concatenate(step1, step2));
        }
        return result;
    }

    protected CoordinateOperation createOperationStep(GeocentricCRS sourceCRS, GeocentricCRS targetCRS) throws FactoryException {
        Matrix4 matrix;
        GeodeticDatum sourceDatum = sourceCRS.getDatum();
        GeodeticDatum targetDatum = targetCRS.getDatum();
        CoordinateSystem sourceCS = sourceCRS.getCoordinateSystem();
        CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
        double sourcePM = DefaultCoordinateOperationFactory.getGreenwichLongitude(sourceDatum.getPrimeMeridian());
        double targetPM = DefaultCoordinateOperationFactory.getGreenwichLongitude(targetDatum.getPrimeMeridian());
        if (DefaultCoordinateOperationFactory.equalsIgnorePrimeMeridian(sourceDatum, targetDatum) && sourcePM == targetPM) {
            Matrix matrix2 = this.swapAndScaleAxis(sourceCS, targetCS);
            return this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, matrix2);
        }
        if (sourcePM != targetPM) {
            throw new OperationNotFoundException("Rotation of prime meridian not yet implemented");
        }
        DefaultCartesianCS STANDARD = DefaultCartesianCS.GEOCENTRIC;
        ReferenceIdentifier identifier = DATUM_SHIFT;
        try {
            Matrix datumShift = DefaultGeodeticDatum.getAffineTransform(TemporaryDatum.unwrap(sourceDatum), TemporaryDatum.unwrap(targetDatum));
            if (datumShift == null) {
                if (this.lenientDatumShift) {
                    datumShift = new Matrix4();
                    identifier = ELLIPSOID_SHIFT;
                } else {
                    throw new OperationNotFoundException(Errors.format(18));
                }
            }
            Matrix normalizeSource = this.swapAndScaleAxis(sourceCS, STANDARD);
            Matrix normalizeTarget = this.swapAndScaleAxis(STANDARD, targetCS);
            matrix = new Matrix4(normalizeTarget);
            matrix.multiply(datumShift);
            matrix.multiply(normalizeSource);
        }
        catch (SingularMatrixException cause) {
            throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceDatum, targetDatum), cause);
        }
        return this.createFromAffineTransform(identifier, sourceCRS, targetCRS, matrix);
    }

    protected CoordinateOperation createOperationStep(GeographicCRS sourceCRS, GeocentricCRS targetCRS) throws FactoryException {
        GeographicCRS normSourceCRS = this.normalize(sourceCRS, true);
        GeodeticDatum datum = normSourceCRS.getDatum();
        GeocentricCRS normTargetCRS = this.normalize(targetCRS, datum);
        Ellipsoid ellipsoid = datum.getEllipsoid();
        Unit<Length> unit = ellipsoid.getAxisUnit();
        ParameterValueGroup param = this.getMathTransformFactory().getDefaultParameters("Ellipsoid_To_Geocentric");
        param.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis(), unit);
        param.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis(), unit);
        param.parameter("dim").setValue(DefaultCoordinateOperationFactory.getDimension(normSourceCRS));
        CoordinateOperation step1 = this.createOperationStep(sourceCRS, normSourceCRS);
        CoordinateOperation step2 = this.createFromParameters(GEOCENTRIC_CONVERSION, normSourceCRS, normTargetCRS, param);
        CoordinateOperation step3 = this.createOperationStep(normTargetCRS, targetCRS);
        return this.concatenate(step1, step2, step3);
    }

    protected CoordinateOperation createOperationStep(GeocentricCRS sourceCRS, GeographicCRS targetCRS) throws FactoryException {
        GeographicCRS normTargetCRS = this.normalize(targetCRS, true);
        GeodeticDatum datum = normTargetCRS.getDatum();
        GeocentricCRS normSourceCRS = this.normalize(sourceCRS, datum);
        Ellipsoid ellipsoid = datum.getEllipsoid();
        Unit<Length> unit = ellipsoid.getAxisUnit();
        ParameterValueGroup param = this.getMathTransformFactory().getDefaultParameters("Geocentric_To_Ellipsoid");
        param.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis(), unit);
        param.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis(), unit);
        param.parameter("dim").setValue(DefaultCoordinateOperationFactory.getDimension(normTargetCRS));
        CoordinateOperation step1 = this.createOperationStep(sourceCRS, normSourceCRS);
        CoordinateOperation step2 = this.createFromParameters(GEOCENTRIC_CONVERSION, normSourceCRS, normTargetCRS, param);
        CoordinateOperation step3 = this.createOperationStep(normTargetCRS, targetCRS);
        return this.concatenate(step1, step2, step3);
    }

    protected CoordinateOperation createOperationStep(CompoundCRS sourceCRS, SingleCRS targetCRS) throws FactoryException {
        Iterator<CoordinateOperation> iterator = this.findOperationSteps(sourceCRS, targetCRS, 1).iterator();
        if (iterator.hasNext()) {
            CoordinateOperation op = iterator.next();
            return op;
        }
        return null;
    }

    protected Set<CoordinateOperation> findOperationSteps(CompoundCRS sourceCRS, SingleCRS targetCRS, int limit) throws FactoryException {
        List<SingleCRS> sources = DefaultCompoundCRS.getSingleCRS(sourceCRS);
        if (sources.size() == 1) {
            return this.findOperations(sources.get(0), targetCRS, limit);
        }
        if (!DefaultCoordinateOperationFactory.needsGeodetic3D(sources, targetCRS)) {
            List<SingleCRS> targets = Collections.singletonList(targetCRS);
            return Collections.singleton(this.createOperationStep(sourceCRS, sources, targetCRS, targets));
        }
        CoordinateReferenceSystem source3D = this.getFactoryContainer().toGeodetic3D(sourceCRS);
        if (source3D != sourceCRS) {
            return this.findOperations(source3D, targetCRS, limit);
        }
        return Collections.emptySet();
    }

    protected CoordinateOperation createOperationStep(SingleCRS sourceCRS, CompoundCRS targetCRS) throws FactoryException {
        Iterator<CoordinateOperation> iterator = this.findOperationSteps(sourceCRS, targetCRS, 1).iterator();
        if (iterator.hasNext()) {
            CoordinateOperation op = iterator.next();
            return op;
        }
        return null;
    }

    protected Set<CoordinateOperation> findOperationSteps(SingleCRS sourceCRS, CompoundCRS targetCRS, int limit) throws FactoryException {
        List<SingleCRS> targets = DefaultCompoundCRS.getSingleCRS(targetCRS);
        if (targets.size() == 1) {
            return this.findOperations(sourceCRS, targets.get(0), limit);
        }
        CoordinateReferenceSystem target3D = this.getFactoryContainer().toGeodetic3D(targetCRS);
        if (target3D != targetCRS) {
            return this.findOperations(sourceCRS, target3D, limit);
        }
        List<SingleCRS> sources = Collections.singletonList(sourceCRS);
        return Collections.singleton(this.createOperationStep(sourceCRS, sources, targetCRS, targets));
    }

    protected CoordinateOperation createOperationStep(CompoundCRS sourceCRS, CompoundCRS targetCRS) throws FactoryException {
        Iterator<CoordinateOperation> iterator = this.findOperationSteps(sourceCRS, targetCRS, 1).iterator();
        if (iterator.hasNext()) {
            CoordinateOperation op = iterator.next();
            return op;
        }
        return null;
    }

    protected Set<CoordinateOperation> findOperationSteps(CompoundCRS sourceCRS, CompoundCRS targetCRS, int limit) throws FactoryException {
        List<SingleCRS> sources = DefaultCompoundCRS.getSingleCRS(sourceCRS);
        List<SingleCRS> targets = DefaultCompoundCRS.getSingleCRS(targetCRS);
        if (targets.size() == 1) {
            return this.findOperations(sourceCRS, targets.get(0), limit);
        }
        if (sources.size() == 1) {
            return this.findOperations(sources.get(0), targetCRS, limit);
        }
        for (SingleCRS target : targets) {
            if (!DefaultCoordinateOperationFactory.needsGeodetic3D(sources, target)) continue;
            ReferencingFactoryContainer factories = this.getFactoryContainer();
            CoordinateReferenceSystem source3D = factories.toGeodetic3D(sourceCRS);
            CoordinateReferenceSystem target3D = factories.toGeodetic3D(targetCRS);
            if (source3D != sourceCRS || target3D != targetCRS) {
                return this.findOperations(source3D, target3D, limit);
            }
            return Collections.emptySet();
        }
        return Collections.singleton(this.createOperationStep(sourceCRS, sources, targetCRS, targets));
    }

    private CoordinateOperation createOperationStep(CoordinateReferenceSystem sourceCRS, List<SingleCRS> sources, CoordinateReferenceSystem targetCRS, List<SingleCRS> targets) throws FactoryException {
        CoordinateReferenceSystem[] ordered = new CoordinateReferenceSystem[targets.size()];
        CoordinateOperation[] steps = new CoordinateOperation[targets.size()];
        boolean[] done = new boolean[sources.size()];
        int[] indices = new int[DefaultCoordinateOperationFactory.getDimension(sourceCRS)];
        int count = 0;
        int dimensions = 0;
        for (int j = 0; j < targets.size(); ++j) {
            block13: {
                int upper = 0;
                CoordinateReferenceSystem target = targets.get(j);
                OperationNotFoundException cause = null;
                for (int i = 0; i < sources.size(); ++i) {
                    CoordinateReferenceSystem source = sources.get(i);
                    int lower = upper;
                    upper += DefaultCoordinateOperationFactory.getDimension(source);
                    if (done[i]) continue;
                    try {
                        steps[count] = this.createOperation(source, target);
                    }
                    catch (OperationNotFoundException exception) {
                        if (cause != null && i != j) continue;
                        cause = exception;
                        continue;
                    }
                    ordered[count++] = source;
                    while (lower < upper) {
                        indices[dimensions++] = lower++;
                    }
                    break block13;
                }
                throw new OperationNotFoundException(DefaultCoordinateOperationFactory.getErrorMessage(sourceCRS, targetCRS), cause);
            }
            done[i] = true;
        }
        assert (count == targets.size()) : count;
        --count;
        while (count != 0 && steps[count].getMathTransform().isIdentity()) {
            --count;
        }
        ReferencingFactoryContainer factories = this.getFactoryContainer();
        CoordinateOperation operation = null;
        CoordinateReferenceSystem sourceStepCRS = sourceCRS;
        XMatrix select = MatrixFactory.create(dimensions + 1, indices.length + 1);
        select.setZero();
        select.setElement(dimensions, indices.length, 1.0);
        for (int j = 0; j < dimensions; ++j) {
            select.setElement(j, indices[j], 1.0);
        }
        if (!select.isIdentity()) {
            sourceStepCRS = ordered.length == 1 ? ordered[0] : factories.getCRSFactory().createCompoundCRS(DefaultCoordinateOperationFactory.getTemporaryName(sourceCRS), ordered);
            operation = this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, sourceStepCRS, select);
        }
        int upper = 0;
        for (int i = 0; i < targets.size(); ++i) {
            CoordinateReferenceSystem target;
            CoordinateOperation step = steps[i];
            Map<String, ?> properties = AbstractIdentifiedObject.getProperties(step);
            CoordinateReferenceSystem source = ordered[i];
            ordered[i] = target = (CoordinateReferenceSystem)targets.get(i);
            MathTransform mt = step.getMathTransform();
            CoordinateReferenceSystem targetStepCRS = i >= count ? targetCRS : (mt.isIdentity() ? sourceStepCRS : (ordered.length == 1 ? ordered[0] : factories.getCRSFactory().createCompoundCRS(DefaultCoordinateOperationFactory.getTemporaryName(target), ordered)));
            int lower = upper;
            if (lower != 0 || (upper += DefaultCoordinateOperationFactory.getDimension(source)) != dimensions) {
                if (!(step instanceof Operation)) {
                    MathTransform stepMT = step.getMathTransform();
                    step = DefaultOperation.create(AbstractIdentifiedObject.getProperties(step), step.getSourceCRS(), step.getTargetCRS(), stepMT, new DefaultOperationMethod(stepMT), step.getClass());
                }
                mt = this.getMathTransformFactory().createPassThroughTransform(lower, mt, dimensions - upper);
                step = new DefaultPassThroughOperation(properties, sourceStepCRS, targetStepCRS, (Operation)step, mt);
            }
            operation = operation == null ? step : this.concatenate(operation, step);
            sourceStepCRS = targetStepCRS;
        }
        assert (upper == dimensions) : upper;
        return operation;
    }

    private static boolean needsGeodetic3D(List<SingleCRS> sourceCRS, SingleCRS targetCRS) {
        boolean targetGeodetic;
        Datum targetDatum = targetCRS.getDatum();
        if (targetDatum instanceof GeodeticDatum) {
            targetGeodetic = true;
        } else if (targetDatum instanceof VerticalDatum) {
            targetGeodetic = false;
        } else {
            return false;
        }
        boolean horizontal = false;
        boolean vertical = false;
        boolean shift = false;
        for (SingleCRS crs : sourceCRS) {
            boolean sourceGeodetic;
            Datum sourceDatum = crs.getDatum();
            if (sourceDatum instanceof GeodeticDatum) {
                horizontal = true;
                sourceGeodetic = true;
            } else {
                if (!(sourceDatum instanceof VerticalDatum)) continue;
                vertical = true;
                sourceGeodetic = false;
            }
            if (shift || sourceGeodetic != targetGeodetic) continue;
            boolean bl = shift = !CRS.equalsIgnoreMetadata(sourceDatum, targetDatum);
            assert (Classes.sameInterfaces(sourceDatum.getClass(), targetDatum.getClass(), Datum.class));
        }
        return horizontal && vertical && (shift || targetCRS.getCoordinateSystem().getDimension() >= 3);
    }

    private static boolean equalsIgnorePrimeMeridian(GeodeticDatum object1, GeodeticDatum object2) {
        object1 = TemporaryDatum.unwrap(object1);
        object2 = TemporaryDatum.unwrap(object2);
        if (CRS.equalsIgnoreMetadata(object1.getEllipsoid(), object2.getEllipsoid())) {
            return AbstractIdentifiedObject.nameMatches((IdentifiedObject)object1, object2.getName().getCode()) || AbstractIdentifiedObject.nameMatches((IdentifiedObject)object2, object1.getName().getCode());
        }
        return false;
    }

    private static boolean containsIgnoreMetadata(List<SingleCRS> container, List<SingleCRS> candidates) {
        block0: for (SingleCRS crs : candidates) {
            for (SingleCRS c : container) {
                if (!CRS.equalsIgnoreMetadata(crs, c)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    private final Set<CoordinateOperation> tryDB(SingleCRS sourceCRS, SingleCRS targetCRS, int limit) {
        if (sourceCRS == targetCRS) {
            return Collections.emptySet();
        }
        return this.findFromDatabase(sourceCRS, targetCRS, limit);
    }

    protected CoordinateOperation createFromDatabase(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        return null;
    }

    protected Set<CoordinateOperation> findFromDatabase(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, int limit) {
        return Collections.emptySet();
    }

    private static final class TemporaryDatum
    extends DefaultGeodeticDatum {
        private static final long serialVersionUID = -8964199103509187219L;
        private final GeodeticDatum datum;

        public TemporaryDatum(GeodeticDatum datum) {
            super(AbstractCoordinateOperationFactory.getTemporaryName(datum), datum.getEllipsoid(), (PrimeMeridian)DefaultPrimeMeridian.GREENWICH);
            this.datum = datum;
        }

        public static GeodeticDatum unwrap(GeodeticDatum datum) {
            while (datum instanceof TemporaryDatum) {
                datum = ((TemporaryDatum)datum).datum;
            }
            return datum;
        }

        @Override
        public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
            if (super.equals(object, compareMetadata)) {
                GeodeticDatum other = ((TemporaryDatum)object).datum;
                return compareMetadata ? this.datum.equals(other) : CRS.equalsIgnoreMetadata(this.datum, other);
            }
            return false;
        }
    }
}

