/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

class PerceptualDiff {
    static final Logger LOGGER = Logging.getLogger(PerceptualDiff.class);
    static boolean AVAILABLE;

    PerceptualDiff() {
    }

    public static Difference compareImages(File image1, File image2, int threshold) {
        if (!AVAILABLE) {
            LOGGER.severe("perceptualdiff is not available, can't compare " + image1 + " with image2");
            return new Difference(false, "Perceptual diff not available...");
        }
        try {
            String result;
            ArrayList<String> args = new ArrayList<String>();
            args.add("perceptualdiff");
            args.add(image1.getAbsolutePath());
            args.add(image2.getAbsolutePath());
            args.add("-verbose");
            args.add("-fov");
            args.add("89.9");
            if (threshold > 0) {
                args.add("-threshold");
                args.add(String.valueOf(threshold));
            }
            if ((result = PerceptualDiff.run(args)).contains("PASS")) {
                return new Difference(false, result);
            }
            return new Difference(true, result);
        }
        catch (Exception e) {
            throw new RuntimeException("PerceptualDiff call failed!!", e);
        }
    }

    static String run(List<String> cmd) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder(cmd);
        StringBuilder sb = new StringBuilder();
        builder.redirectErrorStream(true);
        Process p = builder.start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (sb == null) continue;
                sb.append("\n");
                sb.append(line);
            }
            p.waitFor();
        }
        return sb.toString();
    }

    static {
        if (Boolean.getBoolean("org.geotools.image.test.enabled")) {
            try {
                String result = PerceptualDiff.run(Arrays.asList("perceptualdiff"));
                AVAILABLE = result.contains("PerceptualDiff");
            }
            catch (Exception e) {
                AVAILABLE = false;
            }
        } else {
            AVAILABLE = false;
        }
    }

    static class Difference {
        boolean imagesDifferent;
        String output;

        public Difference(boolean different, String output) {
            this.imagesDifferent = different;
            this.output = output;
        }
    }
}

