/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Objects;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.IllegalFilterException;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;

public class NullFilterImpl
extends AbstractFilter
implements PropertyIsNull {
    private Expression nullCheck = null;

    protected NullFilterImpl(Expression expresion) {
        this.setExpression(expresion);
    }

    @Override
    public Expression getExpression() {
        return this.nullCheck;
    }

    public void setExpression(Expression nullCheck) {
        if (nullCheck == null) {
            throw new IllegalFilterException("Expression required");
        }
        this.nullCheck = nullCheck;
    }

    @Override
    public boolean evaluate(Object feature) {
        if (this.nullCheck == null) {
            return false;
        }
        return this.nullCheck.evaluate(feature) == null;
    }

    public String toString() {
        return "[ " + this.nullCheck.toString() + " is null ]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullFilterImpl that = (NullFilterImpl)o;
        return Objects.equals(this.nullCheck, that.nullCheck);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.nullCheck == null ? 0 : this.nullCheck.hashCode());
        return result;
    }

    @Override
    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit(this, extraData);
    }
}

