/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.piecewise;

import it.geosolutions.jaiext.piecewise.DefaultPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.MathTransformation;
import it.geosolutions.jaiext.piecewise.PiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.PiecewiseUtilities;
import it.geosolutions.jaiext.piecewise.SingleDimensionTransformation;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;

public class DefaultLinearPiecewiseTransform1DElement
extends DefaultPiecewiseTransform1DElement
implements PiecewiseTransform1DElement {
    private static final long serialVersionUID = 4026834241134908025L;
    private double outputMaximum;
    private double outputMinimum;
    private Range outputRange;
    private boolean outputMinimumNaN;
    private boolean outputMaximumNaN;
    private boolean outputMinimumInfinite;
    private boolean outputMaximumInfinite;

    public DefaultLinearPiecewiseTransform1DElement(CharSequence name, Range inRange, Range outRange) {
        super(name, inRange);
        this.outputRange = RangeFactory.convertToDoubleRange(outRange);
        Class<? extends Number> type = outRange.getDataType().getClassValue();
        boolean minInc = outRange.isMinIncluded();
        boolean maxInc = outRange.isMaxIncluded();
        this.outputMinimum = PiecewiseUtilities.doubleValue(type, outRange.getMin(), minInc ? 0 : 1);
        this.outputMaximum = PiecewiseUtilities.doubleValue(type, outRange.getMax(), maxInc ? 0 : -1);
        this.outputMinimumNaN = Double.isNaN(this.outputMinimum);
        this.outputMaximumNaN = Double.isNaN(this.outputMaximum);
        this.outputMinimumInfinite = Double.isInfinite(this.outputMinimum);
        this.outputMaximumInfinite = Double.isInfinite(this.outputMaximum);
        if (this.outputMinimumInfinite || this.outputMaximumInfinite) {
            throw new IllegalArgumentException("Bad range defined");
        }
        int compareOutBounds = PiecewiseUtilities.compare(this.outputMinimum, this.outputMaximum);
        if (compareOutBounds > 0) {
            throw new IllegalArgumentException("Bad range defined");
        }
        if (this.isInputMaximumNaN() && this.isInputMinimumNaN()) {
            if (compareOutBounds == 0) {
                this.setTransform(SingleDimensionTransformation.create(0.0, this.outputMinimum));
                this.setInverse(SingleDimensionTransformation.create(this.outputMinimum, 0.0));
                return;
            }
            throw new IllegalArgumentException("Bad range defined");
        }
        if (this.isInputMaximumInfinite() || this.isInputMinimumInfinite()) {
            if (compareOutBounds == 0) {
                this.setTransform(PiecewiseUtilities.createLinearTransform1D(0.0, this.outputMinimum));
                this.setInverse(null);
                return;
            }
            throw new IllegalArgumentException("Bad range defined");
        }
        MathTransformation transform = PiecewiseUtilities.createLinearTransform1D(inRange, RangeFactory.create(this.outputMinimum, true, this.outputMaximum, true, true));
        this.setTransform(transform);
        assert (transform instanceof SingleDimensionTransformation);
        assert (!Double.isNaN(((SingleDimensionTransformation)transform).getScale()) && !Double.isInfinite(((SingleDimensionTransformation)transform).getScale()));
        SingleDimensionTransformation tempTransform = (SingleDimensionTransformation)transform;
        double scale = tempTransform.getScale();
        if (Math.abs(scale) < 1.0E-6) {
            if (PiecewiseUtilities.compare(this.getInputMaximum(), this.getInputMinimum()) == 0) {
                this.setInverse(SingleDimensionTransformation.create(0.0, this.getInputMinimum()));
            } else {
                this.setInverse(null);
            }
        } else {
            this.setInverse(transform.inverseTransform());
        }
    }

    public double getOutputMaximum() {
        return this.outputMaximum;
    }

    public double getOutputMinimum() {
        return this.outputMinimum;
    }

    public Range getOutputRange() {
        return this.outputRange;
    }

    public boolean isOutputMinimumNaN() {
        return this.outputMinimumNaN;
    }

    public boolean isOutputMaximumNaN() {
        return this.outputMaximumNaN;
    }

    public boolean isOutputMinimumInfinite() {
        return this.outputMinimumInfinite;
    }

    public boolean isOutputMaximumInfinite() {
        return this.outputMaximumInfinite;
    }

    public double getScale() {
        SingleDimensionTransformation transform = (SingleDimensionTransformation)this.getTransform();
        return transform.getScale();
    }

    public double getOffset() {
        SingleDimensionTransformation transform = (SingleDimensionTransformation)this.getTransform();
        return transform.getOffset();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append("\n").append("output range=").append(this.outputRange);
        return buffer.toString();
    }

    @Override
    protected Class<?> getEquivalenceClass() {
        return DefaultLinearPiecewiseTransform1DElement.class;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultLinearPiecewiseTransform1DElement)) {
            return false;
        }
        DefaultLinearPiecewiseTransform1DElement that = (DefaultLinearPiecewiseTransform1DElement)obj;
        if (that.getEquivalenceClass() != this.getEquivalenceClass()) {
            return false;
        }
        if (!this.outputRange.equals(that.outputRange)) {
            return false;
        }
        if (!PiecewiseUtilities.equals(this.outputMaximum, that.outputMaximum)) {
            return false;
        }
        if (!PiecewiseUtilities.equals(this.outputMinimum, that.outputMinimum)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hashCode = 37;
        hashCode = PiecewiseUtilities.hash(this.outputRange, hashCode);
        hashCode = PiecewiseUtilities.hash(this.outputMaximum, hashCode);
        hashCode = PiecewiseUtilities.hash(this.outputMinimum, hashCode);
        hashCode = PiecewiseUtilities.hash(super.hashCode(), hashCode);
        return hashCode;
    }
}

