/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

public class TileRange
implements Comparable<TileRange> {
    private final long start;
    private final long end;
    private final long byteLength;
    private final int index;

    public TileRange(int index, long start, long byteLength) {
        this.index = index;
        this.start = start;
        this.byteLength = byteLength;
        this.end = start + byteLength - 1L;
    }

    public int getIndex() {
        return this.index;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getByteLength() {
        return this.byteLength;
    }

    public String toString() {
        return "index: " + this.index + " - start: " + this.start + " - byteLength: " + this.byteLength + " - end: " + this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TileRange that = (TileRange)o;
        return this.index == that.index && this.start == that.start && this.byteLength == that.byteLength && this.end == that.end;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)this.start;
        result = 31 * result + (int)this.byteLength;
        result = 31 * result + (int)this.end;
        result = 31 * result + this.index;
        return result;
    }

    @Override
    public int compareTo(TileRange o) {
        return o.index > this.index ? 1 : 0;
    }
}

