/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.triangulate;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.util.Memory;
import org.locationtech.jts.util.Stopwatch;

public class DelaunayPerfTest {
    static final GeometryFactory geomFact = new GeometryFactory();
    static final double SIDE_LEN = 10.0;

    public static void main(String[] args) {
        DelaunayPerfTest test = new DelaunayPerfTest();
        test.run();
    }

    public void run() {
        this.run(10);
        this.run(10);
        this.run(100);
        this.run(1000);
        this.run(10000);
        this.run(20000);
        this.run(30000);
        this.run(100000);
        this.run(200000);
        this.run(300000);
        this.run(1000000);
        this.run(3000000);
    }

    public void run(int nPts) {
        List pts = this.randomPoints(nPts);
        System.out.println("# pts: " + pts.size());
        Stopwatch sw = new Stopwatch();
        DelaunayTriangulationBuilder builder = new DelaunayTriangulationBuilder();
        builder.setSites(pts);
        builder.getSubdivision();
        System.out.println("  --  Time: " + sw.getTimeString() + "  Mem: " + Memory.usedTotalString());
    }

    List randomPointsInGrid(int nPts) {
        ArrayList<Coordinate> pts = new ArrayList<Coordinate>();
        int nSide = (int)Math.sqrt(nPts) + 1;
        for (int i = 0; i < nSide; ++i) {
            for (int j = 0; j < nSide; ++j) {
                double x = (double)i * 10.0 + 10.0 * Math.random();
                double y = (double)j * 10.0 + 10.0 * Math.random();
                pts.add(new Coordinate(x, y));
            }
        }
        return pts;
    }

    List randomPoints(int nPts) {
        ArrayList<Coordinate> pts = new ArrayList<Coordinate>();
        for (int i = 0; i < nPts; ++i) {
            double x = 10.0 * Math.random();
            double y = 10.0 * Math.random();
            pts.add(new Coordinate(x, y));
        }
        return pts;
    }
}

