/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm.distance;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class DiscreteFrechetDistanceSimple {
    private final Geometry g0;
    private final Geometry g1;
    private final boolean getCoordinates;

    public static double distance(Geometry g0, Geometry g1) {
        DiscreteFrechetDistanceSimple dist = new DiscreteFrechetDistanceSimple(g0, g1, false);
        return dist.distance();
    }

    public static double distance(Geometry g0, Geometry g1, boolean getCoordinates) {
        DiscreteFrechetDistanceSimple dist = new DiscreteFrechetDistanceSimple(g0, g1, getCoordinates);
        return dist.distance();
    }

    private DiscreteFrechetDistanceSimple(Geometry g0, Geometry g1, boolean getCoordinates) {
        this.g0 = g0;
        this.g1 = g1;
        this.getCoordinates = getCoordinates;
    }

    public double distance() {
        int i;
        Coordinate[] coords0 = this.g0.getCoordinates();
        Coordinate[] coords1 = this.g1.getCoordinates();
        double[][] distances = new double[coords0.length][];
        for (i = 0; i < coords0.length; ++i) {
            distances[i] = new double[coords1.length];
        }
        for (i = 0; i < coords0.length; ++i) {
            for (int j = 0; j < coords1.length; ++j) {
                double distance = coords0[i].distance(coords1[j]);
                distances[i][j] = i > 0 && j > 0 ? Math.max(Math.min(Math.min(distances[i - 1][j], distances[i - 1][j - 1]), distances[i][j - 1]), distance) : (i > 0 ? Math.max(distances[i - 1][0], distance) : (j > 0 ? Math.max(distances[0][j - 1], distance) : distance));
            }
        }
        return distances[coords0.length - 1][coords1.length - 1];
    }
}

