/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import org.locationtech.jts.algorithm.RectangleLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.util.Stopwatch;
import test.jts.perf.algorithm.SimpleRectangleIntersector;

public class RectangleLineIntersectorPerfTest {
    private GeometryFactory geomFact = new GeometryFactory();
    private double baseX = 0.0;
    private double baseY = 0.0;
    private double rectSize = 100.0;
    private int numPts = 1000;
    private Envelope rectEnv;
    private Coordinate[] pts;

    public static void main(String[] args) {
        RectangleLineIntersectorPerfTest test = new RectangleLineIntersectorPerfTest();
        test.runBoth(5);
        test.runBoth(30);
        test.runBoth(30);
        test.runBoth(100);
        test.runBoth(300);
        test.runBoth(600);
        test.runBoth(1000);
        test.runBoth(6000);
    }

    public void init(int nPts) {
        this.rectEnv = this.createRectangle();
        this.pts = this.createTestPoints(nPts);
    }

    public void runBoth(int nPts) {
        this.init(nPts);
        this.run(true, false);
        this.run(false, true);
    }

    public void run(boolean useSegInt, boolean useSideInt) {
        if (useSegInt) {
            System.out.println("Using Segment Intersector");
        }
        if (useSideInt) {
            System.out.println("Using Side Intersector");
        }
        System.out.println("# pts: " + this.pts.length);
        RectangleLineIntersector rectSegIntersector = new RectangleLineIntersector(this.rectEnv);
        SimpleRectangleIntersector rectSideIntersector = new SimpleRectangleIntersector(this.rectEnv);
        Stopwatch sw = new Stopwatch();
        for (int i = 0; i < this.pts.length; ++i) {
            for (int j = 0; j < this.pts.length; ++j) {
                if (i == j) continue;
                boolean segResult = false;
                if (useSegInt) {
                    segResult = rectSegIntersector.intersects(this.pts[i], this.pts[j]);
                }
                boolean sideResult = false;
                if (useSideInt) {
                    sideResult = rectSideIntersector.intersects(this.pts[i], this.pts[j]);
                }
                if (!useSegInt || !useSideInt || segResult == sideResult) continue;
                throw new IllegalStateException("Seg and Side values do not match");
            }
        }
        System.out.println("Finished in " + sw.getTimeString());
        System.out.println();
    }

    private Coordinate[] createTestPoints(int nPts) {
        Point pt = this.geomFact.createPoint(new Coordinate(this.baseX, this.baseY));
        Geometry circle = pt.buffer(2.0 * this.rectSize, nPts / 4);
        return circle.getCoordinates();
    }

    private Envelope createRectangle() {
        Envelope rectEnv = new Envelope(new Coordinate(this.baseX, this.baseY), new Coordinate(this.baseX + this.rectSize, this.baseY + this.rectSize));
        return rectEnv;
    }
}

