/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import java.util.List;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.index.chain.MonotoneChain;
import org.locationtech.jts.index.chain.MonotoneChainSelectAction;
import test.jts.perf.algorithm.MCIndexedGeometry;

public class MCIndexedPointInAreaLocator
implements PointOnGeometryLocator {
    private Geometry areaGeom;
    private MCIndexedGeometry index;
    private double maxXExtent;

    public MCIndexedPointInAreaLocator(Geometry g) {
        this.areaGeom = g;
        if (!(g instanceof Polygonal)) {
            throw new IllegalArgumentException("Argument must be Polygonal");
        }
        this.buildIndex(g);
        Envelope env = g.getEnvelopeInternal();
        this.maxXExtent = env.getMaxX() + 1.0;
    }

    private void buildIndex(Geometry g) {
        this.index = new MCIndexedGeometry(g);
    }

    @Override
    public int locate(Coordinate p) {
        RayCrossingCounter rcc = new RayCrossingCounter(p);
        MCSegmentCounter mcSegCounter = new MCSegmentCounter(rcc);
        Envelope rayEnv = new Envelope(p.x, this.maxXExtent, p.y, p.y);
        List mcs = this.index.query(rayEnv);
        this.countSegs(rcc, rayEnv, mcs, mcSegCounter);
        return rcc.getLocation();
    }

    private void countSegs(RayCrossingCounter rcc, Envelope rayEnv, List monoChains, MCSegmentCounter mcSegCounter) {
        for (MonotoneChain mc : monoChains) {
            mc.select(rayEnv, mcSegCounter);
            if (!rcc.isOnSegment()) continue;
            return;
        }
    }

    static class MCSegmentCounter
    extends MonotoneChainSelectAction {
        RayCrossingCounter rcc;

        public MCSegmentCounter(RayCrossingCounter rcc) {
            this.rcc = rcc;
        }

        @Override
        public void select(LineSegment ls) {
            this.rcc.countSegment(ls.getCoordinate(0), ls.getCoordinate(1));
        }
    }
}

