/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.algorithm;

import org.locationtech.jts.algorithm.InteriorPointArea;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.SineStarFactory;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import test.jts.perf.PerformanceTestCase;
import test.jts.perf.PerformanceTestRunner;

public class InteriorPointAreaPerfTest
extends PerformanceTestCase {
    private static final int N_ITER = 100;
    static double ORG_X = 100.0;
    static double ORG_Y = 100.0;
    static double SIZE = 100.0;
    static int N_ARMS = 20;
    static double ARM_RATIO = 0.3;
    private Geometry sineStar;
    private Geometry sinePolyCrinkly;
    private int iter = 0;

    public static void main(String[] args) {
        PerformanceTestRunner.run(InteriorPointAreaPerfTest.class);
    }

    public InteriorPointAreaPerfTest(String name) {
        super(name);
        this.setRunSize(new int[]{10, 100, 1000, 10000, 100000, 1000000});
        this.setRunIterations(100);
    }

    @Override
    public void setUp() {
        System.out.println("Interior Point Area perf test");
        System.out.println("SineStar: origin: (" + ORG_X + ", " + ORG_Y + ")  size: " + SIZE + "  # arms: " + N_ARMS + "  arm ratio: " + ARM_RATIO);
        System.out.println("# Iterations: 100");
    }

    @Override
    public void startRun(int npts) {
        this.iter = 0;
        this.sineStar = SineStarFactory.create(new Coordinate(ORG_X, ORG_Y), SIZE, npts, N_ARMS, ARM_RATIO);
        double scale = (double)npts / SIZE;
        PrecisionModel pm = new PrecisionModel(scale);
        this.sinePolyCrinkly = GeometryPrecisionReducer.reduce(this.sineStar, pm);
        System.out.println("\nRunning with # pts " + this.sinePolyCrinkly.getNumPoints());
    }

    public void runTest1() {
        InteriorPointArea.getInteriorPoint(this.sinePolyCrinkly);
    }
}

