/*
 * Decompiled with CFR 0.152.
 */
package test.jts.fail.overlayng;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.IntStream;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;

public class Issue784
extends TestCase {
    private GeometryFactory gf = new GeometryFactory();
    private Function<double[][], Polygon> createPolygon = points -> this.gf.createPolygon((Coordinate[])IntStream.range(0, points[0].length).mapToObj(index -> new CoordinateXY(points[0][index], points[1][index])).toArray(CoordinateXY[]::new));
    Polygon p1 = this.createPolygon.apply(new double[][]{{-16.15907384118054, -16.28767148661218, -13.719459554848422, -13.639456293556348, -16.15907384118054}, {1.0157206673651495, 7.6835050482212575, 5.212481574525698, 1.0643148816523527, 1.0157206673651495}});
    Polygon p2 = this.createPolygon.apply(new double[][]{{-12.725226307666448, -13.639456293556348, -13.719459768757051, -12.78759751645274, -12.725226307666448}, {1.0819470369308437, 1.0643148816523527, 5.212481780339414, 4.315883851167196, 1.0819470369308437}});
    Polygon p3 = this.createPolygon.apply(new double[][]{{-13.621824029083443, -16.14144162383529, -16.15907384118054, -13.639456293556348, -13.621824029083443}, {0.15008489786842003, 0.10149068267229658, 1.0157206673651493, 1.0643148816523527, 0.15008489786842003}});
    Polygon p3r = this.createPolygon.apply(new double[][]{{-13.621824029083443, -16.14144162383529, -16.15907384118054, -13.639456293556348, -13.621824029083443}, {0.15008489786842, 0.10149068267229658, 1.0157206673651493, 1.0643148816523527, 0.15008489786842}});
    Polygon p4 = this.createPolygon.apply(new double[][]{{-17.219533690879903, -16.28767148661218, -16.15907384118054, -17.073303827070436, -17.219533690879903}, {8.580102931174729, 7.683505048221257, 1.0157206673651495, 0.9980885120866584, 8.580102931174729}});
    Polygon p5 = this.createPolygon.apply(new double[][]{{-12.707594043193543, -13.621824029083443, -13.639456293556348, -12.725226307666448, -12.707594043193543}, {0.1677170531469111, 0.15008489786842005, 1.0643148816523527, 1.0819470369308437, 0.1677170531469111}});
    Polygon p6 = this.createPolygon.apply(new double[][]{{-17.055671609725188, -17.073303827070436, -16.15907384118054, -16.14144162383529, -17.055671609725188}, {0.0838585273938056, 0.9980885120866584, 1.0157206673651493, 0.1014906826722966, 0.0838585273938056}});

    public static void main(String[] args) {
        TestRunner.run(Issue784.class);
    }

    public void testUnion_p3p5() throws ParseException {
        this.checkUnion("35 - p3 Full", this.p3, this.p5);
    }

    @Test
    public void xtestUnionOriginal() throws ParseException {
        Polygon expectedUnion = (Polygon)new WKTReader().read("POLYGON ((-17.055671609725188 0.0838585273938056, -17.219533690879903 8.580102931174729, -12.78759751645274 4.315883851167196, -12.707594043193543 0.1677170531469111, -17.055671609725188 0.0838585273938056))");
        Geometry[] polygons = new Polygon[]{this.p1, this.p2, this.p3, this.p4, this.p5, this.p6};
        GeometryCollection gc = this.gf.createGeometryCollection(polygons);
        System.out.println(gc);
        Geometry gcUnion = gc.union();
        System.out.println(gcUnion);
        Geometry mpUnion = this.gf.createMultiPolygon((Polygon[])polygons).union();
        Geometry indUnion = Arrays.stream(polygons).map(Geometry.class::cast).reduce(Geometry::union).orElseThrow(null);
        Issue784.assertEquals((double)expectedUnion.getArea(), (double)gcUnion.getArea(), (double)1.0E-4);
        Issue784.assertEquals((double)expectedUnion.getArea(), (double)mpUnion.getArea(), (double)1.0E-4);
        Issue784.assertEquals((double)expectedUnion.getArea(), (double)indUnion.getArea(), (double)1.0E-4);
    }

    public void xtestUnion_p2p3p5() throws ParseException {
        this.checkUnion("235 - p3 Rounded", this.p2, this.p3r, this.p5);
        this.checkUnion("235 - p3 Full", this.p2, this.p3, this.p5);
    }

    private void checkUnion(String title, Polygon p2, Polygon p3, Polygon p5) {
        Geometry p25 = Issue784.union(p2, p5);
        Geometry pall = Issue784.union(p3, p25);
        double areaSum = p2.getArea() + p3.getArea() + p5.getArea();
        this.checkAreas(title, pall, areaSum);
    }

    private void checkUnion(String title, Polygon p1, Polygon p2) {
        Geometry pUnion = Issue784.union(p1, p2);
        double areaSum = p1.getArea() + p2.getArea();
        this.checkAreas(title, pUnion, areaSum);
    }

    private static Geometry union(Geometry a, Geometry b) {
        return OverlayNGRobust.overlay(a, b, 2);
    }

    private void checkAreas(String title, Geometry union, double areaSum) {
        boolean isOk = this.isAreasClose(union, areaSum);
        String status = isOk ? "Success" : "FAILED!";
        System.out.println(title + " - Union status: " + status);
        Issue784.assertTrue((boolean)isOk);
    }

    private boolean isAreasClose(Geometry geom, double area) {
        double geomArea = geom.getArea();
        double areaDelta = Math.abs(geomArea - area);
        double deltaFrac = areaDelta / Math.max(geomArea, area);
        return deltaFrac < 0.1;
    }
}

