/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.shape.fractal;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.shape.fractal.MortonCode;

public class MortonCodeTest
extends TestCase {
    public MortonCodeTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(MortonCodeTest.class);
    }

    public void testSize() {
        MortonCodeTest.assertEquals((int)MortonCode.size(0), (int)1);
        MortonCodeTest.assertEquals((int)MortonCode.size(1), (int)4);
        MortonCodeTest.assertEquals((int)MortonCode.size(2), (int)16);
        MortonCodeTest.assertEquals((int)MortonCode.size(3), (int)64);
        MortonCodeTest.assertEquals((int)MortonCode.size(4), (int)256);
        MortonCodeTest.assertEquals((int)MortonCode.size(5), (int)1024);
        MortonCodeTest.assertEquals((int)MortonCode.size(6), (int)4096);
    }

    public void testLevel() {
        MortonCodeTest.assertEquals((int)MortonCode.level(1), (int)0);
        MortonCodeTest.assertEquals((int)MortonCode.level(2), (int)1);
        MortonCodeTest.assertEquals((int)MortonCode.level(3), (int)1);
        MortonCodeTest.assertEquals((int)MortonCode.level(4), (int)1);
        MortonCodeTest.assertEquals((int)MortonCode.level(5), (int)2);
        MortonCodeTest.assertEquals((int)MortonCode.level(13), (int)2);
        MortonCodeTest.assertEquals((int)MortonCode.level(15), (int)2);
        MortonCodeTest.assertEquals((int)MortonCode.level(16), (int)2);
        MortonCodeTest.assertEquals((int)MortonCode.level(17), (int)3);
        MortonCodeTest.assertEquals((int)MortonCode.level(63), (int)3);
        MortonCodeTest.assertEquals((int)MortonCode.level(64), (int)3);
        MortonCodeTest.assertEquals((int)MortonCode.level(65), (int)4);
        MortonCodeTest.assertEquals((int)MortonCode.level(255), (int)4);
        MortonCodeTest.assertEquals((int)MortonCode.level(255), (int)4);
        MortonCodeTest.assertEquals((int)MortonCode.level(256), (int)4);
    }

    public void testDecode() {
        this.checkDecode(0, 0, 0);
        this.checkDecode(1, 1, 0);
        this.checkDecode(2, 0, 1);
        this.checkDecode(3, 1, 1);
        this.checkDecode(4, 2, 0);
        this.checkDecode(24, 4, 2);
        this.checkDecode(124, 14, 6);
        this.checkDecode(255, 15, 15);
    }

    public void testDecodeEncode() {
        this.checkDecodeEncodeForLevel(4);
        this.checkDecodeEncodeForLevel(5);
    }

    private void checkDecode(int index, int x, int y) {
        Coordinate p = MortonCode.decode(index);
        MortonCodeTest.assertEquals((int)((int)p.getX()), (int)x);
        MortonCodeTest.assertEquals((int)((int)p.getY()), (int)y);
    }

    private void checkDecodeEncodeForLevel(int level) {
        int n = MortonCode.size(level);
        for (int i = 0; i < n; ++i) {
            this.checkDecodeEncode(level, i);
        }
    }

    private void checkDecodeEncode(int level, int index) {
        Coordinate p = MortonCode.decode(index);
        int encode = MortonCode.encode((int)p.getX(), (int)p.getY());
        MortonCodeTest.assertEquals((int)index, (int)encode);
    }
}

