/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.overlayng.OverlayNGTest;
import test.jts.GeometryTestCase;

public class OverlayNGMixedPointsTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(OverlayNGMixedPointsTest.class);
    }

    public OverlayNGMixedPointsTest(String name) {
        super(name);
    }

    public void testSimpleLineIntersection() {
        Geometry a = this.read("LINESTRING (1 1, 9 1)");
        Geometry b = this.read("POINT (5 1)");
        Geometry expected = this.read("POINT (5 1)");
        this.checkEqual(expected, OverlayNGTest.intersection(a, b, 1.0));
    }

    public void testLinePointInOutIntersection() {
        Geometry a = this.read("LINESTRING (1 1, 9 1)");
        Geometry b = this.read("MULTIPOINT ((5 1), (15 1))");
        Geometry expected = this.read("POINT (5 1)");
        this.checkEqual(expected, OverlayNGTest.intersection(a, b, 1.0));
    }

    public void testSimpleLineUnion() {
        Geometry a = this.read("LINESTRING (1 1, 9 1)");
        Geometry b = this.read("POINT (5 1)");
        Geometry expected = this.read("LINESTRING (1 1, 9 1)");
        this.checkEqual(expected, OverlayNGTest.union(a, b, 1.0));
    }

    public void testSimpleLineDifference() {
        Geometry a = this.read("LINESTRING (1 1, 9 1)");
        Geometry b = this.read("POINT (5 1)");
        Geometry expected = this.read("LINESTRING (1 1, 9 1)");
        this.checkEqual(expected, OverlayNGTest.difference(a, b, 1.0));
    }

    public void testSimpleLineSymDifference() {
        Geometry a = this.read("LINESTRING (1 1, 9 1)");
        Geometry b = this.read("POINT (5 1)");
        Geometry expected = this.read("LINESTRING (1 1, 9 1)");
        this.checkEqual(expected, OverlayNGTest.symDifference(a, b, 1.0));
    }

    public void testLinePointSymDifference() {
        Geometry a = this.read("LINESTRING (1 1, 9 1)");
        Geometry b = this.read("POINT (15 1)");
        Geometry expected = this.read("GEOMETRYCOLLECTION (POINT (15 1), LINESTRING (1 1, 9 1))");
        this.checkEqual(expected, OverlayNGTest.symDifference(a, b, 1.0));
    }

    public void testPolygonInsideIntersection() {
        Geometry a = this.read("POLYGON ((4 2, 6 2, 6 0, 4 0, 4 2))");
        Geometry b = this.read("POINT (5 1)");
        Geometry expected = this.read("POINT (5 1)");
        this.checkEqual(expected, OverlayNGTest.intersection(a, b, 1.0));
    }

    public void testPolygonDisjointIntersection() {
        Geometry a = this.read("POLYGON ((4 2, 6 2, 6 0, 4 0, 4 2))");
        Geometry b = this.read("POINT (15 1)");
        Geometry expected = this.read("POINT EMPTY");
        this.checkEqual(expected, OverlayNGTest.intersection(a, b, 1.0));
    }

    public void testPointEmptyLinestringUnion() {
        Geometry a = this.read("LINESTRING EMPTY");
        Geometry b = this.read("POINT (10 10)");
        Geometry expected = this.read("POINT (10 10)");
        Geometry actual = OverlayNGTest.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void testLinestringEmptyPointUnion() {
        Geometry a = this.read("LINESTRING (10 10, 20 20)");
        Geometry b = this.read("POINT EMPTY");
        Geometry expected = this.read("LINESTRING (10 10, 20 20)");
        Geometry actual = OverlayNGTest.union(a, b, 1.0);
        this.checkEqual(expected, actual);
    }

    public void testPointLineIntersectionPrec() {
        Geometry a = this.read("POINT (10.1 10.4)");
        Geometry b = this.read("LINESTRING (9.6 10, 20.1 19.6)");
        Geometry expected = this.read("POINT EMPTY");
        this.checkEqual(expected, OverlayNGTest.intersection(a, b, 1.0));
    }
}

