/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.operation.overlayng.OverlayNG;
import test.jts.GeometryTestCase;

public class OverlayNGFloatingNoderTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(OverlayNGFloatingNoderTest.class);
    }

    public OverlayNGFloatingNoderTest(String name) {
        super(name);
    }

    public void testTriangleIntersection() {
        Geometry a = this.read("POLYGON ((0 0, 8 0, 8 3, 0 0))");
        Geometry b = this.read("POLYGON ((0 5, 5 0, 0 0, 0 5))");
        Geometry expected = this.read("POLYGON ((0 0, 3.6363636363636367 1.3636363636363638, 5 0, 0 0))");
        Geometry actual = OverlayNGFloatingNoderTest.intersection(a, b);
        this.checkEqual(expected, actual, 1.0E-10);
    }

    public void testPolygonWithRepeatedPointIntersection() {
        Geometry b;
        Geometry a = this.read("POLYGON ((1231646.6575 1042601.8724999996, 1231646.6575 1042601.8724999996, 1231646.6575 1042601.8724999996, 1231646.6575 1042601.8724999996, 1231646.6575 1042601.8724999996, 1231646.6575 1042601.8724999996, 1231646.6575 1042601.8724999996, 1231646.6575 1042601.8724999996, 1231647.72 1042600.4349999996, 1231653.22 1042592.1849999996, 1231665.14087406 1042572.5988970799, 1231595.8411746 1042545.58898314, 1231595.26811297 1042580.9672385901, 1231595.2825 1042582.8724999996, 1231646.6575 1042601.8724999996))");
        Geometry actual = OverlayNGFloatingNoderTest.intersection(a, b = this.read("POLYGON ((1231665.14087406 1042572.5988970799, 1231665.14087406 1042572.5988970799, 1231665.14087406 1042572.5988970799, 1231665.14087406 1042572.5988970799, 1231665.14087406 1042572.5988970799, 1231665.14087406 1042572.5988970799, 1231665.14087406 1042572.5988970799, 1231665.14087406 1042572.5988970799, 1231666.51617512 1042570.3392651202, 1231677.47 1042558.9349999996, 1231685.50958834 1042553.8506523697, 1231603.31532446 1042524.6022436405, 1231603.31532446 1042524.6022436405, 1231603.31532446 1042524.6022436405, 1231603.31532446 1042524.6022436405, 1231596.4075 1042522.1849999996, 1231585.07346906 1042541.8167165304, 1231586.62051091 1042542.3586940402, 1231586.62051091 1042542.3586940402, 1231595.8411746 1042545.58898314, 1231665.14087406 1042572.5988970799))"));
        boolean isCorrect = actual.getArea() < 1.0;
        OverlayNGFloatingNoderTest.assertTrue((String)"Area of intersection result area is too large", (boolean)isCorrect);
    }

    public void testPolygonWithRepeatedPointIntersectionSimple() {
        Geometry a = this.read("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 151, 100 151, 100 151, 100 151, 100 200))");
        Geometry b = this.read("POLYGON ((300 200, 300 100, 200 100, 200 200, 200 200, 300 200))");
        Geometry expected = this.read("LINESTRING (200 200, 200 100)");
        Geometry actual = OverlayNGFloatingNoderTest.intersection(a, b);
        this.checkEqual(expected, actual, 1.0E-10);
    }

    public void testLineWithRepeatedPointIntersection() {
        Geometry a = this.read("LINESTRING (100 100, 200 200, 200 200, 200 200, 200 200, 300 300, 400 200)");
        Geometry b = this.read("LINESTRING (190 110, 120 180)");
        Geometry expected = this.read("POINT (150 150)");
        Geometry actual = OverlayNGFloatingNoderTest.intersection(a, b);
        this.checkEqual(expected, actual, 1.0E-10);
    }

    public void testNarrowBoxesLineIntersection() {
        Geometry a = this.read("LINESTRING (832864.275023695 0, 835092.849076364 0)");
        Geometry b = this.read("MULTIPOLYGON (((832864.275023695 0, 833978.556808034 -0.000110682755987, 833978.556808034 0, 833978.556808034 0.000110682755987, 832864.275023695 0, 832864.275023695 0)), ((835092.849076364 0, 833978.557030887 -0.000110682755987, 833978.557030887 0, 833978.557030887 0.000110682755987, 835092.849076364 0, 835092.849076364 0)))");
        Geometry expected = this.read("MULTILINESTRING ((833978.557030887 0, 835092.849076364 0), (832864.275023695 0, 833978.556808034 0))");
        Geometry actual = OverlayNGFloatingNoderTest.intersection(a, b);
        this.checkEqual(expected, actual, 1.0E-10);
    }

    public void xtestPolygonsWithClippingPerturbationIntersection() {
        Geometry b;
        Geometry a = this.read("POLYGON ((4373089.33 5521847.89, 4373092.24 5521851.6, 4373118.52 5521880.22, 4373137.58 5521896.63, 4373153.33 5521906.43, 4373270.51 5521735.67, 4373202.5 5521678.73, 4373100.1 5521827.97, 4373089.33 5521847.89))");
        double area = OverlayNGFloatingNoderTest.intersectionAreaExpectError(a, b = this.read("POLYGON ((4373225.587574724 5521801.132991467, 4373209.219497436 5521824.985294571, 4373355.5585138 5521943.53124194, 4373412.83157427 5521860.49206234, 4373412.577392304 5521858.140878815, 4373412.290476093 5521855.48690386, 4373374.245799139 5521822.532711867, 4373271.028377312 5521736.104060946, 4373225.587574724 5521801.132991467))"));
        boolean isCorrect = area < 1.0;
        OverlayNGFloatingNoderTest.assertTrue((String)"Area of intersection result area is too large", (boolean)isCorrect);
    }

    public void xtestPolygonsWithClippingPerturbation2Intersection() {
        Geometry b;
        Geometry a = this.read("POLYGON ((4379891.12 5470577.74, 4379875.16 5470581.54, 4379841.77 5470592.88, 4379787.53 5470612.89, 4379822.96 5470762.6, 4379873.52 5470976.3, 4379982.93 5470965.71, 4379936.91 5470771.25, 4379891.12 5470577.74))");
        double area = OverlayNGFloatingNoderTest.intersectionAreaExpectError(a, b = this.read("POLYGON ((4379894.528437099 5470592.144163859, 4379968.579210246 5470576.004727546, 4379965.600743549 5470563.403176092, 4379965.350009631 5470562.383524827, 4379917.641365346 5470571.523966022, 4379891.224959933 5470578.183564024, 4379894.528437099 5470592.144163859))"));
        boolean isCorrect = area < 1.0;
        OverlayNGFloatingNoderTest.assertTrue((String)"Area of intersection result area is too large", (boolean)isCorrect);
    }

    static double intersectionAreaExpectError(Geometry a, Geometry b) {
        try {
            Geometry result = OverlayNG.overlay(a, b, 1);
            return result.getArea();
        }
        catch (TopologyException topologyException) {
            return 0.0;
        }
    }

    static Geometry intersection(Geometry a, Geometry b) {
        return OverlayNG.overlay(a, b, 1);
    }
}

