/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.linemerge;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.linemerge.LineSequencer;

public class LineSequencerTest
extends TestCase {
    private static WKTReader rdr = new WKTReader();

    public LineSequencerTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(LineSequencerTest.class);
    }

    public void testSimple() throws Exception {
        String[] wkt = new String[]{"LINESTRING ( 0 0, 0 10 )", "LINESTRING ( 0 20, 0 30 )", "LINESTRING ( 0 10, 0 20 )"};
        String result = "MULTILINESTRING ((0 0, 0 10), (0 10, 0 20), (0 20, 0 30))";
        this.runLineSequencer(wkt, result);
    }

    public void testSimpleLoop() throws Exception {
        String[] wkt = new String[]{"LINESTRING ( 0 0, 0 10 )", "LINESTRING ( 0 10, 0 0 )"};
        String result = "MULTILINESTRING ((0 0, 0 10), (0 10, 0 0))";
        this.runLineSequencer(wkt, result);
    }

    public void testSimpleBigLoop() throws Exception {
        String[] wkt = new String[]{"LINESTRING ( 0 0, 0 10 )", "LINESTRING ( 0 20, 0 30 )", "LINESTRING ( 0 30, 0 00 )", "LINESTRING ( 0 10, 0 20 )"};
        String result = "MULTILINESTRING ((0 0, 0 10), (0 10, 0 20), (0 20, 0 30), (0 30, 0 0))";
        this.runLineSequencer(wkt, result);
    }

    public void test2SimpleLoops() throws Exception {
        String[] wkt = new String[]{"LINESTRING ( 0 0, 0 10 )", "LINESTRING ( 0 10, 0 0 )", "LINESTRING ( 0 0, 0 20 )", "LINESTRING ( 0 20, 0 0 )"};
        String result = "MULTILINESTRING ((0 10, 0 0), (0 0, 0 20), (0 20, 0 0), (0 0, 0 10))";
        this.runLineSequencer(wkt, result);
    }

    public void testWide8WithTail() throws Exception {
        String[] wkt = new String[]{"LINESTRING ( 0 0, 0 10 )", "LINESTRING ( 10 0, 10 10 )", "LINESTRING ( 0 0, 10 0 )", "LINESTRING ( 0 10, 10 10 )", "LINESTRING ( 0 10, 0 20 )", "LINESTRING ( 10 10, 10 20 )", "LINESTRING ( 0 20, 10 20 )", "LINESTRING ( 10 20, 30 30 )"};
        String result = null;
        this.runLineSequencer(wkt, result);
    }

    public void testSimpleLoopWithTail() throws Exception {
        String[] wkt = new String[]{"LINESTRING ( 0 0, 0 10 )", "LINESTRING ( 0 10, 10 10 )", "LINESTRING ( 10 10, 10 20, 0 10 )"};
        String result = "MULTILINESTRING ((0 0, 0 10), (0 10, 10 10), (10 10, 10 20, 0 10))";
        this.runLineSequencer(wkt, result);
    }

    public void testLineWithRing() throws Exception {
        String[] wkt = new String[]{"LINESTRING ( 0 0, 0 10 )", "LINESTRING ( 0 10, 10 10, 10 20, 0 10 )", "LINESTRING ( 0 30, 0 20 )", "LINESTRING ( 0 20, 0 10 )"};
        String result = "MULTILINESTRING ((0 0, 0 10), (0 10, 10 10, 10 20, 0 10), (0 10, 0 20), (0 20, 0 30))";
        this.runLineSequencer(wkt, result);
    }

    public void testMultipleGraphsWithRing() throws Exception {
        String[] wkt = new String[]{"LINESTRING ( 0 0, 0 10 )", "LINESTRING ( 0 10, 10 10, 10 20, 0 10 )", "LINESTRING ( 0 30, 0 20 )", "LINESTRING ( 0 20, 0 10 )", "LINESTRING ( 0 60, 0 50 )", "LINESTRING ( 0 40, 0 50 )"};
        String result = "MULTILINESTRING ((0 0, 0 10), (0 10, 10 10, 10 20, 0 10), (0 10, 0 20), (0 20, 0 30), (0 40, 0 50), (0 50, 0 60))";
        this.runLineSequencer(wkt, result);
    }

    public void testMultipleGraphsWithMultipeRings() throws Exception {
        String[] wkt = new String[]{"LINESTRING ( 0 0, 0 10 )", "LINESTRING ( 0 10, 10 10, 10 20, 0 10 )", "LINESTRING ( 0 10, 40 40, 40 20, 0 10 )", "LINESTRING ( 0 30, 0 20 )", "LINESTRING ( 0 20, 0 10 )", "LINESTRING ( 0 60, 0 50 )", "LINESTRING ( 0 40, 0 50 )"};
        String result = "MULTILINESTRING ((0 0, 0 10), (0 10, 40 40, 40 20, 0 10), (0 10, 10 10, 10 20, 0 10), (0 10, 0 20), (0 20, 0 30), (0 40, 0 50), (0 50, 0 60))";
        this.runLineSequencer(wkt, result);
    }

    public void testLineSequence() throws Exception {
        String wkt = "LINESTRING ( 0 0, 0 10 )";
        this.runIsSequenced(wkt, true);
    }

    public void testSplitLineSequence() throws Exception {
        String wkt = "MULTILINESTRING ((0 0, 0 1), (0 2, 0 3), (0 3, 0 4) )";
        this.runIsSequenced(wkt, true);
    }

    public void testBadLineSequence() throws Exception {
        String wkt = "MULTILINESTRING ((0 0, 0 1), (0 2, 0 3), (0 1, 0 4) )";
        this.runIsSequenced(wkt, false);
    }

    private void runLineSequencer(String[] inputWKT, String expectedWKT) throws ParseException {
        List inputGeoms = this.fromWKT(inputWKT);
        LineSequencer sequencer = new LineSequencer();
        sequencer.add(inputGeoms);
        boolean isCorrect = false;
        if (!sequencer.isSequenceable()) {
            LineSequencerTest.assertTrue((expectedWKT == null ? 1 : 0) != 0);
        } else {
            Geometry result;
            Geometry expected = rdr.read(expectedWKT);
            boolean isOK = expected.equalsNorm(result = sequencer.getSequencedLineStrings());
            if (!isOK) {
                System.out.println("ERROR - Expected: " + expected);
                System.out.println("          Actual: " + result);
            }
            LineSequencerTest.assertTrue((boolean)isOK);
            boolean isSequenced = LineSequencer.isSequenced(result);
            LineSequencerTest.assertTrue((boolean)isSequenced);
        }
    }

    private void runIsSequenced(String inputWKT, boolean expected) throws ParseException {
        Geometry g = rdr.read(inputWKT);
        boolean isSequenced = LineSequencer.isSequenced(g);
        LineSequencerTest.assertTrue((isSequenced == expected ? 1 : 0) != 0);
    }

    List fromWKT(String[] wkts) {
        ArrayList<Geometry> geomList = new ArrayList<Geometry>();
        for (int i = 0; i < wkts.length; ++i) {
            try {
                geomList.add(rdr.read(wkts[i]));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return geomList;
    }
}

