/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.locationtech.jts.io.Ordinate;
import org.locationtech.jts.io.WKTWriter;

public class WKTWriterTest
extends TestCase {
    PrecisionModel precisionModel = new PrecisionModel(1.0);
    GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTWriter writer = new WKTWriter();
    WKTWriter writer3D = new WKTWriter(3);
    WKTWriter writer2DM = new WKTWriter(3);

    public static void main(String[] args) {
        TestRunner.run((Test)WKTWriterTest.suite());
    }

    public WKTWriterTest(String name) {
        super(name);
        this.writer2DM.setOutputOrdinates(Ordinate.createXYM());
    }

    public static Test suite() {
        return new TestSuite(WKTWriterTest.class);
    }

    public void testProperties() {
        WKTWriterTest.assertEquals(Ordinate.createXY(), this.writer.getOutputOrdinates());
        WKTWriterTest.assertEquals(Ordinate.createXYZ(), this.writer3D.getOutputOrdinates());
        WKTWriterTest.assertEquals(Ordinate.createXYM(), this.writer2DM.getOutputOrdinates());
        GeometryFactory gf = new GeometryFactory(PackedCoordinateSequenceFactory.DOUBLE_FACTORY);
        WKTWriter writer3DM = new WKTWriter(4);
        WKTWriterTest.assertEquals(Ordinate.createXYZM(), writer3DM.getOutputOrdinates());
        writer3DM.setOutputOrdinates(Ordinate.createXY());
        WKTWriterTest.assertEquals(Ordinate.createXY(), writer3DM.getOutputOrdinates());
        writer3DM.setOutputOrdinates(Ordinate.createXYZ());
        WKTWriterTest.assertEquals(Ordinate.createXYZ(), writer3DM.getOutputOrdinates());
        writer3DM.setOutputOrdinates(Ordinate.createXYM());
        WKTWriterTest.assertEquals(Ordinate.createXYM(), this.writer2DM.getOutputOrdinates());
        writer3DM.setOutputOrdinates(Ordinate.createXYZM());
        WKTWriterTest.assertEquals(Ordinate.createXYZM(), writer3DM.getOutputOrdinates());
    }

    public void testWritePoint() {
        Point point = this.geometryFactory.createPoint(new Coordinate(10.0, 10.0));
        WKTWriterTest.assertEquals((String)"POINT (10 10)", (String)this.writer.write(point).toString());
    }

    public void testWriteLineString() {
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(10.0, 10.0, 0.0), new Coordinate(20.0, 20.0, 0.0), new Coordinate(30.0, 40.0, 0.0)};
        LineString lineString = this.geometryFactory.createLineString(coordinates);
        WKTWriterTest.assertEquals((String)"LINESTRING (10 10, 20 20, 30 40)", (String)this.writer.write(lineString).toString());
    }

    public void testWritePolygon() throws Exception {
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(10.0, 10.0, 0.0), new Coordinate(10.0, 20.0, 0.0), new Coordinate(20.0, 20.0, 0.0), new Coordinate(20.0, 15.0, 0.0), new Coordinate(10.0, 10.0, 0.0)};
        LinearRing linearRing = this.geometryFactory.createLinearRing(coordinates);
        Polygon polygon = this.geometryFactory.createPolygon(linearRing, new LinearRing[0]);
        WKTWriterTest.assertEquals((String)"POLYGON ((10 10, 10 20, 20 20, 20 15, 10 10))", (String)this.writer.write(polygon).toString());
    }

    public void testWriteMultiPoint() {
        Point[] points = new Point[]{this.geometryFactory.createPoint(new Coordinate(10.0, 10.0, 0.0)), this.geometryFactory.createPoint(new Coordinate(20.0, 20.0, 0.0))};
        MultiPoint multiPoint = this.geometryFactory.createMultiPoint(points);
        WKTWriterTest.assertEquals((String)"MULTIPOINT ((10 10), (20 20))", (String)this.writer.write(multiPoint).toString());
    }

    public void testWriteMultiLineString() {
        Coordinate[] coordinates1 = new Coordinate[]{new Coordinate(10.0, 10.0, 0.0), new Coordinate(20.0, 20.0, 0.0)};
        LineString lineString1 = this.geometryFactory.createLineString(coordinates1);
        Coordinate[] coordinates2 = new Coordinate[]{new Coordinate(15.0, 15.0, 0.0), new Coordinate(30.0, 15.0, 0.0)};
        LineString lineString2 = this.geometryFactory.createLineString(coordinates2);
        LineString[] lineStrings = new LineString[]{lineString1, lineString2};
        MultiLineString multiLineString = this.geometryFactory.createMultiLineString(lineStrings);
        WKTWriterTest.assertEquals((String)"MULTILINESTRING ((10 10, 20 20), (15 15, 30 15))", (String)this.writer.write(multiLineString).toString());
    }

    public void testWriteMultiPolygon() throws Exception {
        Coordinate[] coordinates1 = new Coordinate[]{new Coordinate(10.0, 10.0, 0.0), new Coordinate(10.0, 20.0, 0.0), new Coordinate(20.0, 20.0, 0.0), new Coordinate(20.0, 15.0, 0.0), new Coordinate(10.0, 10.0, 0.0)};
        LinearRing linearRing1 = this.geometryFactory.createLinearRing(coordinates1);
        Polygon polygon1 = this.geometryFactory.createPolygon(linearRing1, new LinearRing[0]);
        Coordinate[] coordinates2 = new Coordinate[]{new Coordinate(60.0, 60.0, 0.0), new Coordinate(70.0, 70.0, 0.0), new Coordinate(80.0, 60.0, 0.0), new Coordinate(60.0, 60.0, 0.0)};
        LinearRing linearRing2 = this.geometryFactory.createLinearRing(coordinates2);
        Polygon polygon2 = this.geometryFactory.createPolygon(linearRing2, new LinearRing[0]);
        Polygon[] polygons = new Polygon[]{polygon1, polygon2};
        MultiPolygon multiPolygon = this.geometryFactory.createMultiPolygon(polygons);
        WKTWriterTest.assertEquals((String)"MULTIPOLYGON (((10 10, 10 20, 20 20, 20 15, 10 10)), ((60 60, 70 70, 80 60, 60 60)))", (String)this.writer.write(multiPolygon).toString());
    }

    public void testWriteGeometryCollection() {
        Point point1 = this.geometryFactory.createPoint(new Coordinate(10.0, 10.0));
        Point point2 = this.geometryFactory.createPoint(new Coordinate(30.0, 30.0));
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(15.0, 15.0, 0.0), new Coordinate(20.0, 20.0, 0.0)};
        LineString lineString1 = this.geometryFactory.createLineString(coordinates);
        Geometry[] geometries = new Geometry[]{point1, point2, lineString1};
        GeometryCollection geometryCollection = this.geometryFactory.createGeometryCollection(geometries);
        WKTWriterTest.assertEquals((String)"GEOMETRYCOLLECTION (POINT (10 10), POINT (30 30), LINESTRING (15 15, 20 20))", (String)this.writer.write(geometryCollection).toString());
    }

    public void testWriteLargeNumbers1() {
        PrecisionModel precisionModel = new PrecisionModel(1.0E9);
        GeometryFactory geometryFactory = new GeometryFactory(precisionModel, 0);
        Point point1 = geometryFactory.createPoint(new Coordinate(1.2345678901234568E17, 1.0E10));
        WKTWriterTest.assertEquals((String)"POINT (123456789012345680 10000000000)", (String)point1.toText());
    }

    public void testWriteLargeNumbers2() {
        PrecisionModel precisionModel = new PrecisionModel(1.0E9);
        GeometryFactory geometryFactory = new GeometryFactory(precisionModel, 0);
        Point point1 = geometryFactory.createPoint(new Coordinate(1234.0, 1.0E10));
        WKTWriterTest.assertEquals((String)"POINT (1234 10000000000)", (String)point1.toText());
    }

    public void testWriteLargeNumbers3() {
        PrecisionModel precisionModel = new PrecisionModel(1.0E9);
        GeometryFactory geometryFactory = new GeometryFactory(precisionModel, 0);
        Point point1 = geometryFactory.createPoint(new Coordinate(1.2345678901234569E32, 1.0E10));
        WKTWriterTest.assertEquals((String)"POINT (123456789012345690000000000000000 10000000000)", (String)point1.toText());
    }

    public void testWrite3D() {
        GeometryFactory geometryFactory = new GeometryFactory();
        Point point = geometryFactory.createPoint(new Coordinate(1.0, 1.0, 1.0));
        String wkt = this.writer3D.write(point);
        WKTWriterTest.assertEquals((String)"POINT Z(1 1 1)", (String)wkt);
        wkt = this.writer2DM.write(point);
        WKTWriterTest.assertEquals((String)"POINT (1 1)", (String)wkt);
    }

    public void testWrite3D_withNaN() {
        GeometryFactory geometryFactory = new GeometryFactory();
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0, 2.0)};
        LineString line = geometryFactory.createLineString(coordinates);
        String wkt = this.writer3D.write(line);
        WKTWriterTest.assertEquals((String)"LINESTRING Z(1 1 NaN, 2 2 2)", (String)wkt);
        wkt = this.writer2DM.write(line);
        WKTWriterTest.assertEquals((String)"LINESTRING (1 1, 2 2)", (String)wkt);
    }
}

