/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import junit.textui.TestRunner;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import test.jts.GeometryTestCase;

public class WKTReaderFixStructureTest
extends GeometryTestCase {
    private WKTReader readerFix;
    private WKTReader reader = new WKTReader();

    public static void main(String[] args) {
        TestRunner.run(WKTReaderFixStructureTest.class);
    }

    public WKTReaderFixStructureTest(String name) {
        super(name);
        this.readerFix = new WKTReader();
        this.readerFix.setFixStructure(true);
    }

    public void testLineaStringShort() throws ParseException {
        this.checkFixStructure("LINESTRING (0 0)");
    }

    public void testLinearRingUnclosed() throws ParseException {
        this.checkFixStructure("LINEARRING (0 0, 0 1, 1 0)");
    }

    public void testLinearRingShort() throws ParseException {
        this.checkFixStructure("LINEARRING (0 0, 0 1)");
    }

    public void testPolygonShort() throws ParseException {
        this.checkFixStructure("POLYGON ((0 0))");
    }

    public void testPolygonUnclosed() throws ParseException {
        this.checkFixStructure("POLYGON ((0 0, 0 1, 1 0))");
    }

    public void testPolygonUnclosedHole() throws ParseException {
        this.checkFixStructure("POLYGON ((0 0, 0 10, 10 0, 0 0), (0 0, 1 0, 0 1))");
    }

    public void testCollection() throws ParseException {
        this.checkFixStructure("GEOMETRYCOLLECTION (LINESTRING (0 0), LINEARRING (0 0, 0 1), POLYGON ((0 0, 0 10, 10 0, 0 0), (0 0, 1 0, 0 1)) )");
    }

    private void checkFixStructure(String wkt) throws ParseException {
        this.checkHasBadStructure(wkt);
        this.checkFixed(wkt);
    }

    private void checkFixed(String wkt) throws ParseException {
        this.readerFix.read(wkt);
    }

    private void checkHasBadStructure(String wkt) throws ParseException {
        try {
            this.reader.read(wkt);
            WKTReaderFixStructureTest.fail((String)"Input does not have non-closed rings");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

