/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.strtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.strtree.GeometryDistanceComparator;
import org.locationtech.jts.index.strtree.GeometryItemDistance;
import org.locationtech.jts.index.strtree.STRtree;
import test.jts.GeometryTestCase;

public class STRtreeNearestNeighbourTest
extends GeometryTestCase {
    private static final String POINTS_B = "MULTIPOINT( 5 5, 15 15, 5 15, 15 5, 8 8)";
    private static final String POINTS_A = "MULTIPOINT( 0 0, 10 10, 0 10, 10 0, 9 9)";

    public STRtreeNearestNeighbourTest(String Name_) {
        super(Name_);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{STRtreeNearestNeighbourTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public void testNearestNeighboursEmpty() {
        STRtree tree = new STRtree();
        Object[] nn = tree.nearestNeighbour(new GeometryItemDistance());
        STRtreeNearestNeighbourTest.assertTrue((nn == null ? 1 : 0) != 0);
    }

    public void testNearestNeighboursTreesEmpty() {
        STRtree tree = new STRtree();
        STRtree tree2 = new STRtree();
        Object[] nn = tree.nearestNeighbour(tree2, new GeometryItemDistance());
        STRtreeNearestNeighbourTest.assertTrue((nn == null ? 1 : 0) != 0);
    }

    public void testNearestNeighbourEmpty() {
        STRtree tree = new STRtree();
        Geometry geom = this.read("POINT (1 1)");
        Object nn = tree.nearestNeighbour(geom.getEnvelopeInternal(), geom, new GeometryItemDistance());
        STRtreeNearestNeighbourTest.assertTrue((nn == null ? 1 : 0) != 0);
    }

    public void testNearestNeighbours() {
        this.checkNN(POINTS_A, "MULTIPOINT(9 9, 10 10)");
    }

    public void testNearestNeighbourSingleItem() {
        this.checkNN("POINT( 5 5 )", "POINT( 5 5 )");
    }

    public void testNearestNeighbours2() {
        this.checkNN(POINTS_A, POINTS_B, "POINT( 9 9 )", "POINT( 8 8 )");
    }

    public void testWithinDistance() {
        this.checkWithinDistance(POINTS_A, POINTS_B, 2.0, true);
        this.checkWithinDistance(POINTS_A, POINTS_B, 1.0, false);
    }

    public void testKNearestNeighborsEmpty() {
        STRtree tree = new STRtree();
        Geometry geom = this.read("POINT (1 1)");
        Object[] nn = tree.nearestNeighbour(geom.getEnvelopeInternal(), geom, new GeometryItemDistance(), 5);
        STRtreeNearestNeighbourTest.assertTrue((nn.length == 0 ? 1 : 0) != 0);
    }

    private void checkNN(String wktItems, String wktExpected) {
        Geometry items = this.read(wktItems);
        STRtree tree = this.createTree(items);
        Object[] nearest = tree.nearestNeighbour(new GeometryItemDistance());
        if (wktExpected == null) {
            STRtreeNearestNeighbourTest.assertTrue((nearest == null ? 1 : 0) != 0);
            return;
        }
        Geometry expected = this.read(wktExpected);
        boolean isFound = this.isEqualUnordered(nearest, expected.getGeometryN(0), expected.getGeometryN(1));
        STRtreeNearestNeighbourTest.assertTrue((boolean)isFound);
    }

    private void checkNN(String wktItems1, String wktItems2, String wktExpected1, String wktExpected2) {
        Geometry items1 = this.read(wktItems1);
        Geometry items2 = this.read(wktItems2);
        Geometry expected1 = this.read(wktExpected1);
        Geometry expected2 = this.read(wktExpected2);
        STRtree tree1 = this.createTree(items1);
        STRtree tree2 = this.createTree(items2);
        Object[] nearest = tree1.nearestNeighbour(tree2, new GeometryItemDistance());
        boolean isFound = this.isEqual(nearest, expected1, expected2);
        STRtreeNearestNeighbourTest.assertTrue((boolean)isFound);
    }

    private void checkWithinDistance(String wktItems1, String wktItems2, double distance, boolean expected) {
        Geometry items1 = this.read(wktItems1);
        Geometry items2 = this.read(wktItems2);
        STRtree tree1 = this.createTree(items1);
        STRtree tree2 = this.createTree(items2);
        boolean result = tree1.isWithinDistance(tree2, new GeometryItemDistance(), distance);
        STRtreeNearestNeighbourTest.assertEquals((boolean)result, (boolean)expected);
    }

    private boolean isEqualUnordered(Object[] items, Geometry g1, Geometry g2) {
        return this.isEqual(items, g1, g2) || this.isEqual(items, g2, g1);
    }

    private boolean isEqual(Object[] items, Geometry g1, Geometry g2) {
        return g1.equalsExact((Geometry)items[0]) && g2.equalsExact((Geometry)items[1]);
    }

    private STRtree createTree(Geometry items) {
        STRtree tree = new STRtree();
        for (int i = 0; i < items.getNumGeometries(); ++i) {
            Geometry item = items.getGeometryN(i);
            tree.insert(item.getEnvelopeInternal(), (Object)item);
        }
        return tree;
    }

    public void testKNearestNeighbors() {
        int i;
        int topK = 1000;
        int totalRecords = 10000;
        GeometryFactory geometryFactory = new GeometryFactory();
        Coordinate coordinate = new Coordinate(10.1, -10.1);
        Point queryCenter = geometryFactory.createPoint(coordinate);
        int valueRange = 1000;
        ArrayList<Point> testDataset = new ArrayList<Point>();
        ArrayList correctData = new ArrayList();
        Random random = new Random();
        GeometryDistanceComparator distanceComparator = new GeometryDistanceComparator(queryCenter, true);
        for (i = 0; i < totalRecords; ++i) {
            coordinate = new Coordinate(-100.0 + (double)random.nextInt(valueRange) * 1.1, (double)random.nextInt(valueRange) * -5.1);
            Point spatialObject = geometryFactory.createPoint(coordinate);
            testDataset.add(spatialObject);
        }
        Collections.sort(testDataset, distanceComparator);
        for (i = 0; i < topK; ++i) {
            correctData.add(testDataset.get(i));
        }
        STRtree strtree = new STRtree();
        for (int i2 = 0; i2 < totalRecords; ++i2) {
            strtree.insert(((Geometry)testDataset.get(i2)).getEnvelopeInternal(), testDataset.get(i2));
        }
        strtree.query(new Envelope(1.1, 1.1, 2.1, 2.1));
        Object[] testTopK = strtree.nearestNeighbour(queryCenter.getEnvelopeInternal(), queryCenter, new GeometryItemDistance(), topK);
        List<Object> topKList = Arrays.asList(testTopK);
        Collections.sort(topKList, distanceComparator);
        int difference = 0;
        for (int i3 = 0; i3 < topK; ++i3) {
            if (distanceComparator.compare((Geometry)correctData.get(i3), (Geometry)topKList.get(i3)) == 0) continue;
            ++difference;
        }
        STRtreeNearestNeighbourTest.assertEquals((int)difference, (int)0);
    }
}

