/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import test.jts.GeometryTestCase;
import test.jts.GeometryTestData;

public class GeometryCompareToTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(GeometryCompareToTest.class);
    }

    public GeometryCompareToTest(String name) {
        super(name);
    }

    public void testPoints() {
        this.checkCompareTo(-1, "POINT (0 0)", "POINT (1 0)");
        this.checkCompareTo(-1, "POINT (0 0)", "POINT (0 1)");
        this.checkCompareTo(1, "POINT (1 0)", "POINT (0 1)");
    }

    public void testLines() {
        this.checkCompareTo(-1, "LINESTRING ( 0 0, 1 1, 0 1)", "LINESTRING ( 0 0, 1 1, 0 2)");
    }

    public void testPolygonToPolygonWithHole() {
        this.checkCompareTo(-1, GeometryTestData.WKT_POLY, GeometryTestData.WKT_POLY_HOLE);
    }

    public void testEqual() {
        this.checkCompareTo(0, GeometryTestData.WKT_POINT, GeometryTestData.WKT_POINT);
        this.checkCompareTo(0, GeometryTestData.WKT_LINESTRING, GeometryTestData.WKT_LINESTRING);
        this.checkCompareTo(0, GeometryTestData.WKT_POLY, GeometryTestData.WKT_POLY);
        this.checkCompareTo(0, GeometryTestData.WKT_POLY_HOLE, GeometryTestData.WKT_POLY_HOLE);
    }

    public void testOrdering() {
        this.checkCompareTo(-1, GeometryTestData.WKT_POINT, GeometryTestData.WKT_MULTIPOINT);
        this.checkCompareTo(-1, GeometryTestData.WKT_MULTIPOINT, GeometryTestData.WKT_LINESTRING);
        this.checkCompareTo(-1, GeometryTestData.WKT_LINESTRING, GeometryTestData.WKT_LINEARRING);
        this.checkCompareTo(-1, GeometryTestData.WKT_LINEARRING, GeometryTestData.WKT_MULTILINESTRING);
        this.checkCompareTo(-1, GeometryTestData.WKT_MULTILINESTRING, GeometryTestData.WKT_POLY);
        this.checkCompareTo(-1, GeometryTestData.WKT_POLY, GeometryTestData.WKT_MULTIPOLYGON);
        this.checkCompareTo(-1, GeometryTestData.WKT_MULTIPOLYGON, GeometryTestData.WKT_GC);
    }

    private void checkCompareTo(int compExpected, String wkt1, String wkt2) {
        Geometry g1 = this.read(wkt1);
        Geometry g2 = this.read(wkt2);
        int comp = g1.compareTo(g2);
        GeometryCompareToTest.assertEquals((int)compExpected, (int)comp);
    }
}

