/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.PrecisionModel;
import test.jts.GeometryTestCase;

public class CoordinateArraysTest
extends GeometryTestCase {
    private static Coordinate[] COORDS_1 = new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0), new Coordinate(3.0, 3.0)};
    private static Coordinate[] COORDS_EMPTY = new Coordinate[0];

    public static void main(String[] args) {
        TestRunner.run(CoordinateArraysTest.class);
    }

    public CoordinateArraysTest(String name) {
        super(name);
    }

    public void testPtNotInList1() {
        CoordinateArraysTest.assertTrue((boolean)CoordinateArrays.ptNotInList(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0), new Coordinate(3.0, 3.0)}, new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(1.0, 2.0), new Coordinate(1.0, 3.0)}).equals2D(new Coordinate(2.0, 2.0)));
    }

    public void testPtNotInList2() {
        CoordinateArraysTest.assertTrue((CoordinateArrays.ptNotInList(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0), new Coordinate(3.0, 3.0)}, new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0), new Coordinate(3.0, 3.0)}) == null ? 1 : 0) != 0);
    }

    public void testEnvelope1() {
        CoordinateArraysTest.assertEquals((Object)CoordinateArrays.envelope(COORDS_1), (Object)new Envelope(1.0, 3.0, 1.0, 3.0));
    }

    public void testEnvelopeEmpty() {
        CoordinateArraysTest.assertEquals((Object)CoordinateArrays.envelope(COORDS_EMPTY), (Object)new Envelope());
    }

    public void testIntersection_envelope1() {
        CoordinateArraysTest.assertTrue((boolean)CoordinateArrays.equals(CoordinateArrays.intersection(COORDS_1, new Envelope(1.0, 2.0, 1.0, 2.0)), new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0)}));
    }

    public void testIntersection_envelopeDisjoint() {
        CoordinateArraysTest.assertTrue((boolean)CoordinateArrays.equals(CoordinateArrays.intersection(COORDS_1, new Envelope(10.0, 20.0, 10.0, 20.0)), COORDS_EMPTY));
    }

    public void testIntersection_empty_envelope() {
        CoordinateArraysTest.assertTrue((boolean)CoordinateArrays.equals(CoordinateArrays.intersection(COORDS_EMPTY, new Envelope(1.0, 2.0, 1.0, 2.0)), COORDS_EMPTY));
    }

    public void testIntersection_coords_emptyEnvelope() {
        CoordinateArraysTest.assertTrue((boolean)CoordinateArrays.equals(CoordinateArrays.intersection(COORDS_1, new Envelope()), COORDS_EMPTY));
    }

    public void testReverseEmpty() {
        Coordinate[] pts = new Coordinate[]{};
        this.checkReversed(pts);
    }

    public void testReverseSingleElement() {
        Coordinate[] pts = new Coordinate[]{new Coordinate(1.0, 1.0)};
        this.checkReversed(pts);
    }

    public void testReverse2() {
        Coordinate[] pts = new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0)};
        this.checkReversed(pts);
    }

    public void testReverse3() {
        Coordinate[] pts = new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0), new Coordinate(3.0, 3.0)};
        this.checkReversed(pts);
    }

    private void checkReversed(Coordinate[] pts) {
        Coordinate[] ptsRev = CoordinateArrays.copyDeep(pts);
        CoordinateArrays.reverse(ptsRev);
        CoordinateArraysTest.assertEquals((int)pts.length, (int)ptsRev.length);
        int len = pts.length;
        for (int i = 0; i < pts.length; ++i) {
            this.checkEqualXY(pts[i], ptsRev[len - 1 - i]);
        }
    }

    public void testScrollRing() {
        Coordinate[] sequence = CoordinateArraysTest.createCircle(new Coordinate(10.0, 10.0), 9.0);
        Coordinate[] scrolled = CoordinateArraysTest.createCircle(new Coordinate(10.0, 10.0), 9.0);
        CoordinateArrays.scroll(scrolled, 12);
        int io = 12;
        for (int is = 0; is < scrolled.length - 1; ++is) {
            CoordinateArraysTest.checkCoordinateAt(sequence, io, scrolled, is);
            ++io;
            io %= scrolled.length - 1;
        }
        CoordinateArraysTest.checkCoordinateAt(scrolled, 0, scrolled, scrolled.length - 1);
    }

    public void testScroll() {
        Coordinate[] sequence = CoordinateArraysTest.createCircularString(new Coordinate(20.0, 20.0), 7.0, 0.1, 22);
        Coordinate[] scrolled = CoordinateArraysTest.createCircularString(new Coordinate(20.0, 20.0), 7.0, 0.1, 22);
        CoordinateArrays.scroll(scrolled, 12);
        int io = 12;
        for (int is = 0; is < scrolled.length - 1; ++is) {
            CoordinateArraysTest.checkCoordinateAt(sequence, io, scrolled, is);
            ++io;
            io %= scrolled.length;
        }
    }

    public void testEnforceConsistency() {
        Coordinate[] array = new Coordinate[]{new Coordinate(1.0, 1.0, 0.0), new CoordinateXYM(2.0, 2.0, 1.0)};
        Coordinate[] array2 = new Coordinate[]{new CoordinateXY(1.0, 1.0), new CoordinateXY(2.0, 2.0)};
        CoordinateArrays.enforceConsistency(array);
        CoordinateArraysTest.assertEquals((int)3, (int)CoordinateArrays.dimension(array));
        CoordinateArraysTest.assertEquals((int)1, (int)CoordinateArrays.measures(array));
        CoordinateArrays.enforceConsistency(array2);
        Coordinate[] fixed = CoordinateArrays.enforceConsistency(array2, 2, 0);
        CoordinateArraysTest.assertSame((Object)fixed, (Object)array2);
        fixed = CoordinateArrays.enforceConsistency(array, 3, 0);
        CoordinateArraysTest.assertTrue((fixed != array ? 1 : 0) != 0);
        CoordinateArraysTest.assertTrue((array[0] != fixed[0] ? 1 : 0) != 0);
        CoordinateArraysTest.assertTrue((array[1] != fixed[1] ? 1 : 0) != 0);
    }

    private static void checkCoordinateAt(Coordinate[] seq1, int pos1, Coordinate[] seq2, int pos2) {
        Coordinate c1 = seq1[pos1];
        Coordinate c2 = seq2[pos2];
        CoordinateArraysTest.assertEquals((String)("unexpected x-ordinate at pos " + pos2), (Object)c1.getX(), (Object)c2.getX());
        CoordinateArraysTest.assertEquals((String)("unexpected y-ordinate at pos " + pos2), (Object)c1.getY(), (Object)c2.getY());
    }

    private static Coordinate[] createCircle(Coordinate center, double radius) {
        Coordinate[] res = CoordinateArraysTest.createCircularString(center, radius, 0.0, 49);
        res[48] = res[0].copy();
        return res;
    }

    private static Coordinate[] createCircularString(Coordinate center, double radius, double startAngle, int numPoints) {
        int numSegmentsCircle = 48;
        double angleCircle = Math.PI * 2;
        double angleStep = 0.1308996938995747;
        Coordinate[] sequence = new Coordinate[numPoints];
        PrecisionModel pm = new PrecisionModel(1000.0);
        double angle = startAngle;
        for (int i = 0; i < numPoints; ++i) {
            double dx = Math.cos(angle) * radius;
            double dy = Math.sin(angle) * radius;
            sequence[i] = new CoordinateXY(pm.makePrecise(center.x + dx), pm.makePrecise(center.y + dy));
            angle += 0.1308996938995747;
            angle %= Math.PI * 2;
        }
        return sequence;
    }
}

