/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.match;

import org.locationtech.jts.algorithm.match.HausdorffSimilarityMeasure;
import org.locationtech.jts.geom.Geometry;
import test.jts.GeometryTestCase;

public class HausdorffSimilarityMeasureTest
extends GeometryTestCase {
    public HausdorffSimilarityMeasureTest(String name) {
        super(name);
    }

    public void testEqualGeometriesReturn1() {
        Geometry g1 = this.read("POINT(1 1)");
        Geometry g2 = this.read("POINT(1 1)");
        HausdorffSimilarityMeasureTest.assertEquals((String)"Point", (Object)1.0, (Object)new HausdorffSimilarityMeasure().measure(g1, g2));
        g1 = this.read("LINESTRING(1 1, 2 1)");
        g2 = this.read("LINESTRING(1 1, 2 1)");
        HausdorffSimilarityMeasureTest.assertEquals((String)"LineString", (Object)1.0, (Object)new HausdorffSimilarityMeasure().measure(g1, g2));
        g1 = this.read("POLYGON((0 0, 0 10, 10 0, 0 0), (1 1, 7.58 1, 1 7.58, 1 1))");
        g2 = this.read("POLYGON((0 0, 0 10, 10 0, 0 0), (1 1, 7.58 1, 1 7.58, 1 1))");
        HausdorffSimilarityMeasureTest.assertEquals((String)"POLYGON", (Object)1.0, (Object)new HausdorffSimilarityMeasure().measure(g1, g2));
    }

    public void testGreaterHausdorffDistanceReturnsPoorerSimilarity() {
        Geometry g1 = this.read("LINESTRING(1 1, 2 1.0, 3 1)");
        Geometry g2 = this.read("LINESTRING(1 1, 2 1.1, 3 1)");
        Geometry g3 = this.read("LINESTRING(1 1, 2 1.2, 3 1)");
        HausdorffSimilarityMeasure sm = new HausdorffSimilarityMeasure();
        double m12 = sm.measure(g1, g2);
        double m13 = sm.measure(g1, g3);
        HausdorffSimilarityMeasureTest.assertTrue((String)"Greater distance, poorer similarity", (m13 < m12 ? 1 : 0) != 0);
    }
}

